#!/bin/sh

# Shell script which installs the MaraDNS files in the appropriate directories

# Set the directory with the build-related scripts 
if [ -z "$BUILDDIR" ] ; then
	BUILDDIR="build"
fi

# Set the directory which is the top-level MaraDNS directory
if [ -z "$TOPLEVEL" ] ; then
	TOPLEVEL=`pwd`
fi

cd $TOPLEVEL

# We call install.locations to set BIN, SBIN, MAN1, MAN8, and DOCS
# It is in a separate file to insure that install.sh and uninstall.sh
# have the same values
. $BUILDDIR/install.locations

# Make sure that the various install directories actually exist
if [ ! -d "$BIN" ] ; then
	echo The directory $BIN does not exist.  Please edit the file
	echo install.locations by hand.
	exit 2
fi
if [ ! -d "$SBIN" ] ; then
	echo The directory $SBIN does not exist.  Please edit the file
	echo install.locations by hand.
	exit 3
fi
if [ ! -d "$MAN1" ] ; then
	echo The directory $MAN1 does not exist.  Please edit the file
	echo install.locations by hand.
	exit 4
fi
if [ ! -d "$MAN5" ] ; then
	echo The directory $MAN5 does not exist.  Please edit the file
	echo install.locations by hand.
	exit 7
fi
if [ ! -d "$MAN8" ] ; then
	echo The directory $MAN8 does not exist.  Please edit the file
	echo install.locations by hand.
	exit 5
fi

# Make sure we have a place to put documents
# Thanks to Paul Howard for the following six lines
if [ ! -d "`dirname $DOCS`" ] ; then
	if ! mkdir "`dirname $DOCS`" ; then
		echo unable to make the `dirname $DOCS` directory. 
		exit 6
	fi
fi
if [ ! -d "$DOCS" ] ; then
	if ! mkdir "$DOCS" ; then
		echo unable to make the $DOCS directory. 
		exit 6
	fi
fi

echo Installing MaraDNS, placing programs in $BIN and $SBIN,
echo man pages in $MAN1, $MAN5, 
echo and $MAN8, and documents in $DOCS

# Place the binaries in $BIN and $SBIN

# Install the maradns binary
cd $TOPLEVEL/server
# We remove the file first to avoid the "text file busy" problem
if [ -f $SBIN/maradns ] ; then
	rm $SBIN/maradns
fi
cp maradns $SBIN

# Install the getzone binary
cd $TOPLEVEL/tuzona
cp getzone $BIN

# Install the zoneserver binary
# We remove the file first to avoid the "text file busy" problem
if [ -f $SBIN/zoneserver ] ; then
	rm $SBIN/zoneserver
fi
cp zoneserver $SBIN

# Install the askmara binary
cd $TOPLEVEL/tools
if [ -f $BIN/askmara ] ; then
	rm $BIN/askmara
fi
cp askmara $BIN

# Place the man pages in $MAN1, $MAN5, and $MAN8
if [ -d $TOPLEVEL/doc/$LANGUAGE/man ] ; then
	cd $TOPLEVEL/doc/$LANGUAGE/man
else
	cd $TOPLEVEL/doc/en/man
fi
cp askmara.1 getzone.1 $MAN1
cp maradns.8 zoneserver.8 $MAN8
cp csv1.5 mararc.5 $MAN5

# Place all the documents in $DOCS
cd ..
mkdir $DOCS > /dev/null 2>&1
cp -r * $DOCS
cd $TOPLEVEL
cp maradns.pgp.key $DOCS

# If the system in question does not already have configuration files,
# place example configuration files in /etc
if [ -d docs/$LANGUAGE/examples ] ; then
	cd doc/$LANGUAGE/examples
else
	cd doc/en/examples
fi

if [ ! -f $RPM_BUILD_ROOT/etc/mararc ] ; then
	cp example_mararc $RPM_BUILD_ROOT/etc/mararc
fi
if [ ! -d $RPM_BUILD_ROOT/etc/maradns ] ; then
	mkdir $RPM_BUILD_ROOT/etc/maradns
	chmod 755 $RPM_BUILD_ROOT/etc/maradns
fi
cp example_csv1 $RPM_BUILD_ROOT/etc/maradns/db.example.com

# Finally, set up the startup files, as needed
# Go back to the top-level MaraDNS directory
cd $TOPLEVEL
# And copy over the init files if this system looks to be a sysVish init
# system
if [ -d $RPM_BUILD_ROOT/etc/rc.d/init.d ] ; then
	echo Adding MaraDNS startup scripts
	if [ ! -f $RPM_BUILD_ROOT/etc/rc.d/init.d/maradns ] ; then
	      cp $BUILDDIR/mara.startup $RPM_BUILD_ROOT/etc/rc.d/init.d/maradns
	fi
	if cd $RPM_BUILD_ROOT/etc/rc.d/rc3.d/ ; then
		echo Starting up MaraDNS at runlevel 3
		rm S60maradns
		ln -s ../init.d/maradns S60maradns
	fi
	if cd $RPM_BUILD_ROOT/etc/rc.d/rc5.d/ ; then
		echo starting up MaraDNS at runlevel 5
		rm S60maradns
		ln -s ../init.d/maradns S60maradns
	fi
fi

