#include <linux/input.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include "findpowermate.h"

#define NUM_VALID_PREFIXES 2
#define NUM_EVENT_DEVICES 16

using namespace std;

findpowermate::findpowermate()
{ 
}

findpowermate::~findpowermate()
{
}

int findpowermate::open_powermate(const char *dev, int mode)
{
    const char* valid_prefix[NUM_VALID_PREFIXES] = {"Griffin PowerMate","Griffin SoundKnob"};
    fdf = open(dev, mode);
    if(fdf < 0){
 fprintf(stderr, "Unable to open \"%s\": %s\n", dev, strerror(errno));
 return -1;
  }

  if(ioctl(fdf, EVIOCGNAME(sizeof(name)), name) < 0){
    fprintf(stderr, "\"%s\": EVIOCGNAME failed: %s\n", dev, strerror(errno));
    close(fdf);
    return -1;
  }

  // it's the correct device if the prefix matches what we expect it to be:
  for(i=0; i<NUM_VALID_PREFIXES; i++)
    if(!strncasecmp(name, valid_prefix[i], strlen(valid_prefix[i])))
      return fdf;

  close(fdf);
  return -1;
}

int findpowermate::find_powermate(int mode)
{
  char devname[256];
  int i, r;

  for(i=0; i<NUM_EVENT_DEVICES; i++){
    sprintf(devname, "/dev/input/event%d", i);    
    r = open_powermate(devname, mode);   
    if(r >= 0)
      return r; // r is the file descriptor
  }

  return -1;
}
