/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

void Form3::init()
{
connect(&http, SIGNAL(done(bool)), this, SLOT(httpDone(bool)));

}

void Form3::getit()
{
    result_TE->setText("...Working...");
    website = "www.qrz.com";
    callsign = callsign_LE->text().upper();
    gohere = "/callsign/" + callsign;
    if (callsign_LE->text() == "") {
    	QMessageBox::critical(this, "Empty query",
			      "Please type a callsign.",
			      QMessageBox::Ok, QMessageBox::NoButton);
    }else{
    	file.setName("result.html");
	if (!file.open(IO_WriteOnly)) {
	QMessageBox::warning(this, tr("HTTP Get"),
			      tr("Cannot write to file. %1\n%2")
			      .arg(file.name())
			      .arg(file.errorString()));
	return;
    }		    
	
	http.setHost(website);
	http.get(gohere, &file);
	http.closeConnection();

   }
    file.close();

}


void Form3::httpDone( bool error)
{
if (error)
    QMessageBox::warning(this, tr("HTTP Get"),
			 tr("Error while fetching file with HTTP: %1")
			      .arg(http.errorString()));
file.close();
parseit();
}


void Form3::parseit()
{
if (!file.open(IO_ReadOnly | IO_Translate)) {
	QMessageBox::warning(this, tr("Parser"),
			      tr("Cannot open file. %1\n%2")
			      .arg(file.name())
			      .arg(file.errorString()));
	return;
    }
flag = FALSE;
QString str = "";
int len;
QTextStream in (&file);
// Main parser loop
while (!in.atEnd()){
    lineOdata = in.readLine();
    
    if (lineOdata.find("<b>The callsign", 0) >= 0){
	flag = TRUE;	       
	    }
//    if (lineOdata.find("is not in our database.", 0) >= 0){
//	flag = TRUE;
//	    }    
		
    if (lineOdata.find("<b>" + callsign, 0) >= 0) {
	// Found the callsign stuff
		flag = TRUE;
	    }	
    if ( flag && (lineOdata.find("<p>", 0) >= 0)) {
	flag = FALSE;
    }
    if (flag && (lineOdata.find("<img src=", 0) >= 0)){
	// Pull out the map image info
	snip1 = lineOdata.find("<img src=", 0) + 10;  // Offset of 9 to remove html crap
	snip2 = lineOdata.find("gif", snip1) +4;
	len = (snip2 - 1) - snip1;
	QString resultstr = lineOdata.mid(snip1, len);
	// Now get rid of image in web page data
	snip1 = snip1 -10;
	snip2 = lineOdata.find(">", snip1);
	len = snip2 - snip1 + 1;
	QString junk = lineOdata.remove(snip1, len);
} 
    // Save the line if its good
    if (flag) {
	str = str + lineOdata;
    }
}
 file.close();
// Print result to main window
 result_TE->setText(str);
}


void Form3::saveit()
{
saved_TE->setText(result_TE->text());
}


