/*
 * Copyright (C) 2007 Intel Corporation
 *
 * Author:  Horace Li <horace.li@intel.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libhildondesktop/libhildondesktop.h>

#include "nav-next-app-plugin.h"

//#define ICON "/usr/share/themes/mobilebasic/images/mb_nav_prev_app_btn.png"
#define BUTTON_WIDTH  0
#define BUTTON_HEIGHT 52

HD_DEFINE_PLUGIN (NavNextAppPlugin, nav_next_app_plugin, TASKNAVIGATOR_TYPE_ITEM);

static void nav_next_app_finalize (GObject *object);

static void on_clicked (GtkWidget *button, NavNextAppPlugin *nav_next_plugin )
{
    //nav_next active app
    GList *applications_list = NULL, *iter, *new_entry;
    HDWMApplication *application;
    HDWMEntryInfo *app_info;
    HDWMWindow *window, *newwin, *activewindow;

    HDWM *hdwm = hd_wm_get_singleton();
    if (hdwm != NULL) {
        activewindow = hd_wm_get_active_window();
        if (!activewindow)
            return;

        applications_list = hd_wm_get_applications (hdwm);
        for (iter = applications_list; iter != NULL; iter = g_list_next (iter))
        {
            application = HD_WM_APPLICATION(iter->data);
            window = hd_wm_application_get_active_window (application);
            g_warning ("app: %p; window: %p.\n", application, window);
            if (window == activewindow) {
                new_entry = g_list_previous (iter);
                if (!new_entry) {
                    new_entry = g_list_last((GList *)applications_list);
                }

                newwin = hd_wm_application_get_active_window (HD_WM_APPLICATION (new_entry->data));
                app_info = HD_WM_ENTRY_INFO (newwin);

                if (app_info) {
                    hd_wm_top_item (app_info);
                    g_signal_emit_by_name (hdwm, "entry_info_stack_changed", app_info);
                    break;
                }
            }
        }
    }
}

static void nav_next_app_plugin_init (NavNextAppPlugin *nav_next_plugin)
{
   HDWM *hdwm;
   hdwm = hd_wm_get_singleton ();
   g_object_ref (nav_next_plugin->hdwm);

   //nav_next_plugin->hdwm = hd_wm_get_singleton ();
   //g_object_ref (nav_next_plugin->hdwm);
   //gtk_widget_push_composite_child ();

   GtkWidget *btn = nav_next_plugin->btn = gtk_button_new();
   
   //nav_next_plugin->imgDn = gtk_image_new_from_file (THEME_DIR "/images/mb_nav_next_app_btn_active.png");
   //gtk_button_set_image((GTK_BUTTON (btn)), (GtkWidget *)gtk_image_new_from_file(ICON));

   gtk_widget_set_size_request (btn, BUTTON_WIDTH, BUTTON_HEIGHT);
   g_signal_connect (btn, "clicked", 
		     G_CALLBACK(on_clicked), (gpointer)nav_next_plugin);
   gtk_widget_show_all (btn);
   gtk_container_add (GTK_CONTAINER (nav_next_plugin), btn);

   //gtk_widget_pop_composite_child ();
}

static void nav_next_app_plugin_class_init (NavNextAppPluginClass *class)
{
  GObjectClass   *object_class = G_OBJECT_CLASS (class);
  //object_class->constructor = nav_next_app_constructor;
  object_class->finalize    = nav_next_app_finalize;
}

static void nav_next_app_finalize (GObject *object)
{
   NavNextAppPlugin *nav_next_plugin = NAV_NEXT_APP_PLUGIN (object);	
   g_object_unref (nav_next_plugin->hdwm);
   //g_object_unref (nav_next_plugin->imgDn);
   //g_object_unref (nav_next_plugin->imgUp);
   G_OBJECT_CLASS (nav_next_app_plugin_parent_class)->finalize (object);
}
