/*
 * Copyright (C) 2007 Intel Corporation
 *
 * Author:  Horace Li <horace.li@intel.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef NAV_NEXT_APP_PLUGIN_H
#define NAV_NEXT_APP_PLUGIN_H

#include <glib-object.h>
#include <libhildondesktop/tasknavigator-item.h>
#include <libhildonwm/hd-wm.h>

G_BEGIN_DECLS

typedef struct _NavNextAppPlugin NavNextAppPlugin;
typedef struct _NavNextAppPluginClass NavNextAppPluginClass;
typedef struct _NavNextAppPluginPrivate NavNextAppPluginPrivate;

#define NAV_NEXT_APP_TYPE_PLUGIN            (nav_next_app_plugin_get_type ())
#define NAV_NEXT_APP_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NAV_NEXT_APP_TYPE_PLUGIN, NavNextAppPlugin))
#define NAV_NEXT_APP_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  NAV_NEXT_APP_TYPE_PLUGIN, NavNextAppPluginClass))
#define NAV_NEXT_APP_IS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NAV_NEXT_APP_TYPE_PLUGIN))
#define NAV_NEXT_APP_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  NAV_NEXT_APP_TYPE_PLUGIN))
#define NAV_NEXT_APP_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  NAV_NEXT_APP_TYPE_PLUGIN, NavNextAppPluginClass))

struct _NavNextAppPlugin 
{
   TaskNavigatorItem tnitem;
   HDWM *hdwm;
   GtkWidget *btn;
   NavNextAppPluginPrivate *priv;
};

struct _NavNextAppPluginClass 
{
   TaskNavigatorItemClass parent_class;
};

GType  nav_next_app_plugin_get_type  (void);

G_END_DECLS

#endif //NAV_NEXT_APP_PLUGIN_H
