/*
 * Copyright (C) 2007 Intel Corporation
 *
 * Author:  Bob Spencer <bob.spencer@intel.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libhildondesktop/libhildondesktop.h>

#include "statusbar-plugin.h"

#define BTN_HEIGHT  52
#define BTN_WIDTH_FOR_800 220
#define BTN_WIDTH_FOR_1024 300 

HD_DEFINE_PLUGIN (StatusbarPlugin, statusbar_plugin, TASKNAVIGATOR_TYPE_ITEM);

static void statusbar_finalize (GObject *object);

static void on_clicked (GtkWidget *button, StatusbarPlugin *statusbar_plugin )
{
   //TBD:  Pass click through to statusbar
   g_print ("Statusbar plugin clicked");
}

static void statusbar_plugin_init (StatusbarPlugin *statusbar_plugin)
{
   GtkWidget *btn;

   statusbar_plugin->hdwm = hd_wm_get_singleton ();
   g_object_ref (statusbar_plugin->hdwm);
   //gtk_widget_push_composite_child ();

   btn = statusbar_plugin->btn = gtk_button_new();
   //statusbar_plugin->imgUp = gtk_image_new_from_file (THEME_DIR "/images/mb_statusbar_btn.png");
   //gtk_button_set_image ((GTK_BUTTON (btn)),(GtkWidget*) statusbar_plugin->imgUp);

   int scn_width = 800;
   GdkScreen *screen = gtk_widget_get_screen ((GtkWidget*)statusbar_plugin);
   if (screen != NULL) {
      scn_width = gdk_screen_get_width(screen);
   }
   //gtk_widget_set_size_request ((GtkWidget*)statusbar_plugin, (scn_width == 1024?330:227), 52);
   gtk_widget_set_size_request ((GtkWidget*)statusbar_plugin, (scn_width == 1024 ? BTN_WIDTH_FOR_1024 : BTN_WIDTH_FOR_800), BTN_HEIGHT);

   g_signal_connect (btn, "clicked", G_CALLBACK (on_clicked), (gpointer)statusbar_plugin);

   gtk_widget_show_all (btn);
   gtk_container_add (GTK_CONTAINER (statusbar_plugin), btn);

   //gtk_widget_pop_composite_child ();
}

static void statusbar_plugin_class_init (StatusbarPluginClass *class)
{
  GObjectClass   *object_class = G_OBJECT_CLASS (class);
  //object_class->constructor = statusbar_constructor;
  object_class->finalize    = statusbar_finalize;
}

static void statusbar_finalize (GObject *object)
{
   StatusbarPlugin *statusbar_plugin = STATUSBAR_PLUGIN (object);	
   g_object_unref (statusbar_plugin->hdwm);
   //g_object_unref (statusbar_plugin->imgDn);
   //g_object_unref (statusbar_plugin->imgUp);
   G_OBJECT_CLASS (statusbar_plugin_parent_class)->finalize (object);
}
