/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <syslog.h>

#include "mserver.h"

extern FILE *outsock;

void mserver_stat (void)
{
	char cname[1024];

	cfile_getcname(cname);

	if (shmem_get_dialing() != -1)
	{
		if (child_alive(shmem_get_dialing()))
		{
			fprintf (outsock, "UP:Connection Pending (%s):%d\n", cname, cfile_getcspeed());
			return;
		}
		else
		{
			shmem_set_dialing(-1);
		}
	}

	if (shmem_get_captured())
	{
		shmem_get_capname(cname);
		fprintf (outsock, "CAPTURED:%s:0\n", cname);
		return;
	}

	if (getstat())
	{
		if (shmem_get_pending_kill() == true)
		{
			fprintf (outsock, "DOWN\n");	
		}
		else
		{
			fprintf (outsock, "UP:%s:%d\n", cname, cfile_getcspeed());
		}
	}
	else
	{
		fprintf (outsock, "DOWN\n");	
	}
}
