/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


/////////////////////// Qt includes
#include <QMessageBox>
#include <QCloseEvent>
#include <QDebug>

/////////////////////// Local includes
#include "mzLabOutputOligomerTreeViewDlg.hpp"
#include "mzLabWnd.hpp"

namespace massXpert
{

  MzLabOutputOligomerTreeViewDlg::MzLabOutputOligomerTreeViewDlg 
 (QWidget *parent, 
   QList<OligomerPair *> *oligomerPairList,
   MassType massType,
   MzLabInputOligomerTreeViewDlg *dlg1,
   MzLabInputOligomerTreeViewDlg *dlg2,
   const QString &name)
    : QDialog(parent), 
      mpa_oligomerPairList(oligomerPairList),
      m_massType(massType),
      mp_inputOligomerTreeViewDlg1(dlg1),
      mp_inputOligomerTreeViewDlg2(dlg2),
      m_name(name)
  {
    Q_ASSERT(parent);
    Q_ASSERT(mpa_oligomerPairList);
    Q_ASSERT(mp_inputOligomerTreeViewDlg1);
    Q_ASSERT(mp_inputOligomerTreeViewDlg2);
    
    m_ui.setupUi(this);
    
    mpa_oligomerTreeViewModel = 
      new MzLabOutputOligomerTreeViewModel(mpa_oligomerPairList, this);
      
    m_ui.oligomerTreeView->setModel(mpa_oligomerTreeViewModel);
    mpa_oligomerTreeViewModel->setTreeView(m_ui.oligomerTreeView);

    m_ui.oligomerTreeView->setMzLabWnd(static_cast<MzLabWnd *>(parent));
    m_ui.oligomerTreeView->setParentDlg(this);
    
    mpa_oligomerTreeViewModel->setMzLabWnd(static_cast<MzLabWnd *>(parent));
    mpa_oligomerTreeViewModel->setParentDlg(this);

    m_ui.input1ListNameLineEdit->setText(m_name);
    setWindowTitle(tr("massXpert: mz Lab - %1")
		    .arg(m_name));
  }
  

  MzLabOutputOligomerTreeViewDlg::~MzLabOutputOligomerTreeViewDlg()
  {
    delete mpa_oligomerTreeViewModel;
    while(mpa_oligomerPairList->size())
      delete mpa_oligomerPairList->takeFirst();
  }


  void 
  MzLabOutputOligomerTreeViewDlg::closeEvent(QCloseEvent *event)
  {
    QDialog::closeEvent(event);
  }
  

  void 
  MzLabOutputOligomerTreeViewDlg::setName(const QString &name)
  {
    m_name = name;
    
    m_ui.input1ListNameLineEdit->setText(m_name);
    setWindowTitle(tr("massXpert: mz Lab - %1")
		    .arg(m_name));
  }
  

  QString
  MzLabOutputOligomerTreeViewDlg::name()
  {
    return m_name;
  }

} // namespace massXpert
