/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef MZ_LAB_INPUT_OLIGOMER_TREEVIEW_MODEL_HPP
#define MZ_LAB_INPUT_OLIGOMER_TREEVIEW_MODEL_HPP


/////////////////////// Qt includes
#include <QTreeView>


/////////////////////// Local includes
#include "oligomer.hpp"
#include "oligomerList.hpp"
#include "mzLabInputOligomerTreeView.hpp"
#include "mzLabInputOligomerTreeViewItem.hpp"
#include "mzLabWnd.hpp"


namespace massXpert
{

  class MzLabInputOligomerTreeViewItem;
  class MzLabWnd;
  

  class MzLabInputOligomerTreeViewModel : public QAbstractItemModel
  {
    Q_OBJECT
  
    private:
    OligomerList *mpa_oligomerList;
    
    MzLabInputOligomerTreeViewItem *mpa_rootItem;
    QTreeView *mp_treeView;
    
    MzLabWnd *mp_mzLabWnd;
    MzLabInputOligomerTreeViewDlg *mp_parentDlg;
    
    MassType m_massType;
    
  public:
    MzLabInputOligomerTreeViewModel(QObject *);
  
    ~MzLabInputOligomerTreeViewModel();
  
    MzLabInputOligomerTreeViewDlg *getParentDlg();
    void setParentDlg(MzLabInputOligomerTreeViewDlg *);
    
    MzLabWnd *getMzLabWnd();
    void setMzLabWnd(MzLabWnd *);
    
    const OligomerList *oligomerList() const;
    
    void setTreeView(QTreeView *);
    QTreeView *treeView();
  
    QVariant data(const QModelIndex &, int) const;

    void addOligomer(Oligomer *);
    void removeOligomer(QModelIndex &);
    
    void dataChanged(QModelIndex, QModelIndex);
    
    QVariant headerData(int, Qt::Orientation,
			 int = Qt::DisplayRole) const;
    
    Qt::ItemFlags flags(const QModelIndex &) const;

    QModelIndex index(int, int,
		       const QModelIndex & = QModelIndex()) const;
    
    QModelIndex parent(const QModelIndex &) const;

    int rowCount(const QModelIndex & = QModelIndex()) const;
    int columnCount(const QModelIndex & = QModelIndex()) const;

    bool setupModelData(MzLabInputOligomerTreeViewItem *);
  };

} // namespace massXpert


#endif // MZ_LAB_INPUT_OLIGOMER_TREEVIEW_MODEL_HPP
