#ifndef _HAVE_MBDESKTOP_ITEM_H
#define _HAVE_MBDESKTOP_ITEM_H

#include "mbdesktop.h"

#define mbdesktop_items_enumerate_siblings(item_head, item)  \
     for ( (item)    = item_head;                            \
	   (item)   != NULL;                                 \
	   (item) = (item)->item_next_sibling )              \


MBDesktopItem *mbdesktop_item_new();

void
mbdesktop_item_free(MBDesktop     *mb, 
		    MBDesktopItem *item);

void
mbdesktop_item_folder_contents_free(MBDesktop     *mb, 
				    MBDesktopItem *item_folder);

MBDesktopItem *
mbdesktop_item_new_with_params (MBDesktop     *mb,
			        char          *name, 
			        char          *icon_name,
			        void          *data,
			        int            type);

void
mbdesktop_item_set_icon_from_theme (MBDesktop     *mb,
				    MBDesktopItem *item);

void
mbdesktop_items_append (MBDesktop     *mb,
			MBDesktopItem *item_head,
			MBDesktopItem *item );

void
mbdesktop_items_append_to_folder (MBDesktop      *mb,
				  MBDesktopItem  *item_folder,
				  MBDesktopItem  *item );
void
mbdesktop_items_prepend (MBDesktop     *mb,
			 MBDesktopItem **item_head,
			 MBDesktopItem *item );

MBDesktopItem *
mbdesktop_item_get_first_sibling (MBDesktopItem *item) ;

void
mbdesktop_item_set_icon_data (MBDesktop     *mb, 
			      MBDesktopItem *item, 
			      MBPixbufImage *img);


void
mbdesktop_item_set_image (MBDesktop     *mb, 
			  MBDesktopItem *item, 
			  char          *full_img_path);

void
mbdesktop_item_set_name (MBDesktop     *mb, 
			 MBDesktopItem *item, 
			 char          *name);

void
mbdesktop_item_set_activate_callback (MBDesktop     *mb, 
				      MBDesktopItem *item, 
				      MBDesktopCB    activate_cb);

void
mbdesktop_item_folder_activate_cb(void *data1, void *data2);

void
mbdesktop_item_folder_prev_activate_cb(void *data1, void *data2);

MBDesktopItem *
mbdesktop_item_get_from_coords(MBDesktop *mb, int x, int y);


#endif
