/***************************************************************************
 *   Copyright (C) 2004-2005 by Andreas Ramm                                    *
 *   psychobrain@gmx.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _MATEEDIT_H_
#define _MATEEDIT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdeversion.h>

#if KDE_IS_VERSION( 3,4,0 )
    #define ZEROCONF_MATEEDIT
#else
    #undef ZEROCONF_MATEEDIT
#endif

#include <kmainwindow.h>
#include <kstreamsocket.h>
#include <kserversocket.h>
#include <qcolor.h>
#include <ktextedit.h>
#include "message.h"
#include <qtimer.h>
#include <qthread.h>
#include <qvaluelist.h>
#include <qsplitter.h>
#include <qimage.h>
#include <klistbox.h>
#include <kiconview.h>
#include <qvaluestack.h>
#ifdef ZEROCONF_MATEEDIT
    #include <dnssd/publicservice.h>
#endif


class MateEditClientSocket : public QObject
{
    Q_OBJECT
    public:
        MateEditClientSocket( int client_number, KNetwork::KStreamSocket *s,  QObject *parent = 0,  const char *name = 0 );

        KNetwork::KStreamSocket* socket() const { return m_socket; };
        ~MateEditClientSocket()
        {
            delete m_socket;
        }

    signals:
        void removeConnection( int, MateEditClientSocket * );
    private slots:
        void readClient();

        void connectionClosed()
        {
            emit removeConnection( m_number, this );
            delete this;
        }

    private:
        int m_number;
        KNetwork::KStreamSocket *m_socket;
};

/**
 * @brief Server socket that accepts the client connections
 * @author Andreas Ramm <psychobrain@gmx.net>
 * @version 0.1
 */
class MateEditServerSocket : public KNetwork::KServerSocket
{
    Q_OBJECT
    public:
        MateEditServerSocket ( const QString& sessionName, int backlog = 5, QObject * parent = 0, const char * name = 0, int port = 0);
        ~MateEditServerSocket ();
        QPtrList<MateEditClientSocket> m_client_list;
        QString * m_server_users;
        QImage * m_server_images;
        Q_UINT32 m_client_count;
        int server_counter;
        QValueList<int> * m_available_client_numbers;
    public slots:
        void removeConnection( int, MateEditClientSocket * );
    private slots:
        void newConnection ();
#ifdef ZEROCONF_MATEEDIT
    private:
        DNSSD::PublicService publisher;
#endif
};

/**
 * @brief Server thread to allow simultaneous editing and message forwarding
 * @author Andreas Ramm <psychobrain@gmx.net>
 * @version 0.1
 */
class MateEditServerThread : public QThread
{
    public:
        MateEditServerThread(const QString& name, int port = 0);
        virtual void run();
        const unsigned short port() const;

    private:
        MateEditServerSocket * m_serverSocket;
        QString m_name;
        unsigned short m_port;
};

/**
 * @brief Application Main Window
 * @author Andreas Ramm <psychobrain@gmx.net>
 * @version 0.1
 */
class MateEditMainWindow : public KMainWindow, public MateEdit::Client
{
    Q_OBJECT
    public:
        /**
        * Default Constructor
        */
        MateEditMainWindow();
        QString getText();
        MateEditServerThread * m_serverThread;

        /**
        * Default Destructor
        */

        bool mateEditInit( int user_number, QString & username, QImage & image );
        bool mateEditInitUser( int user_number, const QString & name, const QImage & image );
        bool mateEditRemoveUser( int user_number, const QString & name );
        bool mateEditInsertText( const QString & text, const MateEdit::MessageCoords & from, const MateEdit::MessageCoords & to );
        bool mateEditDeleteText( const QString & text, const MateEdit::MessageCoords & from, const MateEdit::MessageCoords & to );
        bool mateEditMessage( const QString & text );
        bool mateEditChatMessage( const QString & text );
        bool mateEditSessionClosed( const QString & reason );

        virtual ~MateEditMainWindow();
    public slots:
        void initObject();
        /* run all non gui initialisation procedures
        */
        void sendChatMessage();

        void connectionError(int);
        void connectionConnected();
        void connectionPending();
        void connectionClosed();

        void slotFileNew();
        /* clean current document
        */
        void slotFileOpen();
        /* Load an existing file
        */
        void slotFileSave();
        /* If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
        */
        void slotFileSaveAs();
        /* If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
        */
        void slotFileQuit();
        /** put the marked text/object into the clipboard
        */
        void slotEditCopy();
        /** Copy Selection to Clipboard
        */
        void slotEditPaste();
        /** Paste Clipboard content to text
        */
        void slotEditCut();
        /** Cut text and copy to Clipboard
        */

        void slotEditUndo();
        /** Undo editing actions
         */

        void slotEditRedo();
        /** Redo editing actions
         */

        void slotSpelling();
        /** check spelling
        */

        void slotPrint();
        /** print text
        */

        void slotFind();
        /** find text
        */

        void slotReplace();
        /** replace text
        */
        void slotSetLastChatVisible();
        /** Ensure the last chat message is visible to user
        */
        void slotTextfieldModified(bool);
    protected:
        KTextEdit * m_textfield;
        Q_UINT32 m_local_pc;
        KAction* fileNew;
        KAction* fileOpen;
        KAction* fileSave;
        KAction* fileSaveAs;
        KAction* fileQuit;
        KAction* editCopy;
        KAction* editPaste;
        KAction* editCut;
        KAction* editUndo;
        KAction* editRedo;
        KAction* spelling;
        KAction* print;
        KAction* find;
        KAction* replace;

        QTimer m_timer;
        QString m_filename;
        QIconViewItem * m_user_icons[MATEEDIT_MAX_USERS];
        KIconView * m_user_view;
        QSplitter * m_splitter;
        KListBox * m_chat_list;
        KLineEdit * m_chat_edit;
        unsigned int m_color_selection;
        MateEdit::SyntaxHighlighter * m_highLighter;
        bool eventFilter( QObject *, QEvent * );
        MateEdit::MateEdit * m_mateedit;
        QValueStack<int> undo_stack;
        QValueStack<int> redo_stack;
};



#endif // _MATEEDIT_H_
