(* Copyright (C) 2006, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://helm.cs.unibo.it/
 *)

type statement_test =
  GrafiteParser.ast_statement GrafiteParser.localized_option -> bool

  (** @param status initial status, defaults to LexiconEngine.initial_status
   * @param callback if given it will be invoked as soon as a matching
   * statement is found (i.e. it provides incremental notification in case
   * grepping takes a while) *)
val grep_statement:
  ?status: LexiconEngine.status ->
  ?callback: (string -> unit) ->
  fname:string -> statement_test ->
    string list

  (** As above, but act on all file (recursively) located under directory
   * dirname whose name matches fname_test. Default test matches files with
   * extension ".ma".
   * @return list of pairs <fname, raw statement>, as "grep -H" would do *)
val rgrep_statement:
  ?status: LexiconEngine.status ->
  ?callback: (string * string -> unit) ->
  ?fname_test:(string -> bool) -> dirname:string -> statement_test ->
    (string * string) list

