(* Copyright (C) 2005, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://helm.cs.unibo.it/
 *)

(* $Id: disambiguatePp.ml 7922 2007-11-25 13:12:25Z tassi $ *)

open DisambiguateTypes

let alias_of_domain_and_codomain_items domain_item (dsc,_) =
 match domain_item with
    Id id -> LexiconAst.Ident_alias (id, dsc)
  | Symbol (symb, i) -> LexiconAst.Symbol_alias (symb, i, dsc)
  | Num i -> LexiconAst.Number_alias (i, dsc)

let aliases_of_environment env =
  Environment.fold
    (fun domain_item codomain_item acc ->
      alias_of_domain_and_codomain_items domain_item codomain_item::acc
    ) env []

let aliases_of_domain_and_codomain_items_list l =
  List.fold_left
    (fun acc (domain_item,codomain_item) ->
      alias_of_domain_and_codomain_items domain_item codomain_item::acc
    ) [] l

let pp_environment env =
  let aliases = aliases_of_environment env in
  let strings =
    List.map (fun alias -> LexiconAstPp.pp_alias alias ^ ".") aliases
  in
  String.concat "\n" (List.sort compare strings)
