(*
    ||M||  This file is part of HELM, an Hypertextual, Electronic        
    ||A||  Library of Mathematics, developed at the Computer Science     
    ||T||  Department, University of Bologna, Italy.                     
    ||I||                                                                
    ||T||  HELM is free software; you can redistribute it and/or         
    ||A||  modify it under the terms of the GNU General Public License   
    \   /  version 2 or (at your option) any later version.      
     \ /   This software is distributed as is, NO WARRANTY.     
      V_______________________________________________________________ *)

(* $Id: nCicEnvironment.mli 8605 2008-05-19 23:01:48Z sacerdot $ *)

exception CircularDependency of string Lazy.t;;
exception ObjectNotFound of string Lazy.t;;
exception BadDependency of string Lazy.t;;
exception BadConstraint of string Lazy.t;;

val get_checked_obj: NUri.uri -> NCic.obj

val get_relevance: NReference.reference -> bool list

val type0: NCic.universe
(* universe_* raise BadConstraints if the second arg. is an inferred universe *)
val universe_eq: NCic.universe -> NCic.universe -> bool
val universe_leq: NCic.universe -> NCic.universe -> bool
(* add_constraint raise BadConstraint in case of universe inconsistency
   or if the second argument is an inferred universe
   true -> strict check (<); false -> loose check (<=)
*)
val add_constraint: bool -> NCic.universe -> NCic.universe -> unit

val get_checked_def:
  NReference.reference -> 
    NCic.relevance * string * NCic.term * NCic.term * NCic.c_attr * int

(* the last integer is the index of the inductive type in the reference *)
val get_checked_indtys:
  NReference.reference -> 
    bool * int * NCic.inductiveType list * NCic.i_attr * int

val get_checked_fixes_or_cofixes:
  NReference.reference -> 
   NCic.inductiveFun list * NCic.f_attr * int

val invalidate: unit -> unit

val set_typecheck_obj: (NCic.obj -> unit) -> unit

(* EOF *)
