/*!
    @file           DBMCli_EventingBranding
    @author         MarcW
    @brief          Branding strings

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2003-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/

#ifndef _DBMCli_EventingBranding_HPP_
#define _DBMCli_EventingBranding_HPP_

/*
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
*/
#include "DBM/Cli/DBMCli_Stuff.hpp"

/*!
    @brief     Eventing Branding class

    This class just contains strings for branding the eventing.
 */
class DBMCli_EventingBranding
{
public:
    /*! @brief product name */
    static const DBMCli_String sProductName;

    /*! @brief version label */
    static const DBMCli_String sVersionLabel;
};

const DBMCli_String DBMCli_EventingBranding::sProductName("MaxDB Eventing");
const DBMCli_String DBMCli_EventingBranding::sVersionLabel("Version");

#endif /*_DBMCli_EventingBranding_HPP_*/
