/*

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/
#include "Oms/OMS_SharedMemAllocator.hpp"
#include "Oms/OMS_Globals.hpp"
#include "Oms/OMS_Malloc.hpp"
#ifdef USE_SYSTEM_ALLOC_CO13
#include "geo573.h"
#endif

OMS_SharedMemAllocator OMS_Globals::m_sharedMemAllocatorInstance;

OMS_SharedMemAllocator::OMS_SharedMemAllocator() {}

void* OMS_SharedMemAllocator::allocateImpl(size_t size)
{
  return OMS_Globals::KernelInterfaceInstance->OmsAllocate(size);
}

void OMS_SharedMemAllocator::deallocateImpl(void* p) 
{
  if (NULL == p) { 
    return;
  }
  OMS_Globals::KernelInterfaceInstance->OmsDeallocate(p);
}


#if defined( USE_SYSTEM_ALLOC_CO13 ) && defined( WIN32 )
void *operator new(size_t sz) THROW_NEW_GEO573 
{
	return omsMalloc(sz);
}

void *operator new[](size_t sz) THROW_NEW_GEO573
{
	return omsMallocArray(sz);
}

void operator delete(void *p) THROW_DELETE_GEO573
{
	omsFree(p);
}

void operator delete[](void *p) THROW_DELETE_GEO573
{
	omsFreeArray(p);
}
#endif
