/*! 
  -----------------------------------------------------------------------------
  module: hcn84.h
  -----------------------------------------------------------------------------
 
  responsible:  MartinR
  special area: DBMServer
  description:  specification module for kernel trace 
  version:      7.2.
  copyright:    (c) 2000-2004 SAP AG
 
  -----------------------------------------------------------------------------
 

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




  -----------------------------------------------------------------------------
*/
 

#ifndef _HCN84_H_
#define _HCN84_H_

/* 
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
*/

#include "gcn00.h"

/* 
  -----------------------------------------------------------------------------
  specification public macros
  -----------------------------------------------------------------------------
*/

/* 
  -----------------------------------------------------------------------------
  specification public functions
  -----------------------------------------------------------------------------
*/

/*!
  -----------------------------------------------------------------------------
  function:     cn84TraceShow
  -----------------------------------------------------------------------------

  description:  

  arguments:    vcontrol    [INOUT]  - DBMServer session data
                command     [IN]     - DBMServer command
                replyData   [OUT]    - reply buffer
                replyLen    [OUT]    - lenght of reply
                replyLenMax [IN]     - max. length of reply buffer

  return value: error code specified in gcn00.h
 
  -----------------------------------------------------------------------------
 */
tcn00_Error cn84TraceShow
      ( VControlDataT * vcontrol,
        CommandT      * command,
        char          * replyData,
        int           * replyLen,
        int             replyLenMax);

/*!
  -----------------------------------------------------------------------------
  function:     cn84TraceOn
  -----------------------------------------------------------------------------

  description:  

  arguments:    vcontrol    [INOUT]  - DBMServer session data
                command     [IN]     - DBMServer command
                replyData   [OUT]    - reply buffer
                replyLen    [OUT]    - lenght of reply
                replyLenMax [IN]     - max. length of reply buffer

  return value: error code specified in gcn00.h
 
  -----------------------------------------------------------------------------
 */
tcn00_Error cn84TraceOn
      ( VControlDataT * vcontrol,
        CommandT      * command,
        char          * replyData,
        int           * replyLen,
        int             replyLenMax);

/*!
  -----------------------------------------------------------------------------
  function:     cn84TraceOff
  -----------------------------------------------------------------------------

  description:  

  arguments:    vcontrol    [INOUT]  - DBMServer session data
                command     [IN]     - DBMServer command
                replyData   [OUT]    - reply buffer
                replyLen    [OUT]    - lenght of reply
                replyLenMax [IN]     - max. length of reply buffer

  return value: error code specified in gcn00.h
 
  -----------------------------------------------------------------------------
 */
tcn00_Error cn84TraceOff
      ( VControlDataT * vcontrol,
        CommandT      * command,
        char          * replyData,
        int           * replyLen,
        int             replyLenMax);

/*!
  -----------------------------------------------------------------------------
  function:     cn84TraceFlush
  -----------------------------------------------------------------------------

  description:  

  arguments:    vcontrol    [INOUT]  - DBMServer session data
                command     [IN]     - DBMServer command
                replyData   [OUT]    - reply buffer
                replyLen    [OUT]    - lenght of reply
                replyLenMax [IN]     - max. length of reply buffer

  return value: error code specified in gcn00.h
 
  -----------------------------------------------------------------------------
 */
tcn00_Error cn84TraceFlush
      ( VControlDataT * vcontrol,
        CommandT      * command,
        char          * replyData,
        int           * replyLen,
        int             replyLenMax);

/*!
  -----------------------------------------------------------------------------
  function:     cn84TraceClear
  -----------------------------------------------------------------------------

  description:  

  arguments:    vcontrol    [INOUT]  - DBMServer session data
                command     [IN]     - DBMServer command
                replyData   [OUT]    - reply buffer
                replyLen    [OUT]    - lenght of reply
                replyLenMax [IN]     - max. length of reply buffer

  return value: error code specified in gcn00.h
 
  -----------------------------------------------------------------------------
 */
tcn00_Error cn84TraceClear
      ( VControlDataT * vcontrol,
        CommandT      * command,
        char          * replyData,
        int           * replyLen,
        int             replyLenMax);

/*!
  -----------------------------------------------------------------------------
  function:     cn84TraceProtOpt
  -----------------------------------------------------------------------------

  description:  

  arguments:    vcontrol    [INOUT]  - DBMServer session data
                command     [IN]     - DBMServer command
                replyData   [OUT]    - reply buffer
                replyLen    [OUT]    - lenght of reply
                replyLenMax [IN]     - max. length of reply buffer

  return value: error code specified in gcn00.h
 
  -----------------------------------------------------------------------------
 */
tcn00_Error cn84TraceProtOpt
      ( VControlDataT * vcontrol,
        CommandT      * command,
        char          * replyData,
        int           * replyLen,
        int             replyLenMax);

/*!
  -----------------------------------------------------------------------------
  function:     cn84TraceProt
  -----------------------------------------------------------------------------

  description:  

  arguments:    vcontrol    [INOUT]  - DBMServer session data
                command     [IN]     - DBMServer command
                replyData   [OUT]    - reply buffer
                replyLen    [OUT]    - lenght of reply
                replyLenMax [IN]     - max. length of reply buffer

  return value: error code specified in gcn00.h
 
  -----------------------------------------------------------------------------
 */
tcn00_Error cn84TraceProt
      ( VControlDataT * vcontrol,
        CommandT      * command,
        char          * replyData,
        int           * replyLen,
        int             replyLenMax);

/*!
  -----------------------------------------------------------------------------
  function:     cn84SaveTrace
  -----------------------------------------------------------------------------

  description:  saves the trace settings to config file
                
                Function reads the current vtrace configuration from the database 
                kernel and saves it to the dbm.cfg file.

  arguments:    szDbName    [IN]     - name of database
                replyData   [OUT]    - reply buffer
                replyLen    [OUT]    - lenght of reply

  return value: error code specified in gcn00.h
 
  -----------------------------------------------------------------------------
 */
tcn00_Error cn84SaveTrace
      ( tsp00_DbNamec        szDbName,
        char               * replyData = NULL,
        int                * replyLen  = NULL);

/*!
  -----------------------------------------------------------------------------
  function:     cn84RestoreTrace
  -----------------------------------------------------------------------------

  description:  restore the trace settings from config file
                
                Function reads the current vtrace configuration from the config
                file and enable the vtrace in the kernel

  arguments:    szDbName    [IN]     - name of database

  return value: error code specified in gcn00.h
 
  -----------------------------------------------------------------------------
 */
tcn00_Error cn84RestoreTrace
      ( tsp00_DbNamec        szDbName );

#endif /* #ifndef _HCN84_H_ */
