/*!
  @file           hcn85.h
  @author         Bernd Vorsprach - bernd.vorsprach@sap.com
  @author         Martin Reinecke - martin.reinecke@sap.com
  @brief          kernel connect/release/execute

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2003-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/

#ifndef _HCN85_H_
#define _HCN85_H_

/* IMPORT
 * ------------------------------------------------------------------
 */
#include "gcn00.h"

/* 
  SPECIFICATION PUBLIC FUNCTIONS
  ------------------------------------------------------------------
 */

/*! @brief Connect to kernel task */
tcn00_Error cn85DBConnect (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

/*! @brief Disconnect from kernel task */
tcn00_Error cn85DBRelease (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

/*! @brief Execute any statement with kernel task */
tcn00_Error cn85DBExecute (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

/*! @brief Execute any statement with kernel task in "nice" answer format */
tcn00_Error cn85DBExecuteNice (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

/*! @brief Fetch result from kernel task */
tcn00_Error cn85DBFetch (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

/*! @brief Fetch result from kernel task in "nice" answer format */
tcn00_Error cn85DBFetchNice (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

/*! @brief Execute SQL, DDL, DML statement with kernel task */
tcn00_Error cn85DBExecuteSQL (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

/*! @brief Free the session structure */
void cn85FreeKernelSession(
      VControlDataT     * vcontrol);

/*! @brief Free the session structure 
 
    @param  vcontrol   [IN]    the well knonw DBMServer session structure
    @param  replyData  [IN]    the well known DBMServer answer buffer
    @param  replyLen   [OUT]   the well known DBMServer answer length
    @param  bTemporary [INOUT] flag for temporary sessions
    */

tcn00_Error cn85GetKernelSession
  ( VControlDataT *          vcontrol, 
    char          *          replyData,
    int           *          replyLen, 
    bool                   & bTempConnect );

#endif /* _HCN85_H_ */

