/* @lastChanged: "1998-10-06  15:03"
 * @filename:    ven38.cpp
 * @purpose:     "COM_Interface"
 * @release:     7.2.0.0
 * @see:         ""
 *
 * @copyright:   (c) 1998-2004 SAP AG"



    ========== licence begin  GPL
    Copyright (c) 1998-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




 */

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#if defined(NMP)
#define RWSTD_NO_NAMESPACE  1
#include <sys/user.h>
#endif

#include "gsp00.h"
#include "heo01.h"
#include "heo02x.h"
#include "heo78.h"
#include "heo00.h" //
#include "Oms/OMS_Defines.h"
#include "geo00d.h"
#include "hak341.h"
#include "geo38.h"
#include "hen38.h"

#include "heo52.h"
#include "vsp002c.h"
#include "heo46.h"
#include "geo60.h"
#include "heo60.h"
#include "geo50_0.h"
#include "gen500.h"
#include "geo60.h"
#include "heo38.h"
#include "geo573.h" // PTS 1112369
#include "liveCache/LVC_Dispatcher.hpp" // for DCOM memory
#include "liveCache/LVC_LoadLibrary.hpp"

 /*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

#ifdef NO_INLINES
# define _INLINE
#else
# define _INLINE	inline
#endif

typedef BOOL (*DLLMAIN) (HANDLE hInstance,
                         DWORD  dwReason, 
                         char*  szModule);

typedef HRESULT (*DLLGETCLASSOBJECT) (REFCLSID rclsid, REFIID riid, LPVOID* ppv);

/*---------------------------------------------------------------------------*/

//long sql38CoCreateInstance(CLSID *rclsid, REFIID riid, LPVOID FAR* ppv)
//{
//  ROUTINE_DBG_MEO00 ("sql38CoCreateInstance");
//  return -1;   /* not yet implemented */
//};


/*---------------------------------------------------------------------------*/

long sql38CoGetClassObject(CLSID *rclsid, REFIID riid, LPVOID FAR* ppv)
{
  ROUTINE_DBG_MEO00 ("sql38CoGetClassObject");

  teo78_ClsID       szClsID;
  teo78_Result      rc;
  teo78_ModuleName  ModuleName;
  teo78_ModuleName  OmsLibPath;
  tsp00_ErrText       errtext;
  HANDLE            hd;
  DLLMAIN           DllMain;
  DLLGETCLASSOBJECT DllGetClassObject;
  char              msgBuffer[256];         

  sprintf(szClsID,"{%8.8X-%4.4X-%4.4X-%2.2X%2.2X-%2.2X%2.2X%2.2X%2.2X%2.2X%2.2X}",
    rclsid->Data1, rclsid->Data2, rclsid->Data3,
    rclsid->Data4[0], rclsid->Data4[1], rclsid->Data4[2],
    rclsid->Data4[3], rclsid->Data4[4], rclsid->Data4[5],
    rclsid->Data4[6], rclsid->Data4[7] );


  tsp00_Pathc szInstPath;
  tsp01_RteError rteError;

  rc = sqlComObjectGetByClsID(szClsID, ModuleName);
  if ( success_eo78 != rc ) 
  {
    switch (rc) 
    {
    case illegal_parameter_eo78:
      sprintf(msgBuffer,"sqlComObjectGetByClsID: illegal_parameter");
      break;
    case access_denied_eo78:
      sprintf(msgBuffer,"sqlComObjectGetByClsID: access_denied_eo78");
      break;
    case entry_not_found_eo78:
      sprintf(msgBuffer,"sqlComObjectGetByClsID: entry_not_found_eo78");
      break;
    default:
      sprintf(msgBuffer,"sqlComObjectGetByClsID with error");     
    }
    MSGD ((ERR_DCOM_DUMP_INFO, msgBuffer));
    return GEO00D_DCOM_COCLASS_IN_REGISTRY_NOT_FOUND;
  }

 	LVC_LoadLibrary(&ModuleName[0], false, &hd, errtext, sizeof(tsp00_ErrText));
  if ( hd == 0 ) 
  {
    return GEO00D_DCOM_LIBRARY_NOT_LOADABLE;
  }
  
  DllMain = (DLLMAIN)sqlGetProcAddress(hd, "DllMain", errtext, sizeof(tsp00_ErrText)-1 );
  if ( NULL == DllMain )
  {
    return GEO00D_DCOM_DLL_MAIN_MISSING;
  }

  if ( ! DllMain(hd, DLL_PROCESS_ATTACH, &ModuleName[0]))
  {
    return GEO00D_DCOM_DLL_MAIN_ERROR;
  }

  DllGetClassObject = (DLLGETCLASSOBJECT)sqlGetProcAddress(hd, 
                            "DllGetClassObject", errtext, sizeof(tsp00_ErrText)-1 );
  //return DllGetClassObject(*rclsid, riid, ppv);   // PTS 1112369
  long hr;                                          // PTS 1112369
  try {                                             // PTS 1112369
    hr = DllGetClassObject(*rclsid, riid, ppv);
  }                                                 // PTS 1112369
  catch ( BAD_ALLOC_GEO573 ) {                      // PTS 1112369
    hr = GEO00D_DCOM_BAD_ALLOC;                     // PTS 1112369
  }                                                 // PTS 1112369
  return hr;                                        // PTS 1112369
}

/*---------------------------------------------------------------------------*/

//externC int en38_Eval_Exception ( tsp_dcom_dispatch_parms * parms)
//{
//  IID loc_iid;
//  IUnknown                *lpIUnknown;
//  IClassFactory           *lpIFactory;
//  LVC_DispatcherCOMClassHash           *HashPtr;
//  LVC_DispatcherHashEntryPtr           currEntry;
//  LVC_DispatcherHashEntryPtr           currSessEntry;
//  IliveCacheSink*         pIliveCacheSink;
//  char                    msgBuffer[132];
//  parms->hresult = GEO00D_DCOM_DBPROC_CRASHED;
//  if (parms->session_context != NULL )
//  {
//    tsp00_C4          session;
//    tsp1_packet*      SQLBuffer_ptr;
//    CIliveCacheSink*  pIliveCacheSink;
//    ak341GetDebugContext ((tak_all_command_glob*)parms->session_context,
//        *REINTERPRET_CAST(tgg91_SessionNo*, &session),
//        *REINTERPRET_CAST(tsp00_Addr*, &pIliveCacheSink),
//        SQLBuffer_ptr );
//    if ( !pIliveCacheSink->CallbackIsActive)
//      parms->hresult = -1; // stay alive
//  }
//  MSGD ((ERR_DCOM_HRESULT, "eo38VDcomDispatch", parms->hresult ));
//  lpIUnknown = (IUnknown *) parms->idispatch;
//  lpIFactory = (IClassFactory *) parms->ifactory;
//  
//  RTESync_LockedScope lck(LVC_Dispatcher::getDCOMMemory().lExclusive);
//  HashPtr = LVC_Dispatcher::getDCOMMemory().lphead;
//  if ( NULL != HashPtr ) 
//  {
//    /* Release session related debugger                        */
//    HashPtr->ResetEntrySearch( 0, LVC_DispatcherCOMClassHash::SearchALL );
//    currEntry = HashPtr->NextEntry();
//    while ( NULL != currEntry)
//    {
//      if ((currEntry->getIUnknown() == lpIUnknown) ||
//        (currEntry->getIUnknown() == lpIFactory))
//      {
//        memcpy (&loc_iid.Data1, currEntry->getGuid(), sizeof (loc_iid));
//        if (currEntry->getIUnknown() == lpIUnknown)
//        {
//          MSGD ((ERR_DCOM_COMETHOD_CRASHED,
//            loc_iid.Data1, loc_iid.Data2, loc_iid.Data3,
//            loc_iid.Data4[0], loc_iid.Data4[1], loc_iid.Data4[2],
//            loc_iid.Data4[3], loc_iid.Data4[4], loc_iid.Data4[5],
//            loc_iid.Data4[6], loc_iid.Data4[7], parms->dispid));
//        }
//        else
//        {
//          MSGD ((ERR_DCOM_DBPROC_CRASHED,
//            loc_iid.Data1, loc_iid.Data2, loc_iid.Data3,
//            loc_iid.Data4[0], loc_iid.Data4[1], loc_iid.Data4[2],
//            loc_iid.Data4[3], loc_iid.Data4[4], loc_iid.Data4[5],
//            loc_iid.Data4[6], loc_iid.Data4[7], parms->dispid));
//        }
//        break;
//      }
//      currEntry = HashPtr->NextEntry(); 
//    }
//  }
//  return 0;
//}

/*---------------------------------------------------------------------------*/
/***
externC BOOL sql38LoadLibOms(tsp00_ErrText* errtext)
{
  teo78_ModuleName  OmsLibPath;
  tsp00_Pathc       szInstPath;
  tsp01_RteError    rteError;
  HANDLE            hd;
  if ( sqlGetDbrootLibPath (szInstPath, TERM_WITHOUT_DELIMITER_EO01, &rteError ) ) 
  {
    strcpy(OmsLibPath, szInstPath);
    strcat(OmsLibPath, "/liboms" );
    hd = sqlLoadLibrary(OmsLibPath, *errtext, sizeof(tsp00_ErrText)-1);
  }
  return (hd != 0);
}
***/
