/****************************************************************************

  module      : SysView_ActiveConfiguration.cpp

  -------------------------------------------------------------------------

  responsible : UlrichJ

  special area: SystemViews
  description : This module implements the "ActiveConfiguration" view class.

  last changed: 2002-08-14
  see also    :

  -------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "vak001.h"
#include "ggg91.h"
#include "gkb05.h"
#include "hkb51_2.h"
#include "hkb52.h"
#include "hgg06.h"
#include "Container/Container_List.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_NewDestroy.hpp"
#include "vkb522.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/

/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

ckb522_TransReader::ckb522_TransReader(SAPDBMem_IRawAllocator	&alloc,
                                       tgg00_TransContext     &trans)
: m_Allocator(alloc),
  m_Trans (trans)
{
    m_Current = 0;
    m_List = new(m_Allocator) TransList(m_Allocator);
}

ckb522_TransReader::~ckb522_TransReader()
{
    FreeAll();
}

SAPDB_Bool ckb522_TransReader::Begin()
{
    m_List->Delete();

    if (ReadList())
    {
        m_Current = m_List->Begin();
        return (true);
    }
    else
    {
        m_Current = m_List->End();
        return (false);
    }
}

void ckb522_TransReader::FreeAll()
{
    if (m_List)
    {
        m_List->Delete();
        m_Current = m_List->End();

        m_Allocator.Deallocate(m_List);
        m_List = NULL;
    }
}

ckb522_TransReader::TransElement * ckb522_TransReader::Next()
{
    TransElement * eRet;

    if (m_Current != m_List->End())
    {
        eRet = &(*m_Current);
        ++m_Current;
        return (eRet);
    }
    else
    {
        return (NULL);
    }
}

SAPDB_Bool ckb522_TransReader::ReadList()
{
    tkb05_RegionNo          CurrRegion;
    SAPDB_Int4              TransCnt;
    SAPDB_Int4              TransLimit;
    tkb05_TransEntryPtr     CurrTrans;
    tkb05_RegionGlobPtr     TransRgnGlobPtr;
    TransElement            toAdd;

    
    m_Trans.trError_gg00    = e_ok;
    CurrRegion              = 1;

    while ((e_ok == m_Trans.trError_gg00) && 
           (CurrRegion <= k51glob.glTransRegions_kb05))
    {

        k52begexcl_region (m_Trans.trTaskId_gg00, CurrRegion, TransRgnGlobPtr);

        TransLimit  = k52used_trans_of_region(*TransRgnGlobPtr);
        CurrTrans   = TransRgnGlobPtr->rglTransGlob_kb05->trFirst_kb05;
        TransCnt    = 0;

        while ((e_ok == m_Trans.trError_gg00) &&
               (NULL != CurrTrans) &&
               (TransCnt <= TransLimit))
        {
        
            toAdd.teSessionID_kb522         = CurrTrans->teSessionId_kb05;
            toAdd.teTransID_kb522           = CurrTrans->teSelectTransId_kb05;

            ToTimestamp (toAdd.teStartDate_kb522, CurrTrans->teStartDate_kb05, CurrTrans->teStartTime_kb05);

            toAdd.teWriteTransID_kb522      = CurrTrans->teWriteTransId_kb05;
            toAdd.teLastWrite_kb522         = CurrTrans->teTimeLastWrite_kb05;
        
            gg06SetNilTrans (toAdd.teConsistentViewID_kb522);

            if (CurrTrans->teObjLockMode_kb05 == tlmEotExcl_ekb05)
            {
                toAdd.teSQLLockMode_kb522 = tlmEotExcl_ekb05;
            }
            else
            {
                toAdd.teSQLLockMode_kb522 = CurrTrans->teLockMode_kb05;
            }

            if (cgg_nil_transindex != CurrTrans->teObjReq_kb05)
            {
                toAdd.teSQLLockReqTimeout_kb522 = CurrTrans->teObjReqTimeout_kb05;
                toAdd.teRequestMode_kb522       = tlmExcl_ekb05;
            }
            else
            {
                toAdd.teSQLLockReqTimeout_kb522 = CurrTrans->teReqTimeout_kb05;
                toAdd.teRequestMode_kb522       = CurrTrans->teReqMode_kb05;
            }

            if (NULL != CurrTrans->teConsistView_kb05)
            {
                if ((CurrTrans->teConsistView_kb05->cstCurrTransIndex_kb05 == CurrTrans->teOwnIndex_kb05) &&
                    (CurrTrans->teConsistView_kb05->cstItemKind_kb05 == ikConsistView_ekb05))
                {
                    toAdd.teConsistentViewID_kb522 = CurrTrans->teConsistView_kb05->cstConsistViewNo_kb05.variant.C_2.surrTransId_kb05_F;
                }
            }

            // Dummies:

            toAdd.teOMSLockReqTimeout_kb522     = 0;
            toAdd.teOMSLockMode_kb522           = 0;
            toAdd.teHistoryRoot_kb522           = 0;
            toAdd.teHistoryLast_kb522           = 0;
            toAdd.teHistoryPageCount_kb522      = 0;
            toAdd.teLastHistorySeq_kb522        = 0;

            m_List->InsertEnd(toAdd);

            TransCnt++;
            CurrTrans = CurrTrans->teNextTrans_kb05;
        }

        k52endexcl_region (m_Trans.trTaskId_gg00, TransRgnGlobPtr);

        if (TransCnt > TransLimit)
        {
            PutLoopError ("kb522: ReadList", 1);
            return (false);
        }

        CurrRegion++;
    }

    return (true);
}

void ckb522_TransReader::PutLoopError (const SAPDB_Char  *msg,
                                      SAPDB_Int4        iError)
{
    k52x_loop_error ((tsp00_C24 &)msg, iError);
}

void ckb522_TransReader::ToTimestamp (tsp00_Timestamp    &datetime, 
                                     tsp00_Date         &date,
                                     tsp00_Time         &time)
{
    SAPDB_UInt4     i;
    SAPDB_UInt4     j;

    j=0;

    for (i=0; i<sizeof(date); i++)
    {
        if ((date[i] < '0') || (date[i] > '9') || (j >= sizeof(datetime)))
        {
            return;
        }

        datetime[j++] = date[i];
    }

    for (i=0; i<sizeof(time); i++)
    {
        if ((time[i] < '0') || (time[i] > '9') || (j >= sizeof(datetime)))
        {
            return;
        }

        datetime[j++] = time[i];
    }

    for (; j<sizeof(datetime); j++)
    {
        datetime[j] = '0';
    }

    return;
}

void ckb522_TransReader::ToTimestamp (tsp00_Timestamp    &datetime,
                                     tsp00_Int4         &date,
                                     tsp00_Int4         &time)
{
    SAPDB_UInt4     i;

    sprintf((SAPDB_Char *)datetime, "%d%d", date, time);

    for (i=(SAPDB_UInt4)strlen((SAPDB_Char *)datetime); i<(SAPDB_UInt4)sizeof(datetime); i++)
    {
        datetime[i] = '0';
    }
}
/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/

