#!/devtool/local/bin/perl
#
# Run Upgradetests .
#

BEGIN {
    if ($^O !~ /MSWin32/i) {
		unshift @INC, "/devtool/local/bin";
		unshift @INC, "/devtool/TOOL/tool/bin";
		unshift @INC, "/devtool/TOOL/tool/lib/perl5";
		unshift @INC, "/devtool/TOOL/tool/lib";
		unshift @INC, "/SAP_DB/TESTDB/lib";
		unshift @INC, "/SAP_DB/TESTDB";
    }
}

use Sys::Hostname;
use testdbchr;
my $hostname    = hostname();

$| = 1;

my $tdb;
my $cfg = "";
@midrel;

$tdb = testdbchr->new({	'version' => '7600',
			'status' => 'DEV',
			'profile' => 'workday',
			'DIR' => '07',
			'no_objstat' => 10
			},
			{'SESSION_TYPE' => 'UPD'});
			

foreach my $midversion ('7403', '7500', '7600') {
	foreach my $midrel ('DEV', 'COR') {
		push (@midrel, testdbchr->new({'version' => $midversion,
			'status' => $midrel,
			'profile' => 'workday',
			'DIR' => '07',
			'no_objstat' => 10
			},
			{'SESSION_TYPE' => 'UPD'}));
		
	}
}


$tdb->verify_chr();
$tdb->create_chr();
$tdb->su_jump_in_chr();
$tdb->installTF();

foreach my $updhdl (@midrel) {
	$updhdl->{'in_chr'} = 1;
	for $vname (	'path', 'tempdir', 'jtest_root', 'dbroot', 'dbroot',
			'testdir', 'testdir', 'sapdbsdk', 'tempdir', 'tempdir') {
		$updhdl->{$vname} = $tdb->{$vname};
	}
	if ($updhdl->{'qah'}) {
		$updhdl->{'qah'}->set_sessiontype('UPD');
	} else {
		print "ERROR: I lost somehow my QADB handle while running upgrade test??!!\n";
	}
	$updhdl->run_upgrade_test();
 
}

exit(0);

