/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __BLISTMASTER_H__
#define __BLISTMASTER_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <klistview.h>
#include <kconfig.h>
#include <kglobal.h>
#include <qstringlist.h>
#include <qptrlist.h>
#include <qobject.h>
//-----------------------------------------------------------------------------------------------------------------------
class MainWidget;
//-----------------------------------------------------------------------------------------------------------------------
class BlistMaster : public QObject
{
	Q_OBJECT
public:
	BlistMaster(MainWidget *parent);
	~BlistMaster();

	bool isBlacklisted(QString title);
	void loadBlacklist(KConfig *cfg = KGlobal::config());
	void saveBlacklist(KConfig *cfg = KGlobal::config());
	void rebuildBlacklist();

public slots:
	void addBlacklist();
	void showPopupMenu(KListView*, QListViewItem*, const QPoint&);
	void removeStringBlacklist();

private:
	MainWidget *m_parent;
	QStringList m_blacklist;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
