/***************************************************************************
 *   Copyright (C) 2005-2006 by Robert Maxe                                *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __CHANNEL_H__
#define __CHANNEL_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <qstring.h>
#include <qimage.h>
//-----------------------------------------------------------------------------------------------------------------------
class Channel
{
public:
	Channel() { m_sortPrio = 0; }
	
	void setName(QString name) { m_name = name; }
	void setCustomName(QString customName) { m_customName = customName; }
	void setCustomImage(QString customImage) { m_customImage = customImage; }
	void setId(QString id) { m_id = id; }
	void setImageLocation(QString imageLocation) { m_imageLocation = imageLocation; }
	void setImage(QImage image) { m_image = image; }
	void clearImage() { m_image.reset(); }
	void setPrio(int prio) { m_sortPrio = prio; }
	bool hasImage() { return(!m_image.isNull()); }
	bool hasCustomName() { return(!m_customName.isEmpty()); }
	bool hasCustomImage() { return(!m_customImage.isEmpty()); }

	QString name() { return(m_name); }
	QString customName() { return(m_customName.isEmpty()?m_name:m_customName); }
	QString customImage() { return(m_customImage.isEmpty()?m_imageLocation:m_customImage); }
	QString id() { return(m_id); }
	QString imageLocation() { return(m_imageLocation); }
	QImage image() { return(m_image); }
	int prio() { return(m_sortPrio); }

private:
	QString m_name;			// "TV4 Plus"
	QString m_customName;		// "TV4+"
	QString m_id;			// "plus.tv4.se"
	QString m_imageLocation;	// "http://tv.swedb.se/chanlogos/plus.tv4.se.png"
	QString m_customImage;		// "/home/user/chanlogos/tv4.png"
	QImage m_image;
	int m_sortPrio;			// 0-1000

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
