/*            Copyright (C) 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#include "impala/ivp.h"
#include "impala/iface.h"
#include "impala/io.h"

#include "util/ting.h"
#include "util/equate.h"
#include "util/io.h"
#include "util/types.h"
#include "util/minmax.h"
#include "util/opt.h"
#include "util/err.h"

#include "proc.h"
#include "procinit.h"
#include "version.h"

#define CHB(a,b,c,d,e,f,g) mcxOptCheckBounds("mcl-lib", a, b, c, d, e, f, g)

static const char* me = "mcl-lib";

enum {
   PROC_OPT_DENSE
,  PROC_OPT_THICK
,  PROC_OPT_TRACK
,  PROC_OPT_RIGID
,  PROC_OPT_ADAPT
,  PROC_OPT_CLONE
,  PROC_OPT_SHOW
,  PROC_OPT_CLONEAT
,  PROC_OPT_INITLENGTH
,  PROC_OPT_MAINLENGTH
,  PROC_OPT_INITINFLATION
,  PROC_OPT_MAININFLATION
,  PROC_OPT_VERBOSITY
,  PROC_OPT_SILENCE
,  PROC_OPT_PROGRESS
,  PROC_OPT_DIGITS
,  PROC_OPT_TRACKI
,  PROC_OPT_TRACKM
,  PROC_OPT_DEVEL
,  PROC_OPT_THREADS
,  PROC_OPT_ITHREADS
,  PROC_OPT_ETHREADS
,  PROC_OPT_NJ
,  PROC_OPT_NX
,  PROC_OPT_NY
,  PROC_OPT_NW
,  PROC_OPT_NL
,  PROC_OPT_PRUNE
,  PROC_OPT_PPRUNE
,  PROC_OPT_RECOVER
,  PROC_OPT_MARK
,  PROC_OPT_SELECT
,  PROC_OPT_PCT
,  PROC_OPT_SCHEME
,  PROC_OPT_WEIGHT_MAXVAL
,  PROC_OPT_WEIGHT_SELFVAL
,  PROC_OPT_WARNFACTOR
,  PROC_OPT_WARNPCT
,  PROC_OPT_ADAPTEXPONENT
,  PROC_OPT_INFLATEFIRST
,  PROC_OPT_EXPANDONLY
,  PROC_OPT_ADAPTFACTOR
,  PROC_OPT_DUMPSTEM
,  PROC_OPT_DUMP
,  PROC_OPT_DUMPINTERVAL
,  PROC_OPT_DUMPMODULO
,  PROC_OPT_DUMPBINARY
}  ;


mcxOptAnchor mclProcOptions[] =
{
   {  "--dense",        0, PROC_OPT_DENSE }
,  {  "--thick",        0, PROC_OPT_THICK }
,  {  "--track",        0, PROC_OPT_TRACK }
,  {  "--rigid",        0, PROC_OPT_RIGID }
,  {  "--adapt",        0, PROC_OPT_ADAPT }
,  {  "--clone",        0, PROC_OPT_CLONE }
,  {  "--show",         0, PROC_OPT_SHOW }
,  {  "--inflate-first",0, PROC_OPT_INFLATEFIRST }
,  {  "--expand-only",  0, PROC_OPT_EXPANDONLY }
,  {  "-cloneat",       1, PROC_OPT_CLONEAT }
,  {  "-l",             1, PROC_OPT_INITLENGTH }
,  {  "-L",             1, PROC_OPT_MAINLENGTH }
,  {  "-i",             1, PROC_OPT_INITINFLATION }
,  {  "-I",             1, PROC_OPT_MAININFLATION }
,  {  "-v",             1, PROC_OPT_VERBOSITY }
,  {  "-V",             1, PROC_OPT_SILENCE }
,  {  "-progress",      1, PROC_OPT_PROGRESS }
,  {  "-digits",        1, PROC_OPT_DIGITS }
,  {  "-tracki",        1, PROC_OPT_TRACKI }
,  {  "-trackm",        1, PROC_OPT_TRACKM }
,  {  "-devel",         1, PROC_OPT_DEVEL }
,  {  "-t",             1, PROC_OPT_THREADS }
,  {  "-ti",            1, PROC_OPT_ITHREADS }
,  {  "-te",            1, PROC_OPT_ETHREADS }
,  {  "-nj",            1, PROC_OPT_NJ }
,  {  "-nx",            1, PROC_OPT_NX }
,  {  "-ny",            1, PROC_OPT_NY }
,  {  "-nw",            1, PROC_OPT_NW }
,  {  "-nl",            1, PROC_OPT_NL }
,  {  "-p",             1, PROC_OPT_PRUNE }
,  {  "-P",             1, PROC_OPT_PPRUNE }
,  {  "-R",             1, PROC_OPT_RECOVER }
,  {  "-M",             1, PROC_OPT_MARK }
,  {  "-S",             1, PROC_OPT_SELECT }
,  {  "-pct",           1, PROC_OPT_PCT }
,  {  "-scheme",        1, PROC_OPT_SCHEME }
,  {  "-wself",         1, PROC_OPT_WEIGHT_SELFVAL }
,  {  "-wmax",          1, PROC_OPT_WEIGHT_MAXVAL }
,  {  "-warn-pct",      1, PROC_OPT_WARNPCT }
,  {  "-ae",            1, PROC_OPT_ADAPTEXPONENT }
,  {  "-adapt-exponent",1, PROC_OPT_ADAPTEXPONENT }
,  {  "-af",            1, PROC_OPT_ADAPTFACTOR }
,  {  "-adapt-factor",  1, PROC_OPT_ADAPTFACTOR }
,  {  "-dump",          1, PROC_OPT_DUMP }
,  {  "-ds",            1, PROC_OPT_DUMPSTEM }
,  {  "-dump-stem",     1, PROC_OPT_DUMPSTEM }
,  {  "-di",            1, PROC_OPT_DUMPINTERVAL }
,  {  "-dump-interval", 1, PROC_OPT_DUMPINTERVAL }
,  {  "-dm",            1, PROC_OPT_DUMPMODULO }
,  {  "-dump-modulo",   1, PROC_OPT_DUMPMODULO }
,  {  "--db",           0, PROC_OPT_DUMPBINARY }
,  {  "--dump-binary",  0, PROC_OPT_DUMPBINARY }
,  {  NULL, 0, 0 }
}  ;

static int  scheme[7][5]         =  {  {  3000,  400,  500, 90 }
                                    ,  {  4000,  500,  600, 90 }
                                    ,  {  5000,  600,  700, 90 }
                                    ,  {  6000,  700,  800, 90 }
                                    ,  {  7000,  800,  900, 90 }
                                    ,  { 10000, 1100, 1400, 90 }
                                    ,  { 10000, 1200, 1600, 90 }
                                    }  ;

static int           n_prune     =  -1;
static int           n_select    =  -1;
static int           n_recover   =  -1;
static int           n_scheme    =  -1;
static int           n_pct       =  -1;

void makeSettings
(  mclExpandParam* mxp
)  ;

void  mclSetProgress
(  int n_nodes
,  mclProcParam* mpp
)
   {  mclExpandParam *mxp = mpp->mxp
   ;

     /* 
      *     because of initialization the condition below means that
      *     user has not used -progress flag or given it argument 0.
      *     This setup is very ugly, general problem when trying to
      *     make constituting elements of default settings interact.
     */
      if ((mxp->n_ethreads || mpp->n_ithreads) && !mxp->usrVectorProgression)
      {  BIT_ON(mxp->verbosity, XPNVB_MPROGRESS)
      ;  BIT_OFF(mxp->verbosity, XPNVB_VPROGRESS)
   ;  }

      if (mxp->vectorProgression)
      {  
         if (mxp->vectorProgression > 0)
         mxp->vectorProgression
         =  MAX(1 + (n_nodes -1)/mxp->vectorProgression, 1)
      ;  else
         mxp->vectorProgression = -mxp->vectorProgression
   ;  }
      else if
         (  !mxp->vectorProgression
         && n_nodes >= 2000
         && !mxp->n_ethreads
         && !mpp->n_ithreads
         && !XPNVB(mxp, XPNVB_MPROGRESS)
         )
      mcxTell
      (  me
      ,  "advice: for larger graphs such as this, -progress <n> will "
         "reflect progress"
      )
;  }


mcxstatus mclProcessInit
(  const mcxOptList*    opts
,  mcxHash*             myOpts
,  mclProcParam*        mpp
)
   {  int               i        =  0
   ;  float             f        =  0.0
   ;  float             f_0      =  0.0
   ;  float             f_1      =  1.0
   ;  int               i_0      =  0
   ;  int               i_1      =  1
   ;  int               i_7      =  7
   ;  int               i_10     =  10
   ;  int               i_100    =  100
   ;  float             f_e1     =  1e-1
   ;  float             f_30     =  30.0
   ;  mclExpandParam    *mxp     =  mpp->mxp

   ;  mcxOptPrintDigits  =  1

   ;  while(opts && opts->tag)
      {
         mcxKV* kv = mcxHashSearch(opts->tag, myOpts, MCX_DATUM_FIND)
      ;  mcxOptAnchor* anch = kv ? (mcxOptAnchor*) kv->val : NULL
      ;  mcxbool  vok = TRUE            /* value ok (not illegal) */
      ;  mcxbool  verbosity
      ;  mcxbits  bit = 0
      ;  const char* arg

      ;  if (!kv)
         {  opts = opts->next
         ;  continue
      ;  }

         switch(anch->id)
         {  case PROC_OPT_THICK
         :  mxp->modeExpand = MCL_EXPAND_DENSE
         ;  break
         ;

            case PROC_OPT_TRACK
         :  mclTrackImpalaPruning   =  1
         ;  break
         ;

            case PROC_OPT_RIGID
         :  mxp->modePruning = MCL_PRUNING_RIGID
         ;  break
         ;

            case PROC_OPT_ADAPT
         :  mxp->modePruning = MCL_PRUNING_ADAPT
         ;  break
         ;

            case PROC_OPT_CLONE
         :  mxp->cloneMatrices=  TRUE
         ;  break
         ;

            case PROC_OPT_CLONEAT
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_1, NULL, NULL)
         ;  if (vok) mxp->cloneBarrier = i
         ;  break
         ;

            case PROC_OPT_SHOW
         :  mpp->printMatrix  =  TRUE
         ;  break
         ;

            case PROC_OPT_EXPANDONLY
         :  mpp->expandOnly   =  TRUE
         ;  break
         ;

            case PROC_OPT_INFLATEFIRST
         :  mpp->inflateFirst =  TRUE
         ;  break
         ;

            case PROC_OPT_DENSE
         :  n_recover =  0
         ;  n_select  =  0
         ;  mxp->modeExpand = MCL_EXPAND_DENSE
         ;  break
         ;

            case PROC_OPT_INITINFLATION
         :  f = atof(opts->val)
         ;  vok = CHB(opts->tag, 'f', &f, fltGq, &f_e1, fltLq, &f_30)
         ;  if (vok && (f<1.1 || f>5.0))
            mcxWarn
            (  "mcl"
            ,  "warning: conceivable/normal ranges for -i are "
               "(1.0, 5.0] / [1.2, 3.0]"
            )
         ;  if (vok) mpp->initInflation = f
         ;  break
         ;

            case PROC_OPT_MAININFLATION
         :  f =  atof(opts->val)
         ;  vok = CHB(opts->tag, 'f', &f, fltGq, &f_e1, fltLq, &f_30)
         ;  if (vok && (f<1.1 || f>5.0))
            mcxWarn
            (  "mcl"
            ,  "warning: conceivable/normal ranges for -I are "
               "(1.0, 5.0] / [1.2, 3.0]"
            )
         ;  if (vok) mpp->mainInflation = f
         ;  break
         ;

            case PROC_OPT_VERBOSITY
         :  case PROC_OPT_SILENCE
         :  verbosity = anch->id  == PROC_OPT_VERBOSITY ? TRUE : FALSE
         ;  arg = opts->val

         ;  if (strcmp(arg, "pruning") == 0)
            bit = XPNVB_PRUNING
         ;  else if (strcmp(arg, "explain") == 0)
            bit = XPNVB_EXPLAIN
         ;  else if (strcmp(arg, "clusters") == 0)
            bit = XPNVB_CLUSTERS
         ;  else if (strcmp(arg, "progress") == 0)
            bit = XPNVB_VPROGRESS
         ;  else if (strcmp(arg, "all") == 0)
            bit = ~0

         ;  if (verbosity)
            BIT_ON(mxp->verbosity, bit)
         ;  else
            BIT_OFF(mxp->verbosity, bit)
         ;  break
         ;

            case PROC_OPT_INITLENGTH
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, NULL, NULL)
         ;  if (vok) mpp->initLoopLength = i
         ;  break
         ;

            case PROC_OPT_MAINLENGTH
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, NULL, NULL)
         ;  if (vok) mpp->mainLoopLength = i
         ;  break
         ;

            case PROC_OPT_PROGRESS
         :  mxp->usrVectorProgression = atoi(opts->val)
         ;  if (!mxp->usrVectorProgression)
            {  mxp->vectorProgression = 0
            ;  BIT_ON(mxp->verbosity, XPNVB_MPROGRESS)
            ;  BIT_OFF(mxp->verbosity, XPNVB_VPROGRESS)
         ;  }
            else
            mxp->verbosity |= XPNVB_VPROGRESS
         ;  mxp->vectorProgression = mxp->usrVectorProgression
         ;  break
         ;

            case PROC_OPT_TRACKI
         :  if (  sscanf
                  (  opts->val,  "%d:%d"
                  ,  &mclTrackImpalaPruningOffset
                  ,  &mclTrackImpalaPruningBound
                  ) != 2
               )
            {  mcxErr
               (  me
               ,  "flag <-tracki> expects i:j format, j=0 denoting infinity"
               )
            ;  vok = FALSE
            /* hierverder mq, no bound checking */
         ;  }
            mclTrackImpalaPruning = 1
         ;  break
         ;

            case PROC_OPT_THREADS
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, NULL, NULL)
         ;  if (vok)
            {  mxp->n_ethreads = i
            ;  mpp->n_ithreads = i
            ;  BIT_OFF(mxp->verbosity, XPNVB_VPROGRESS)
         ;  }
            break
         ;

            case PROC_OPT_ITHREADS
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, NULL, NULL)
         ;  if (vok)
            {  mpp->n_ithreads = i
            ;  BIT_OFF(mxp->verbosity, XPNVB_PRUNING)
         ;  }
            break
         ;

            case PROC_OPT_ETHREADS
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, NULL, NULL)
         ;  if (vok)
            {  mxp->n_ethreads = i
            ;  BIT_OFF(mxp->verbosity, XPNVB_PRUNING)
         ;  }
            break
         ;

            case PROC_OPT_NJ
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_1, NULL, NULL)
         ;  if (vok) mxp->nj = i-1
         ;  break
         ;

            case PROC_OPT_NX
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_1, NULL, NULL)
         ;  if (vok) mxp->nx = i-1
         ;  break
         ;

            case PROC_OPT_NY
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_1, NULL, NULL)
         ;  if (vok) mxp->ny = i-1
         ;  break
         ;

            case PROC_OPT_NL
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_1, NULL, NULL)
         ;  if (vok) mxp->nl = i
         ;  break
         ;

            case PROC_OPT_NW
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, NULL, NULL)
         ;  if (vok) mxp->nw = i
         ;  break
         ;

            case PROC_OPT_TRACKM
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_1, NULL, NULL)
         ;  if (vok)
            {  mclTrackImpalaPruning = 1
            ;  mclTrackImpalaPruningInterval = i
         ;  }
            break
         ;

            case PROC_OPT_DIGITS
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_1, intLq, &i_10)
         ;  if (vok) mpp->printDigits = i
         ;  break
         ;

            case PROC_OPT_PPRUNE
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, NULL, NULL)
         ;  if (vok) n_prune =  i
         ;  break
         ;

            case PROC_OPT_PRUNE
         :  f = atof(opts->val)
         ;  vok = CHB(opts->tag, 'f', &f, fltGq, &f_0, fltLq, &f_e1)
         ;  if (vok) n_prune = f ? (int) (1.0 / f) : 0
         ;  break
         ;

            case PROC_OPT_WARNFACTOR
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, NULL, NULL)
         ;  if (vok) mxp->warnFactor =  i
         ;  break
         ;

            case PROC_OPT_WARNPCT
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, intLt, &i_100)
         ;  if (vok) mxp->warnPct  =  ((double) i) / 100.0
         ;  break
         ;

            case PROC_OPT_WEIGHT_MAXVAL
         :  mpp->ipp->w_maxval = atof(opts->val)
         ;  break
         ;

            case PROC_OPT_WEIGHT_SELFVAL
         :  mpp->ipp->w_selfval = atof(opts->val)
         ;  break
         ;

            case PROC_OPT_SCHEME
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_1, intLq, &i_7)
         ;  if (vok)
            {  n_scheme    =  i-1
            ;  n_prune     =  scheme[n_scheme][0]
            ;  n_select    =  scheme[n_scheme][1]
            ;  n_recover   =  scheme[n_scheme][2]
            ;  n_pct       =  scheme[n_scheme][3]
            ;  mxp->scheme =  i
         ;  }
            break
         ;

            case PROC_OPT_PCT
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, intLt, &i_100)
         ;  if (vok) n_pct =  i
         ;  break
         ;

            case PROC_OPT_MARK
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, NULL, NULL)
         ;  if (vok)
            {  n_recover   =  i
            ;  n_select    =  i
         ;  }
            break
         ;

            case PROC_OPT_RECOVER
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, NULL, NULL)
         ;  if (vok) n_recover   =  i
         ;  break
         ;

            case PROC_OPT_SELECT
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_0, NULL, NULL)
         ;  if (vok) n_select =  i
         ;  break
         ;

            case PROC_OPT_ADAPTEXPONENT
         :  f  =  atof(opts->val)
         ;  vok = CHB(opts->tag, 'f', &f, fltGq, &f_1, NULL, NULL)
         ;  if (vok)
            {  mxp->modePruning =  MCL_PRUNING_ADAPT
            ;  mxp->cutExp  =  f
         ;  }
            break
         ;

            case PROC_OPT_ADAPTFACTOR
         :  f  =  atof(opts->val)
         ;  vok = CHB(opts->tag, 'f', &f, fltGq, &f_1, NULL, NULL)
         ;  if (vok)
            {  mxp->modePruning    =  MCL_PRUNING_ADAPT
            ;  mxp->cutCof         =  f
         ;  }
            break
         ;

            case PROC_OPT_DEVEL
         :  mpp->devel = atoi(opts->val)
         ;  break
         ;

            case PROC_OPT_DUMPSTEM
         :  mpp->dumpStem =  opts->val      /* mqmem make mcxStrNew */
         ;  break
         ;

            case PROC_OPT_DUMP
         :  arg = opts->val
         ;  if (strcmp(arg, "chr") == 0)
            BIT_ON(mpp->dumping, MCPVB_CHR)
         ;  else if (strcmp(arg, "ite") == 0)
            BIT_ON(mpp->dumping, MCPVB_ITE)
         ;  else if (strcmp(arg, "cls") == 0)
            BIT_ON(mpp->dumping, MCPVB_CLUSTERS)
         ;  else if (strcmp(arg, "dag") == 0)
            BIT_ON(mpp->dumping, MCPVB_DAG)
         ;  else
            mcxErr(me, "no such dump mode: <%s>", arg)
         ;  break
         ;

            case PROC_OPT_DUMPINTERVAL
         :  if (sscanf(opts->val,"%d:%d",&mpp->dumpOffset,&mpp->dumpBound)!=2)
            {  mcxErr
               (  me
               ,  "flag -dumpi expects i:j format, j=0 denoting infinity"
               )
            ;  vok = FALSE
            /* hierverder mq, no bound checking */
         ;  }
            break
         ;

            case PROC_OPT_DUMPBINARY
         :  mpp->dumpMode = 'b'
         ;  break
         ;

            case PROC_OPT_DUMPMODULO
         :  i = atoi(opts->val)
         ;  vok = CHB(opts->tag, 'i', &i, intGq, &i_1, NULL, NULL)
         ;  if (vok) mpp->dumpModulo = i
         ;  break
         ;

         }

         if (vok != TRUE)            
         return STATUS_FAIL
      ;  opts = opts->next
   ;  }

  /*
   * this does the scheme thing
  */
      makeSettings(mxp)


   ;  if (mclTrackImpalaPruning)
      {  mclTrackStreamImpala = mcxIOnew("-", "w")
      ;  mcxIOopen(mclTrackStreamImpala, EXIT_ON_FAIL)
   ;  }

      return STATUS_OK
;  }


void mclShowSchemes
(  void
)
   {  int i
   ;  fprintf
      (  stdout
      ,  "%20s%15s%15s%15s\n"  
      ,  "Pruning"
      ,  "Selection"
      ,  "Recovery"
      ,  "  Recover percentage"
      )
   ;  for (i=0;i<7;i++)
      fprintf
      (  stdout
      ,  "Scheme %1d%12d%15d%15d%15d\n"
      ,  i+1
      ,  scheme[i][0]
      ,  scheme[i][1]
      ,  scheme[i][2]
      ,  scheme[i][3]
      )
;  }


void makeSettings
(  mclExpandParam* mxp
)
   {  int s = mxp->scheme
   ;  mxp->pruneNumber       =  n_prune  >= 0  ?  n_prune :  scheme[s][0]

   ;  mxp->precision         =      mxp->pruneNumber
                                 ?  0.99999 / mxp->pruneNumber
                                 :  0.0

   ;  mxp->selectNumber      =  n_select < 0  ?  scheme[s][1] :  n_select
   ;  mxp->recoverNumber     =  n_recover< 0  ?  scheme[s][2] :  n_recover
   ;  mxp->pct               =  n_pct    < 0  ?  scheme[s][3] :  n_pct

   ;  mxp->pct              /=  100.0

   ;  if (!mxp->pruneNumber)
      mxp->modeExpand = MCL_EXPAND_DENSE
;  }


void mclShowSettings
(  FILE* fp
,  mclProcParam* mpp
,  mcxbool user
)
   {  mclIvp ivps[10]
   ;  mclExpandParam *mxp = mpp->mxp

   ;  if (user)
      {  fprintf(fp, "[mcl] cell size: %d\n", sizeof(ivps) / 10)
      ;  fprintf
         (  fp
         ,  "[mcl] cell contents: "
            IVP_NUM_TYPE
            " and "
            IVP_VAL_TYPE
            "\n"
         )
      ;  fprintf(fp, "[mcl] largest index allowed: %ld\n", (long) PNUM_MAX)
      ;  fprintf(fp, "[mcl] smallest index allowed: 0\n")
   ;  }

      fprintf(fp, "[mcl] version: %s\n", mclDateTag)

   ;  fprintf
      (  fp , "%-40s%8d%8s%s\n"
            ,  "Prune number"
            ,  mxp->pruneNumber
            ,  ""
            ,  "[-P n]"
      )

   ;  fprintf
      (  fp ,  "%-40s%8d%8s%s\n"
            ,  "Selection number"
            ,  mxp->selectNumber
            ,  ""
            , "[-S n]"
      )

   ;  fprintf
      (  fp ,  "%-40s%8d%8s%s\n"
            ,  "Recovery number"
            ,  mxp->recoverNumber
            ,  ""
            ,  "[-R n]"
      )

   ;  fprintf
      (  fp ,  "%-40s%8d%8s%s\n"
            ,  "Recovery percentage"
            ,  (int) (100*mxp->pct+0.5)
            ,  ""
            ,  "[-pct n]"
      )

   ;  if (user) fprintf
      (  fp ,  "%-40s%8d%8s%s\n"
            ,  "nx (x window index)"
            ,  mxp->nx + 1
            ,  ""
            ,  "[-nx n]"
      )

   ;  if (user) fprintf
      (  fp ,  "%-40s%8d%8s%s\n"
            ,  "ny (y window index)"
            ,  mxp->ny + 1
            ,   ""
            ,  "[-ny n]"
      )

   ;  if (user) fprintf
      (  fp ,  "%-40s%8d%8s%s\n"
            ,  "nj (jury window index)"
            ,  mxp->nj + 1
            ,   ""
            ,  "[-nj n]"
      )

   ;  if (user || mxp->modePruning == MCL_PRUNING_ADAPT) fprintf
      (  fp ,  "%-40s%11.2f%5s%s\n"
            ,  "adapt-exponent"
            ,  mxp->cutExp
            ,  ""
            ,  "[-ae f]"
      )

   ;  if (user || mxp->modePruning == MCL_PRUNING_ADAPT) fprintf
      (  fp ,  "%-40s%11.2f%5s%s\n"
            ,  "adapt-factor"
            ,  mxp->cutCof
            ,  ""
            ,  "[-af f]"
      )

   ;  if (user) fprintf
      (  fp ,  "%-40s%8d%8s%s\n"
            ,  "warn-factor"
            ,  mxp->warnFactor
            ,  ""
            ,  "[-warn-factor k]"
      )

   ;  if (user) fprintf
      (  fp ,  "%-40s%8d%8s%s\n"
            ,  "warn-pct"
            ,  (int) ((100.0 * mxp->warnPct) + 0.5)
            ,  ""
            ,  "[-warn-pct k]"
      )

   ;  if (user || mxp->cloneMatrices) fprintf
      (  fp ,  "%-40s%8d%8s%s\n"
            ,  "Clone threshold (vector density)"
            ,  mxp->cloneBarrier
            ,  ""
            ,  "[-cloneat f]"
      )

   ;  if (user) fprintf
      (  fp ,  "%-40s%8s%8s%s\n"
            ,  "dumpstem"
            ,  mpp->dumpStem
            ,  ""
            ,  "[-dumpstem str]"
      )

   ;  if (user || mpp->initLoopLength) fprintf
      (  fp ,  "%-40s%8d%8s%s\n"
            ,  "Initial loop length"
            ,  mpp->initLoopLength
            ,  ""
            ,  "[-l n]"
      )

   ;  fprintf
      (  fp ,  "%-40s%8d%8s%s\n"
            ,  "Main loop length"
            ,  mpp->mainLoopLength
            ,  ""
            ,  "[-L n]"
      )

   ;  if (user || mpp->initLoopLength) fprintf
      (  fp ,  "%-40s%10.1f%6s%s\n"
            ,  "Initial inflation"
            ,  mpp->initInflation
            ,  ""
            ,  "[-i f]"
      )

   ;  fprintf
      (  fp ,  "%-40s%10.1f%6s%s\n"
            ,  "Main inflation"
            ,  mpp->mainInflation
            ,  ""
            ,  "[-I f]"
      )
;  }


