/*      Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

#include "impala/matrix.h"
#include "impala/io.h"
#include "impala/iface.h"

#include "util/io.h"
#include "util/types.h"
#include "util/err.h"
#include "util/opt.h"


const char* usagelines[] =
{  "usage: "
,  "   mcxconvert <fname in> <fname out>"
,  "   mcxconvert <fname>      (report current format)"
,  NULL
}  ;


int main
(  int                  argc
,  const char*          argv[]
)
   {  mclMatrix*        mx
   ;  const char*       me = "mcxconvert"

   ;  if (argc < 2 || !strcmp(argv[1], "-h"))
      {  mcxUsage(stdout, me, usagelines)
      ;  mcxExit(0)
   ;  }
      else if (argc == 2)
      {  mcxIO* xf = mcxIOnew(argv[1], "r")
      ;  mcxIOopen(xf, EXIT_ON_FAIL)
      ;  if (mcxIOtryCookie(xf, mclxCookie))
         fprintf(stdout,"binary\n")
      ;  else
         fprintf(stdout,"ascii\n")
   ;  }
      else
      {  mcxIO *xfin = mcxIOnew(argv[1], "r")
      ;  mcxIO *xfout = mcxIOnew(argv[2], "w")
      ;  mx = mclxRead(xfin, EXIT_ON_FAIL)
      ;  mcxIOopen(xfout, EXIT_ON_FAIL)
      ;  if (mclxFormatFound == 'a')
         mclxbWrite(mx, xfout, EXIT_ON_FAIL)
      ;  else
         mclxaWrite(mx, xfout, MCLXIO_VALUE_GETENV, EXIT_ON_FAIL)
   ;  }
      return 0
;  }


