C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq5F4 (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 4)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=9)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ5F4                                          C       PARAMETER (ISET=7) 
        DATA  DrI, FlI, AlI /   2.,   4.,  .3090 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.300,    4.500,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     4 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .100000E+01, .100000E+05,
     +  .100000E+01, .113267E+01, .130000E+01, .172530E+01, .242102E+01,
     +  .363177E+01, .590108E+01, .105505E+02, .211508E+02, .486273E+02,
     +  .131722E+03, .434199E+03, .181038E+04, .100000E+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000E-04,
     +  .000000E+00, .999983E-05, .124433E-04, .154836E-04, .192668E-04,
     +  .239740E-04, .298310E-04, .371184E-04, .461852E-04, .574656E-04,
     +  .714994E-04, .889575E-04, .110674E-03, .137686E-03, .171280E-03,
     +  .213055E-03, .264997E-03, .329564E-03, .409809E-03, .509508E-03,
     +  .633332E-03, .787053E-03, .977784E-03, .121428E-02, .150728E-02,
     +  .186993E-02, .231825E-02, .288037E-02, .356397E-02, .440443E-02,
     +  .543508E-02, .669508E-02, .822984E-02, .100851E-01, .123281E-01,
     +  .150167E-01, .182174E-01, .219985E-01, .264278E-01, .315720E-01,
     +  .374800E-01, .442088E-01, .517931E-01, .602576E-01, .696136E-01,
     +  .798586E-01, .909356E-01, .102935E+00, .115681E+00, .129293E+00,
     +  .143599E+00, .158606E+00, .174271E+00, .190550E+00, .207405E+00,
     +  .224796E+00, .242685E+00, .261038E+00, .279820E+00, .299001E+00,
     +  .318550E+00, .338442E+00, .358653E+00, .379067E+00, .399881E+00,
     +  .420953E+00, .442266E+00, .463806E+00, .485559E+00, .507513E+00,
     +  .529656E+00, .551978E+00, .574483E+00, .597187E+00, .619860E+00,
     +  .642828E+00, .665921E+00, .689135E+00, .712467E+00, .735911E+00,
     +  .759464E+00, .783080E+00, .806909E+00, .830741E+00, .854673E+00,
     +  .878696E+00, .902804E+00, .926992E+00, .951257E+00, .975603E+00,
     +  .100000E+01 /
C Parton Distribution Table:                                                   
        DATA (UPDI(I),I=1,52) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .394081E+05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .289559E+05, .226358E+05, .174804E+05,
     +  .134899E+05, .104064E+05, .802168E+04, .618084E+04,
     +  .475859E+04, .366192E+04, .281551E+04, .216365E+04,
     +  .166113E+04, .127462E+04, .977029E+03, .748467E+03,
     +  .572728E+03, .437966E+03, .334501E+03, .255295E+03,
     +  .194587E+03, .148206E+03, .112723E+03, .856669E+02,
     +  .650094E+02, .492910E+02, .373223E+02, .282442E+02,
     +  .212578E+02, .160542E+02, .121073E+02, .912905E+01,
     +  .687592E+01, .517965E+01, .390277E+01, .294168E+01,
     +  .221768E+01, .167539E+01, .126693E+01, .961072E+00 /
        DATA (UPDI(I),I=313,364) /
     +  .730384E+00, .557572E+00, .426793E+00, .328219E+00,
     +  .253219E+00, .196386E+00, .152787E+00, .119592E+00,
     +  .936926E-01, .739027E-01, .583093E-01, .462253E-01,
     +  .366871E-01, .292079E-01, .232658E-01, .185731E-01,
     +  .148154E-01, .118249E-01, .942190E-02, .750806E-02,
     +  .596447E-02, .473235E-02, .373938E-02, .294591E-02,
     +  .231282E-02, .180373E-02, .139529E-02, .107122E-02,
     +  .813871E-03, .611887E-03, .453144E-03, .330287E-03,
     +  .235279E-03, .163302E-03, .108609E-03, .690934E-04,
     +  .401648E-04, .200172E-04, .647873E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=365,416) /
     +  .739111E+05, .574853E+05, .441360E+05, .338632E+05,
     +  .259701E+05, .199018E+05, .152441E+05, .116670E+05,
     +  .892469E+04, .682095E+04, .521015E+04, .397597E+04,
     +  .303227E+04, .231019E+04, .175887E+04, .133763E+04,
     +  .101653E+04, .771569E+03, .585172E+03, .443226E+03,
     +  .335435E+03, .253508E+03, .191419E+03, .144326E+03,
     +  .108715E+03, .817776E+02, .614741E+02, .459544E+02,
     +  .344682E+02, .258166E+02, .193291E+02, .144559E+02,
     +  .108103E+02, .808609E+01, .604867E+01, .452538E+01,
     +  .339178E+01, .254461E+01, .191444E+01, .144299E+01,
     +  .109222E+01, .828968E+00, .631945E+00, .483340E+00,
     +  .371535E+00, .286528E+00, .222276E+00, .172617E+00,
     +  .134939E+00, .105535E+00, .829208E-01, .652425E-01 /
        DATA (UPDI(I),I=417,468) /
     +  .514863E-01, .406611E-01, .321779E-01, .254510E-01,
     +  .201422E-01, .159183E-01, .125816E-01, .991783E-02,
     +  .781001E-02, .612827E-02, .479697E-02, .374454E-02,
     +  .290663E-02, .224137E-02, .171878E-02, .130782E-02,
     +  .988211E-03, .739207E-03, .547938E-03, .401008E-03,
     +  .289842E-03, .205574E-03, .144145E-03, .985156E-04,
     +  .658299E-04, .426393E-04, .267079E-04, .159738E-04,
     +  .906292E-05, .477909E-05, .227292E-05, .922472E-06,
     +  .283028E-06, .305983E-07, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .139859E+06,
     +  .108252E+06, .826538E+05, .630645E+05, .480949E+05,
     +  .366503E+05, .279145E+05, .212434E+05, .161574E+05,
     +  .122781E+05, .932446E+04, .707457E+04, .536391E+04 /
        DATA (UPDI(I),I=469,520) /
     +  .406270E+04, .307487E+04, .232462E+04, .175602E+04,
     +  .132488E+04, .998725E+03, .751876E+03, .565522E+03,
     +  .424766E+03, .318727E+03, .238809E+03, .178741E+03,
     +  .133591E+03, .997700E+02, .740870E+02, .551973E+02,
     +  .410652E+02, .305339E+02, .226775E+02, .168376E+02,
     +  .125043E+02, .928425E+01, .689433E+01, .512744E+01,
     +  .381699E+01, .284875E+01, .213004E+01, .159897E+01,
     +  .120361E+01, .909816E+00, .690065E+00, .525914E+00,
     +  .402171E+00, .309319E+00, .238198E+00, .184610E+00,
     +  .143171E+00, .111536E+00, .870312E-01, .681038E-01,
     +  .533428E-01, .418608E-01, .328391E-01, .257752E-01,
     +  .202068E-01, .158411E-01, .123888E-01, .967848E-02,
     +  .753637E-02, .585457E-02, .453661E-02, .349647E-02 /
        DATA (UPDI(I),I=521,572) /
     +  .267874E-02, .204207E-02, .154615E-02, .116373E-02,
     +  .868564E-03, .643648E-03, .472343E-03, .343531E-03,
     +  .246635E-03, .176101E-03, .123813E-03, .862042E-04,
     +  .592408E-04, .403336E-04, .271197E-04, .181149E-04,
     +  .119726E-04, .782794E-05, .503422E-05, .315766E-05,
     +  .188107E-05, .102893E-05, .480185E-06, .156065E-06,
     +  .135230E-07, .000000E+00, .233181E+06, .179641E+06,
     +  .136425E+06, .103531E+06, .785270E+05, .595150E+05,
     +  .450803E+05, .341178E+05, .258052E+05, .195003E+05,
     +  .147259E+05, .111096E+05, .837525E+04, .630726E+04,
     +  .474610E+04, .356729E+04, .267894E+04, .200933E+04,
     +  .150567E+04, .112676E+04, .842367E+03, .628865E+03,
     +  .468968E+03, .349205E+03, .259727E+03, .192891E+03 /
        DATA (UPDI(I),I=573,624) /
     +  .143129E+03, .105585E+03, .781440E+02, .577500E+02,
     +  .426469E+02, .314561E+02, .231906E+02, .171001E+02,
     +  .126036E+02, .929018E+01, .685675E+01, .506536E+01,
     +  .375076E+01, .278242E+01, .207186E+01, .154701E+01,
     +  .115978E+01, .872481E+00, .659413E+00, .500117E+00,
     +  .381456E+00, .291343E+00, .223922E+00, .172240E+00,
     +  .133075E+00, .103000E+00, .799417E-01, .621128E-01,
     +  .483460E-01, .376237E-01, .292929E-01, .227835E-01,
     +  .177180E-01, .137485E-01, .106560E-01, .823378E-02,
     +  .634711E-02, .488107E-02, .373380E-02, .284032E-02,
     +  .215058E-02, .161825E-02, .121114E-02, .899798E-03,
     +  .664437E-03, .486707E-03, .354011E-03, .255001E-03,
     +  .183182E-03, .130197E-03, .920915E-04, .647003E-04 /
        DATA (UPDI(I),I=625,676) /
     +  .453091E-04, .315470E-04, .219168E-04, .151049E-04,
     +  .102814E-04, .684562E-05, .439600E-05, .264669E-05,
     +  .143856E-05, .653610E-06, .203193E-06, .184223E-07,
     +  .000000E+00, .361570E+06, .277288E+06, .209474E+06,
     +  .158129E+06, .119302E+06, .899361E+05, .677567E+05,
     +  .510029E+05, .383661E+05, .288336E+05, .216538E+05,
     +  .162456E+05, .121785E+05, .911986E+04, .682350E+04,
     +  .509944E+04, .380743E+04, .283918E+04, .211502E+04,
     +  .157343E+04, .116926E+04, .867661E+03, .643104E+03,
     +  .475933E+03, .351779E+03, .259610E+03, .191405E+03,
     +  .140274E+03, .103136E+03, .757153E+02, .555352E+02,
     +  .406827E+02, .297828E+02, .218063E+02, .159557E+02,
     +  .116750E+02, .855221E+01, .627015E+01, .460695E+01 /
        DATA (UPDI(I),I=677,728) /
     +  .339106E+01, .250505E+01, .185563E+01, .137994E+01,
     +  .102979E+01, .771979E+00, .580772E+00, .439377E+00,
     +  .332887E+00, .253773E+00, .193637E+00, .148401E+00,
     +  .113954E+00, .877366E-01, .676326E-01, .522225E-01,
     +  .403217E-01, .311458E-01, .240367E-01, .185455E-01,
     +  .142797E-01, .109815E-01, .842075E-02, .644160E-02,
     +  .491641E-02, .373266E-02, .281916E-02, .211980E-02,
     +  .158484E-02, .117903E-02, .871429E-03, .640707E-03,
     +  .467920E-03, .339842E-03, .245010E-03, .176498E-03,
     +  .126207E-03, .900700E-04, .640698E-04, .455407E-04,
     +  .322616E-04, .228020E-04, .159702E-04, .110045E-04,
     +  .738013E-05, .473802E-05, .283021E-05, .151143E-05,
     +  .665975E-06, .198238E-06, .184060E-07, .000000E+00 /
        DATA (UPDI(I),I=729,780) /
     +  .534061E+06, .407756E+06, .306448E+06, .230138E+06,
     +  .172725E+06, .129527E+06, .970683E+05, .726788E+05,
     +  .543785E+05, .406473E+05, .303597E+05, .226527E+05,
     +  .168878E+05, .125762E+05, .935672E+04, .695313E+04,
     +  .516183E+04, .382706E+04, .283437E+04, .209625E+04,
     +  .154857E+04, .114227E+04, .841525E+03, .618982E+03,
     +  .454684E+03, .333453E+03, .244286E+03, .177866E+03,
     +  .129922E+03, .947520E+02, .690308E+02, .502257E+02,
     +  .365137E+02, .265475E+02, .192852E+02, .140090E+02,
     +  .101857E+02, .741195E+01, .540430E+01, .394749E+01,
     +  .289333E+01, .212651E+01, .156885E+01, .116154E+01,
     +  .863792E+00, .644692E+00, .483852E+00, .363686E+00,
     +  .275044E+00, .208214E+00, .158311E+00, .120619E+00 /
        DATA (UPDI(I),I=781,832) /
     +  .921393E-01, .704763E-01, .539922E-01, .413664E-01,
     +  .317050E-01, .242813E-01, .185894E-01, .142048E-01,
     +  .108404E-01, .825026E-02, .626369E-02, .474520E-02,
     +  .357620E-02, .268201E-02, .200300E-02, .148805E-02,
     +  .110052E-02, .809270E-03, .592458E-03, .431364E-03,
     +  .312777E-03, .225579E-03, .162826E-03, .116958E-03,
     +  .840176E-04, .602879E-04, .432735E-04, .309782E-04,
     +  .220933E-04, .155823E-04, .107696E-04, .721231E-05,
     +  .459641E-05, .270936E-05, .141669E-05, .604661E-06,
     +  .172615E-06, .163246E-07, .000000E+00, .760986E+06,
     +  .578494E+06, .432566E+06, .323201E+06, .241328E+06,
     +  .180040E+06, .134222E+06, .999713E+05, .744038E+05,
     +  .553207E+05, .410978E+05, .304993E+05, .226136E+05 /
        DATA (UPDI(I),I=833,884) /
     +  .167477E+05, .123912E+05, .915674E+04, .675936E+04,
     +  .498301E+04, .366925E+04, .269800E+04, .198140E+04,
     +  .145289E+04, .106395E+04, .777848E+03, .567877E+03,
     +  .413876E+03, .301291E+03, .217954E+03, .158173E+03,
     +  .114602E+03, .829354E+02, .599358E+02, .432729E+02,
     +  .312434E+02, .225350E+02, .162520E+02, .117298E+02,
     +  .847250E+01, .613104E+01, .444443E+01, .323251E+01,
     +  .235749E+01, .172570E+01, .126773E+01, .935369E+00,
     +  .692664E+00, .515789E+00, .384674E+00, .288640E+00,
     +  .216813E+00, .163568E+00, .123669E+00, .937415E-01,
     +  .711548E-01, .540926E-01, .411285E-01, .312826E-01,
     +  .237775E-01, .180656E-01, .137016E-01, .103779E-01,
     +  .784027E-02, .590862E-02, .444389E-02, .332523E-02 /
        DATA (UPDI(I),I=885,936) /
     +  .247684E-02, .183772E-02, .135705E-02, .998077E-03,
     +  .730489E-03, .532717E-03, .386849E-03, .280154E-03,
     +  .202171E-03, .146233E-03, .105475E-03, .761916E-04,
     +  .550501E-04, .397941E-04, .286802E-04, .205495E-04,
     +  .145252E-04, .100218E-04, .667312E-05, .420695E-05,
     +  .244038E-05, .124712E-05, .515309E-06, .141337E-06,
     +  .135830E-07, .000000E+00, .105385E+07, .797728E+06,
     +  .593529E+06, .441253E+06, .327813E+06, .243321E+06,
     +  .180468E+06, .133724E+06, .990066E+05, .732277E+05,
     +  .541130E+05, .399442E+05, .294570E+05, .216977E+05,
     +  .159656E+05, .117330E+05, .861272E+04, .631359E+04,
     +  .462256E+04, .337945E+04, .246743E+04, .179867E+04,
     +  .130933E+04, .951505E+03, .690432E+03, .500090E+03 /
        DATA (UPDI(I),I=937,988) /
     +  .361775E+03, .260031E+03, .187498E+03, .134968E+03,
     +  .970282E+02, .696519E+02, .499449E+02, .358126E+02,
     +  .256488E+02, .183662E+02, .131595E+02, .943574E+01,
     +  .677733E+01, .487621E+01, .351966E+01, .254740E+01,
     +  .185040E+01, .134894E+01, .987601E+00, .725720E+00,
     +  .536247E+00, .396864E+00, .295497E+00, .220268E+00,
     +  .164906E+00, .123740E+00, .930841E-01, .701249E-01,
     +  .529066E-01, .399262E-01, .301408E-01, .227402E-01,
     +  .171489E-01, .129112E-01, .970759E-02, .728126E-02,
     +  .544805E-02, .406886E-02, .302373E-02, .223764E-02,
     +  .165003E-02, .121161E-02, .886622E-03, .646216E-03,
     +  .469732E-03, .340438E-03, .246403E-03, .178012E-03,
     +  .129075E-03, .934802E-04, .678673E-04, .493127E-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .358309E-04, .259303E-04, .186098E-04, .131407E-04,
     +  .902354E-05, .595753E-05, .370710E-05, .211253E-05,
     +  .105382E-05, .421442E-06, .111256E-06, .108512E-07,
     +  .000000E+00, .142512E+07, .107428E+07, .795381E+06,
     +  .588410E+06, .434969E+06, .321245E+06, .237062E+06,
     +  .174767E+06, .128730E+06, .947199E+05, .696297E+05,
     +  .511278E+05, .375040E+05, .274771E+05, .201088E+05,
     +  .146971E+05, .107290E+05, .782118E+04, .569411E+04,
     +  .413920E+04, .300475E+04, .217765E+04, .157588E+04,
     +  .113840E+04, .821073E+03, .591079E+03, .424950E+03,
     +  .303500E+03, .217452E+03, .155525E+03, .111075E+03,
     +  .792079E+02, .564143E+02, .401763E+02, .285740E+02,
     +  .203170E+02, .144531E+02, .102885E+02, .733569E+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .523904E+01, .375332E+01, .269617E+01, .194367E+01,
     +  .140624E+01, .102173E+01, .745117E+00, .546415E+00,
     +  .401334E+00, .296565E+00, .219403E+00, .163024E+00,
     +  .121420E+00, .906575E-01, .677919E-01, .507666E-01,
     +  .380298E-01, .284985E-01, .213449E-01, .159796E-01,
     +  .119446E-01, .891677E-02, .664145E-02, .493491E-02,
     +  .366085E-02, .270274E-02, .198784E-02, .145744E-02,
     +  .106471E-02, .775656E-03, .563354E-03, .408468E-03,
     +  .295676E-03, .214041E-03, .154894E-03, .112632E-03,
     +  .819029E-04, .597303E-04, .435960E-04, .317879E-04,
     +  .230491E-04, .165301E-04, .116318E-04, .793152E-05,
     +  .518183E-05, .317754E-05, .177657E-05, .864327E-06,
     +  .334541E-06, .851497E-07, .842149E-08, .000000E+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .188791E+07, .141735E+07, .104433E+07, .768843E+06,
     +  .565574E+06, .415648E+06, .305203E+06, .223876E+06,
     +  .164069E+06, .120108E+06, .878383E+05, .641637E+05,
     +  .468195E+05, .341208E+05, .248375E+05, .180554E+05,
     +  .131088E+05, .950345E+04, .688038E+04, .497346E+04,
     +  .358984E+04, .258675E+04, .186104E+04, .133650E+04,
     +  .958213E+03, .685633E+03, .489911E+03, .347700E+03,
     +  .247556E+03, .175932E+03, .124838E+03, .884407E+02,
     +  .625709E+02, .442615E+02, .312635E+02, .220752E+02,
     +  .155931E+02, .110211E+02, .780129E+01, .553109E+01,
     +  .393342E+01, .280471E+01, .200689E+01, .144120E+01,
     +  .103931E+01, .752287E+00, .547569E+00, .399190E+00,
     +  .292789E+00, .215006E+00, .158578E+00, .117245E+00 /
        DATA (UPDI(I),I=1145,1196) /
     +  .868993E-01, .645091E-01, .479560E-01, .356654E-01,
     +  .265343E-01, .197324E-01, .146674E-01, .108872E-01,
     +  .807102E-02, .597091E-02, .440708E-02, .324832E-02,
     +  .238336E-02, .174291E-02, .127116E-02, .924397E-03,
     +  .670862E-03, .485874E-03, .351671E-03, .254448E-03,
     +  .184356E-03, .133705E-03, .975257E-04, .711931E-04,
     +  .521198E-04, .381675E-04, .278826E-04, .202174E-04,
     +  .144600E-04, .101197E-04, .684009E-05, .441527E-05,
     +  .266487E-05, .146038E-05, .692507E-06, .259451E-06,
     +  .637761E-07, .639224E-08, .000000E+00, .245558E+07,
     +  .183619E+07, .134654E+07, .986612E+06, .722281E+06,
     +  .528246E+06, .385985E+06, .281738E+06, .205446E+06,
     +  .149644E+06, .108884E+06, .791307E+05, .574425E+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .416446E+05, .301545E+05, .218041E+05, .157454E+05,
     +  .113530E+05, .817435E+04, .587607E+04, .421756E+04,
     +  .302185E+04, .216160E+04, .154335E+04, .110001E+04,
     +  .782391E+03, .555673E+03, .391929E+03, .277319E+03,
     +  .195849E+03, .138086E+03, .971959E+02, .683141E+02,
     +  .480042E+02, .336781E+02, .236177E+02, .165668E+02,
     +  .116273E+02, .817196E+01, .575248E+01, .406129E+01,
     +  .287487E+01, .204207E+01, .145575E+01, .104210E+01,
     +  .748774E+00, .541029E+00, .391535E+00, .285078E+00,
     +  .207821E+00, .152167E+00, .111696E+00, .821909E-01,
     +  .605781E-01, .447118E-01, .330175E-01, .243913E-01,
     +  .180126E-01, .132962E-01, .980235E-02, .721800E-02,
     +  .530506E-02, .389063E-02, .285021E-02, .207916E-02 /
        DATA (UPDI(I),I=1249,1300) /
     +  .151243E-02, .109786E-02, .795196E-03, .575279E-03,
     +  .415776E-03, .300630E-03, .217574E-03, .157870E-03,
     +  .114787E-03, .839908E-04, .615261E-04, .451788E-04,
     +  .331526E-04, .242274E-04, .175362E-04, .124866E-04,
     +  .867679E-05, .580516E-05, .369785E-05, .219465E-05,
     +  .117795E-05, .544201E-06, .197410E-06, .469395E-07,
     +  .476558E-08, .000000E+00, .258182E+05, .893038E+04,
     +  .712839E+04, .569003E+04, .454192E+04, .362549E+04,
     +  .289400E+04, .231011E+04, .184405E+04, .147204E+04,
     +  .117509E+04, .938069E+03, .748873E+03, .597854E+03,
     +  .477308E+03, .381086E+03, .304279E+03, .242969E+03,
     +  .194030E+03, .154964E+03, .123780E+03, .988863E+02,
     +  .790141E+02, .631501E+02, .504853E+02, .403741E+02 /
        DATA (UPDI(I),I=1301,1352) /
     +  .323012E+02, .257736E+02, .206444E+02, .165475E+02,
     +  .132745E+02, .106591E+02, .856858E+01, .690143E+01,
     +  .556404E+01, .449376E+01, .363641E+01, .294874E+01,
     +  .239628E+01, .195135E+01, .159268E+01, .130224E+01,
     +  .106643E+01, .874334E+00, .717318E+00, .588576E+00,
     +  .483075E+00, .395564E+00, .323735E+00, .263994E+00,
     +  .214793E+00, .174135E+00, .140585E+00, .112960E+00,
     +  .902812E-01, .717315E-01, .566267E-01, .443905E-01,
     +  .345360E-01, .266509E-01, .203865E-01, .154483E-01,
     +  .115879E-01, .860972E-02, .631068E-02, .456703E-02,
     +  .325987E-02, .229223E-02, .158571E-02, .107754E-02,
     +  .718021E-03, .468232E-03, .298038E-03, .184559E-03,
     +  .111372E-03, .647665E-04, .362562E-04, .194266E-04 /
        DATA (UPDI(I),I=1353,1404) /
     +  .989323E-05, .474631E-05, .212084E-05, .870948E-06,
     +  .320080E-06, .103197E-06, .278840E-07, .592041E-08,
     +  .886649E-09, .764859E-10, .241153E-11, .648654E-14,
     +  .000000E+00, .185951E+05, .148896E+05, .118157E+05,
     +  .937350E+04, .743656E+04, .589795E+04, .467794E+04,
     +  .370904E+04, .294097E+04, .233114E+04, .184785E+04,
     +  .146422E+04, .116029E+04, .919114E+03, .728103E+03,
     +  .576574E+03, .456609E+03, .361472E+03, .286181E+03,
     +  .226495E+03, .179281E+03, .141868E+03, .112284E+03,
     +  .888494E+02, .703256E+02, .556608E+02, .440733E+02,
     +  .347879E+02, .275697E+02, .218558E+02, .173432E+02,
     +  .137710E+02, .109492E+02, .872045E+01, .695426E+01,
     +  .555460E+01, .444719E+01, .356762E+01, .286971E+01 /
        DATA (UPDI(I),I=1405,1456) /
     +  .231312E+01, .186995E+01, .151456E+01, .122947E+01,
     +  .999415E+00, .813591E+00, .662588E+00, .540228E+00,
     +  .439557E+00, .357817E+00, .290327E+00, .235257E+00,
     +  .190037E+00, .153021E+00, .122704E+00, .979797E-01,
     +  .778294E-01, .614977E-01, .482952E-01, .376974E-01,
     +  .292170E-01, .224870E-01, .171702E-01, .130062E-01,
     +  .977957E-02, .727512E-02, .535735E-02, .390542E-02,
     +  .281498E-02, .200632E-02, .141157E-02, .980570E-03,
     +  .670947E-03, .452141E-03, .298400E-03, .194068E-03,
     +  .122592E-03, .751191E-04, .440645E-04, .243110E-04,
     +  .120989E-04, .487777E-05, .924583E-06, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .308805E+05, .233653E+05, .184194E+05, .145148E+05,
     +  .114384E+05, .901026E+04, .709782E+04, .558887E+04,
     +  .440082E+04, .346374E+04, .272624E+04, .214474E+04,
     +  .168730E+04, .132676E+04, .104328E+04, .819942E+03,
     +  .644431E+03, .506224E+03, .397670E+03, .312236E+03,
     +  .245178E+03, .192431E+03, .151053E+03, .118524E+03,
     +  .930202E+02, .729879E+02, .572934E+02, .448179E+02,
     +  .352031E+02, .276539E+02, .217453E+02, .171070E+02,
     +  .134766E+02, .106335E+02, .840167E+01, .664826E+01,
     +  .527426E+01, .419238E+01, .334228E+01, .267022E+01,
     +  .214033E+01, .171910E+01, .138446E+01, .111674E+01,
     +  .902567E+00, .729973E+00, .591410E+00, .478292E+00,
     +  .387267E+00, .312643E+00, .252233E+00, .202944E+00 /
        DATA (UPDI(I),I=1509,1560) /
     +  .162880E+00, .130247E+00, .103791E+00, .823216E-01,
     +  .649998E-01, .510407E-01, .398747E-01, .309539E-01,
     +  .238886E-01, .183076E-01, .139371E-01, .105455E-01,
     +  .790742E-02, .587839E-02, .433511E-02, .316787E-02,
     +  .229553E-02, .164688E-02, .117117E-02, .823971E-03,
     +  .574113E-03, .394456E-03, .269469E-03, .181018E-03,
     +  .120070E-03, .782559E-04, .501524E-04, .313780E-04,
     +  .191679E-04, .113422E-04, .643454E-05, .346943E-05,
     +  .175879E-05, .811411E-06, .332646E-06, .112084E-06,
     +  .234477E-07, .000000E+00, .000000E+00, .580101E+05,
     +  .457599E+05, .357072E+05, .278520E+05, .217227E+05,
     +  .169352E+05, .132013E+05, .102861E+05, .801361E+04,
     +  .624026E+04, .485867E+04, .378108E+04, .294204E+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .228799E+04, .177907E+04, .138259E+04, .107430E+04,
     +  .834271E+03, .647773E+03, .502678E+03, .390043E+03,
     +  .302479E+03, .234558E+03, .181795E+03, .140902E+03,
     +  .109171E+03, .846080E+02, .653209E+02, .506364E+02,
     +  .392521E+02, .304516E+02, .236327E+02, .183622E+02,
     +  .142896E+02, .111338E+02, .868789E+01, .679651E+01,
     +  .532760E+01, .418888E+01, .330117E+01, .261081E+01,
     +  .206973E+01, .164571E+01, .131126E+01, .104737E+01,
     +  .837621E+00, .671478E+00, .537603E+00, .431277E+00,
     +  .345165E+00, .276270E+00, .220685E+00, .175979E+00,
     +  .139925E+00, .110959E+00, .876462E-01, .689736E-01,
     +  .540262E-01, .421384E-01, .326861E-01, .252285E-01,
     +  .193549E-01, .147621E-01, .112014E-01, .842873E-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .629194E-02, .466113E-02, .342243E-02, .249119E-02,
     +  .179399E-02, .127834E-02, .898611E-03, .622796E-03,
     +  .422634E-03, .282336E-03, .182580E-03, .113870E-03,
     +  .672593E-04, .366447E-04, .172235E-04, .559322E-05,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .102678E+06, .803775E+05,
     +  .621776E+05, .480784E+05, .371691E+05, .287221E+05,
     +  .221901E+05, .171354E+05, .132291E+05, .102081E+05,
     +  .787511E+04, .607201E+04, .468055E+04, .360591E+04,
     +  .277726E+04, .213774E+04, .164504E+04, .126510E+04,
     +  .972632E+03, .747302E+03, .574037E+03, .440668E+03,
     +  .338212E+03, .259422E+03, .198955E+03, .152515E+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .116931E+03, .892796E+02, .684431E+02, .524623E+02,
     +  .402372E+02, .308686E+02, .237042E+02, .182304E+02,
     +  .140350E+02, .108208E+02, .836288E+01, .647640E+01,
     +  .503064E+01, .391706E+01, .306114E+01, .239844E+01,
     +  .188520E+01, .148535E+01, .117358E+01, .928767E+00,
     +  .737108E+00, .584488E+00, .464645E+00, .368672E+00,
     +  .292697E+00, .232042E+00, .183732E+00, .145145E+00,
     +  .114412E+00, .898855E-01, .703900E-01, .548990E-01,
     +  .426587E-01, .329862E-01, .253956E-01, .194468E-01,
     +  .148140E-01, .112352E-01, .845577E-02, .631874E-02,
     +  .469019E-02, .345450E-02, .252559E-02, .182986E-02,
     +  .131451E-02, .934289E-03, .657015E-03, .455095E-03,
     +  .312521E-03, .210272E-03, .138972E-03, .896845E-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .564053E-04, .342771E-04, .200490E-04, .111603E-04,
     +  .581557E-05, .278992E-05, .120353E-05, .442643E-06,
     +  .133945E-06, .320040E-07, .484457E-08, .000000E+00,
     +  .000000E+00, .168345E+06, .130918E+06, .100515E+06,
     +  .771365E+05, .591796E+05, .453799E+05, .347880E+05,
     +  .266541E+05, .204157E+05, .156286E+05, .119601E+05,
     +  .914725E+04, .699350E+04, .534352E+04, .408132E+04,
     +  .311521E+04, .237689E+04, .181229E+04, .138127E+04,
     +  .105201E+04, .800950E+03, .609375E+03, .463457E+03,
     +  .352241E+03, .267629E+03, .203231E+03, .154331E+03,
     +  .116682E+03, .885709E+02, .672157E+02, .510309E+02,
     +  .387483E+02, .294448E+02, .224076E+02, .170663E+02,
     +  .130161E+02, .994993E+01, .762130E+01, .585490E+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .450903E+01, .348537E+01, .270147E+01, .210080E+01,
     +  .163802E+01, .128104E+01, .100382E+01, .789074E+00,
     +  .619925E+00, .488470E+00, .384295E+00, .302636E+00,
     +  .238088E+00, .187150E+00, .146835E+00, .114996E+00,
     +  .897984E-01, .699225E-01, .542486E-01, .419472E-01,
     +  .322917E-01, .247594E-01, .188906E-01, .143432E-01,
     +  .108471E-01, .814336E-02, .607325E-02, .450129E-02,
     +  .331260E-02, .242143E-02, .175574E-02, .126356E-02,
     +  .901131E-03, .637009E-03, .444942E-03, .309088E-03,
     +  .211531E-03, .143224E-03, .956630E-04, .631477E-04,
     +  .410698E-04, .264120E-04, .167450E-04, .104477E-04,
     +  .639859E-05, .382031E-05, .217288E-05, .114148E-05,
     +  .514786E-06, .162436E-06, .135267E-07, .000000E+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .261391E+06, .202085E+06, .154109E+06, .117462E+06,
     +  .894994E+05, .681552E+05, .518825E+05, .394717E+05,
     +  .300182E+05, .228147E+05, .173327E+05, .131593E+05,
     +  .998644E+04, .757338E+04, .574078E+04, .434847E+04,
     +  .329226E+04, .249070E+04, .188336E+04, .142300E+04,
     +  .107465E+04, .810943E+03, .611652E+03, .460982E+03,
     +  .347272E+03, .261437E+03, .196796E+03, .147450E+03,
     +  .110917E+03, .834050E+02, .627324E+02, .471844E+02,
     +  .355107E+02, .267619E+02, .201812E+02, .152384E+02,
     +  .115310E+02, .874276E+01, .664775E+01, .506740E+01,
     +  .387701E+01, .297468E+01, .229006E+01, .176803E+01,
     +  .136932E+01, .106287E+01, .827824E+00, .644564E+00,
     +  .503506E+00, .392825E+00, .306872E+00, .239571E+00 /
        DATA (UPDI(I),I=1873,1924) /
     +  .186926E+00, .145629E+00, .113281E+00, .878911E-01,
     +  .680168E-01, .524635E-01, .403411E-01, .308929E-01,
     +  .235687E-01, .178984E-01, .135296E-01, .101892E-01,
     +  .761941E-02, .566220E-02, .418303E-02, .306977E-02,
     +  .223864E-02, .162047E-02, .116508E-02, .831010E-03,
     +  .588281E-03, .412389E-03, .288075E-03, .198950E-03,
     +  .136479E-03, .928558E-04, .628093E-04, .421623E-04,
     +  .281730E-04, .186681E-04, .122155E-04, .784065E-05,
     +  .487222E-05, .285296E-05, .151641E-05, .676789E-06,
     +  .207278E-06, .184255E-07, .000000E+00, .389507E+06,
     +  .299512E+06, .226983E+06, .171921E+06, .130164E+06,
     +  .984879E+05, .744884E+05, .563007E+05, .425343E+05,
     +  .321122E+05, .242320E+05, .182725E+05, .137715E+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .103714E+05, .780651E+04, .587127E+04, .441325E+04,
     +  .331454E+04, .248787E+04, .186578E+04, .139842E+04,
     +  .104721E+04, .783744E+03, .586056E+03, .437980E+03,
     +  .327061E+03, .244176E+03, .181407E+03, .135305E+03,
     +  .100872E+03, .752068E+02, .560661E+02, .418140E+02,
     +  .312251E+02, .233279E+02, .174491E+02, .130780E+02,
     +  .982078E+01, .739527E+01, .558276E+01, .422997E+01,
     +  .321430E+01, .245087E+01, .187437E+01, .143819E+01,
     +  .110617E+01, .853888E+00, .659083E+00, .510502E+00,
     +  .395017E+00, .306131E+00, .237164E+00, .183674E+00,
     +  .142074E+00, .109750E+00, .845847E-01, .650367E-01,
     +  .498554E-01, .381062E-01, .290144E-01, .220129E-01,
     +  .166285E-01, .125051E-01, .937120E-02, .697433E-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .515964E-02, .379571E-02, .277485E-02, .201654E-02,
     +  .145549E-02, .104410E-02, .743735E-03, .526411E-03,
     +  .369619E-03, .259030E-03, .179957E-03, .124535E-03,
     +  .857764E-04, .589283E-04, .403161E-04, .275056E-04,
     +  .186224E-04, .124280E-04, .810342E-05, .507912E-05,
     +  .297550E-05, .156506E-05, .681446E-06, .200853E-06,
     +  .184087E-07, .000000E+00, .561727E+06, .429762E+06,
     +  .323784E+06, .243792E+06, .183477E+06, .137991E+06,
     +  .103730E+06, .779208E+05, .585021E+05, .438904E+05,
     +  .329096E+05, .246569E+05, .184626E+05, .138132E+05,
     +  .103281E+05, .771565E+04, .576018E+04, .429642E+04,
     +  .320240E+04, .238472E+04, .177459E+04, .131930E+04,
     +  .980118E+03, .727444E+03, .539534E+03, .399803E+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .296155E+03, .218260E+03, .161482E+03, .119405E+03,
     +  .882845E+02, .652609E+02, .482533E+02, .357211E+02,
     +  .264505E+02, .196078E+02, .145626E+02, .108357E+02,
     +  .808427E+01, .604655E+01, .453894E+01, .341729E+01,
     +  .258171E+01, .195653E+01, .148775E+01, .113419E+01,
     +  .867954E+00, .664256E+00, .510249E+00, .391630E+00,
     +  .301118E+00, .231504E+00, .177958E+00, .136662E+00,
     +  .104827E+00, .802414E-01, .612889E-01, .466818E-01,
     +  .354573E-01, .268346E-01, .202391E-01, .152017E-01,
     +  .113685E-01, .847348E-02, .627312E-02, .461778E-02,
     +  .338102E-02, .246088E-02, .178122E-02, .128124E-02,
     +  .916535E-03, .651656E-03, .460912E-03, .323930E-03,
     +  .227559E-03, .158843E-03, .110690E-03, .769652E-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .534788E-04, .370673E-04, .256161E-04, .175487E-04,
     +  .118130E-04, .773584E-05, .483967E-05, .281122E-05,
     +  .145346E-05, .614939E-06, .174283E-06, .163267E-07,
     +  .000000E+00, .788382E+06, .600284E+06, .449730E+06,
     +  .336718E+06, .251970E+06, .188417E+06, .140814E+06,
     +  .105158E+06, .784831E+05, .585283E+05, .436192E+05,
     +  .324808E+05, .241703E+05, .179702E+05, .133510E+05,
     +  .990994E+04, .735022E+04, .544635E+04, .403245E+04,
     +  .298257E+04, .220427E+04, .162738E+04, .120048E+04,
     +  .884638E+03, .651366E+03, .479114E+03, .352250E+03,
     +  .257602E+03, .189119E+03, .138747E+03, .101767E+03,
     +  .746188E+02, .547177E+02, .401695E+02, .294916E+02,
     +  .216746E+02, .159572E+02, .117693E+02, .870297E+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .645149E+01, .479972E+01, .358151E+01, .268177E+01,
     +  .201453E+01, .151851E+01, .114771E+01, .870891E+00,
     +  .660970E+00, .503598E+00, .383447E+00, .292531E+00,
     +  .223200E+00, .170303E+00, .129839E+00, .988890E-01,
     +  .751755E-01, .570334E-01, .431564E-01, .325692E-01,
     +  .244952E-01, .183619E-01, .137100E-01, .101933E-01,
     +  .755458E-02, .556203E-02, .407289E-02, .296725E-02,
     +  .214980E-02, .154955E-02, .111064E-02, .792218E-03,
     +  .562207E-03, .397374E-03, .279525E-03, .196824E-03,
     +  .137994E-03, .967554E-04, .678135E-04, .475427E-04,
     +  .332643E-04, .231768E-04, .159766E-04, .107832E-04,
     +  .705025E-05, .437957E-05, .251142E-05, .127218E-05,
     +  .522098E-06, .142396E-06, .135846E-07, .000000E+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .108098E+07, .819302E+06, .610520E+06, .454632E+06,
     +  .338346E+06, .251610E+06, .186991E+06, .138855E+06,
     +  .103041E+06, .763999E+05, .566062E+05, .419031E+05,
     +  .309956E+05, .229057E+05, .169138E+05, .124768E+05,
     +  .919609E+04, .677090E+04, .498090E+04, .366011E+04,
     +  .268714E+04, .197060E+04, .144379E+04, .105661E+04,
     +  .772546E+03, .564205E+03, .411813E+03, .298924E+03,
     +  .217821E+03, .158597E+03, .115431E+03, .839782E+02,
     +  .610916E+02, .444886E+02, .323951E+02, .236113E+02,
     +  .172370E+02, .126056E+02, .924163E+01, .679202E+01,
     +  .500950E+01, .370588E+01, .275104E+01, .204895E+01,
     +  .153137E+01, .114774E+01, .863748E+00, .650215E+00,
     +  .491448E+00, .371258E+00, .281054E+00, .212833E+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .161195E+00, .122010E+00, .922678E-01, .696571E-01,
     +  .524885E-01, .394545E-01, .295816E-01, .221072E-01,
     +  .164686E-01, .122220E-01, .903285E-02, .665590E-02,
     +  .487288E-02, .354927E-02, .257281E-02, .185546E-02,
     +  .133189E-02, .951359E-03, .676800E-03, .479532E-03,
     +  .338825E-03, .238627E-03, .168464E-03, .118629E-03,
     +  .836582E-04, .590405E-04, .416892E-04, .293663E-04,
     +  .205603E-04, .142070E-04, .957638E-05, .622781E-05,
     +  .382896E-05, .216180E-05, .107080E-05, .425902E-06,
     +  .111925E-06, .108525E-07, .000000E+00, .145198E+07,
     +  .109564E+07, .812200E+06, .601652E+06, .445392E+06,
     +  .329447E+06, .243515E+06, .179842E+06, .132720E+06,
     +  .978567E+05, .720945E+05, .530640E+05, .390244E+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .286706E+05, .210452E+05, .154316E+05, .113049E+05,
     +  .827244E+04, .604757E+04, .441592E+04, .322129E+04,
     +  .234699E+04, .170824E+04, .124180E+04, .901798E+03,
     +  .654057E+03, .474056E+03, .341629E+03, .247144E+03,
     +  .178632E+03, .129045E+03, .931734E+02, .672596E+02,
     +  .485997E+02, .351082E+02, .253837E+02, .183802E+02,
     +  .133315E+02, .969293E+01, .706448E+01, .516691E+01,
     +  .379041E+01, .279029E+01, .206095E+01, .152762E+01,
     +  .113558E+01, .847712E+00, .633050E+00, .474721E+00,
     +  .355848E+00, .267343E+00, .200946E+00, .151078E+00,
     +  .113532E+00, .852498E-01, .639140E-01, .478338E-01,
     +  .357167E-01, .266039E-01, .197549E-01, .146240E-01,
     +  .107868E-01, .792442E-02, .580533E-02, .422636E-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .306212E-02, .220876E-02, .158584E-02, .113393E-02,
     +  .807425E-03, .573108E-03, .405606E-03, .286642E-03,
     +  .202212E-03, .143181E-03, .101275E-03, .718065E-04,
     +  .509788E-04, .361977E-04, .256128E-04, .179714E-04,
     +  .124113E-04, .833093E-05, .537453E-05, .326309E-05,
     +  .181053E-05, .875768E-06, .337452E-06, .855704E-07,
     +  .842240E-08, .000000E+00, .191450E+07, .143850E+07,
     +  .106098E+07, .781948E+06, .575888E+06, .423763E+06,
     +  .311586E+06, .228896E+06, .168015E+06, .123209E+06,
     +  .902748E+05, .660771E+05, .483217E+05, .352997E+05,
     +  .257622E+05, .187805E+05, .136771E+05, .994861E+04,
     +  .722893E+04, .524621E+04, .380316E+04, .275349E+04,
     +  .199129E+04, .143818E+04, .103753E+04, .747460E+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .538073E+03, .385053E+03, .276609E+03, .198510E+03,
     +  .142369E+03, .102041E+03, .731117E+02, .524302E+02,
     +  .375843E+02, .269628E+02, .193698E+02, .139376E+02,
     +  .100522E+02, .726725E+01, .527208E+01, .383616E+01,
     +  .280103E+01, .205215E+01, .150886E+01, .111267E+01,
     +  .824065E+00, .610573E+00, .454336E+00, .337974E+00,
     +  .252013E+00, .188031E+00, .140343E+00, .104714E+00,
     +  .780761E-01, .581327E-01, .432123E-01, .320518E-01,
     +  .237180E-01, .174996E-01, .128733E-01, .943776E-02,
     +  .689204E-02, .502009E-02, .363459E-02, .261985E-02,
     +  .188082E-02, .134474E-02, .958134E-03, .680411E-03,
     +  .482110E-03, .341014E-03, .241176E-03, .170503E-03,
     +  .121126E-03, .860556E-04, .613174E-04, .437470E-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .311877E-04, .221218E-04, .155200E-04, .106869E-04,
     +  .712721E-05, .455193E-05, .272460E-05, .148366E-05,
     +  .700166E-06, .261340E-06, .640392E-07, .639289E-08,
     +  .000000E+00, .248190E+07, .185712E+07, .136301E+07,
     +  .999581E+06, .732486E+06, .536274E+06, .392299E+06,
     +  .286703E+06, .209348E+06, .152710E+06, .111292E+06,
     +  .810214E+05, .589265E+05, .428088E+05, .310675E+05,
     +  .225198E+05, .163061E+05, .117920E+05, .851794E+04,
     +  .614482E+04, .442764E+04, .318596E+04, .228972E+04,
     +  .164328E+04, .117790E+04, .843054E+03, .602879E+03,
     +  .428499E+03, .305724E+03, .217892E+03, .155172E+03,
     +  .110427E+03, .785474E+02, .559162E+02, .397844E+02,
     +  .283258E+02, .201932E+02, .144180E+02, .103177E+02 /
        DATA (UPDI(I),I=2497,2548) /
     +  .740063E+01, .532648E+01, .384512E+01, .278535E+01,
     +  .202458E+01, .147688E+01, .108059E+01, .794125E+00,
     +  .583868E+00, .431175E+00, .318340E+00, .235621E+00,
     +  .174525E+00, .129328E+00, .958146E-01, .709430E-01,
     +  .524606E-01, .387337E-01, .285403E-01, .209824E-01,
     +  .153831E-01, .112461E-01, .819520E-02, .594954E-02,
     +  .430930E-02, .310333E-02, .222591E-02, .159090E-02,
     +  .113311E-02, .804833E-03, .570293E-03, .403608E-03,
     +  .285497E-03, .202177E-03, .143296E-03, .102154E-03,
     +  .728839E-04, .521555E-04, .373516E-04, .266939E-04,
     +  .189444E-04, .132627E-04, .908749E-05, .601055E-05,
     +  .379427E-05, .223613E-05, .119382E-05, .549298E-06,
     +  .198629E-06, .471033E-07, .476604E-08, .000000E+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .204869E+05, .223515E+05, .178441E+05, .142459E+05,
     +  .113736E+05, .908062E+04, .725015E+04, .578887E+04,
     +  .462230E+04, .369099E+04, .294747E+04, .235386E+04,
     +  .187994E+04, .150155E+04, .119943E+04, .958199E+03,
     +  .765576E+03, .611760E+03, .488927E+03, .390830E+03,
     +  .312483E+03, .249905E+03, .199919E+03, .159985E+03,
     +  .128081E+03, .102587E+03, .822129E+02, .657220E+02,
     +  .527491E+02, .423742E+02, .340748E+02, .274336E+02,
     +  .221171E+02, .178707E+02, .144587E+02, .117237E+02,
     +  .952936E+01, .776670E+01, .634874E+01, .520558E+01,
     +  .428338E+01, .353638E+01, .292991E+01, .243597E+01,
     +  .203225E+01, .170095E+01, .142863E+01, .120114E+01,
     +  .101186E+01, .850770E+00, .713448E+00, .594581E+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .490864E+00, .400201E+00, .321436E+00, .253946E+00,
     +  .197223E+00, .150595E+00, .113116E+00, .836268E-01,
     +  .608722E-01, .436227E-01, .307595E-01, .213545E-01,
     +  .145147E-01, .965705E-02, .626853E-02, .395182E-02,
     +  .240401E-02, .139758E-02, .764310E-03, .381882E-03,
     +  .162969E-03, .468275E-04, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .352250E+05,
     +  .282767E+05, .225042E+05, .179077E+05, .142509E+05,
     +  .113393E+05, .902310E+04, .717903E+04, .571222E+04,
     +  .454450E+04, .361575E+04, .287644E+04, .228849E+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .182051E+04, .144838E+04, .115220E+04, .916704E+03,
     +  .729290E+03, .580287E+03, .461715E+03, .367454E+03,
     +  .292450E+03, .232825E+03, .185381E+03, .147665E+03,
     +  .117656E+03, .937985E+02, .745755E+02, .595341E+02,
     +  .475593E+02, .380342E+02, .304480E+02, .244101E+02,
     +  .196104E+02, .157767E+02, .127186E+02, .102796E+02,
     +  .832992E+01, .677083E+01, .551992E+01, .451673E+01,
     +  .370798E+01, .305507E+01, .252572E+01, .209542E+01,
     +  .174377E+01, .145619E+01, .121690E+01, .101887E+01,
     +  .851158E+00, .709147E+00, .587125E+00, .481664E+00,
     +  .390392E+00, .311953E+00, .245402E+00, .189981E+00,
     +  .144766E+00, .108657E+00, .803755E-01, .586304E-01,
     +  .421791E-01, .299197E-01, .209513E-01, .144143E-01 /
        DATA (UPDI(I),I=2705,2756) /
     +  .974999E-02, .647494E-02, .421253E-02, .267964E-02,
     +  .166109E-02, .100097E-02, .583426E-03, .327762E-03,
     +  .175462E-03, .899888E-04, .428745E-04, .185992E-04,
     +  .665283E-05, .115609E-05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .255687E+05, .367207E+05,
     +  .290827E+05, .230289E+05, .182367E+05, .144388E+05,
     +  .114328E+05, .905072E+04, .716556E+04, .567190E+04,
     +  .448998E+04, .355364E+04, .281283E+04, .222602E+04,
     +  .176183E+04, .139418E+04, .110340E+04, .873131E+03,
     +  .691033E+03, .546849E+03, .432851E+03, .342599E+03,
     +  .271250E+03, .214767E+03, .170115E+03, .134775E+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .106840E+03, .844509E+02, .670324E+02, .532383E+02,
     +  .423306E+02, .336895E+02, .268523E+02, .214464E+02,
     +  .171541E+02, .137483E+02, .110481E+02, .890083E+01,
     +  .719381E+01, .583131E+01, .474487E+01, .387344E+01,
     +  .317378E+01, .260929E+01, .215284E+01, .178151E+01,
     +  .147936E+01, .122902E+01, .102295E+01, .849306E+00,
     +  .703229E+00, .578614E+00, .471853E+00, .380309E+00,
     +  .302402E+00, .236901E+00, .182810E+00, .138989E+00,
     +  .104202E+00, .770768E-01, .562938E-01, .406052E-01,
     +  .289272E-01, .203847E-01, .141501E-01, .968774E-02,
     +  .654023E-02, .435004E-02, .285131E-02, .184051E-02,
     +  .117225E-02, .737068E-03, .459665E-03, .284422E-03,
     +  .177812E-03, .111658E-03, .713882E-04, .463249E-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .305608E-04, .201674E-04, .132318E-04, .846036E-05,
     +  .518154E-05, .298953E-05, .160367E-05, .771419E-06,
     +  .325230E-06, .111260E-06, .234120E-07, .000000E+00,
     +  .000000E+00, .745357E+05, .590630E+05, .463287E+05,
     +  .363329E+05, .284945E+05, .223426E+05, .175193E+05,
     +  .137344E+05, .107676E+05, .843982E+04, .661552E+04,
     +  .518445E+04, .406314E+04, .318369E+04, .249475E+04,
     +  .195450E+04, .153139E+04, .119965E+04, .939885E+03,
     +  .736264E+03, .576868E+03, .451943E+03, .354165E+03,
     +  .277542E+03, .217576E+03, .170597E+03, .133843E+03,
     +  .104684E+03, .822289E+02, .646275E+02, .508510E+02,
     +  .400487E+02, .315881E+02, .249669E+02, .197630E+02,
     +  .156757E+02, .124677E+02, .994203E+01, .795412E+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .638295E+01, .514234E+01, .415674E+01, .337280E+01,
     +  .274612E+01, .224394E+01, .183892E+01, .151220E+01,
     +  .124377E+01, .102482E+01, .842078E+00, .690030E+00,
     +  .561940E+00, .453746E+00, .362375E+00, .285800E+00,
     +  .222350E+00, .170633E+00, .129205E+00, .966232E-01,
     +  .714018E-01, .521839E-01, .377331E-01, .269970E-01,
     +  .191490E-01, .134120E-01, .929110E-02, .636706E-02,
     +  .431458E-02, .289263E-02, .191741E-02, .125818E-02,
     +  .816383E-03, .524503E-03, .331792E-03, .208474E-03,
     +  .127705E-03, .759480E-04, .427327E-04, .217961E-04,
     +  .883667E-05, .121083E-05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .119141E+06, .936307E+05, .727594E+05, .565275E+05,
     +  .439157E+05, .341094E+05, .264921E+05, .205709E+05,
     +  .159728E+05, .123994E+05, .962536E+04, .747008E+04,
     +  .579739E+04, .449817E+04, .349016E+04, .270742E+04,
     +  .210031E+04, .162898E+04, .126352E+04, .979883E+03,
     +  .760029E+03, .589437E+03, .457235E+03, .354675E+03,
     +  .275208E+03, .213579E+03, .165852E+03, .128369E+03,
     +  .997953E+02, .776249E+02, .604470E+02, .471147E+02,
     +  .367772E+02, .287695E+02, .225387E+02, .176943E+02,
     +  .139299E+02, .109957E+02, .870889E+01, .691920E+01,
     +  .551964E+01, .441839E+01, .355056E+01, .286324E+01,
     +  .231738E+01, .188100E+01, .153201E+01, .124776E+01,
     +  .101802E+01, .828112E+00, .671782E+00, .541663E+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .433196E+00, .342873E+00, .268231E+00, .207212E+00,
     +  .158076E+00, .119137E+00, .887857E-01, .654652E-01,
     +  .478005E-01, .345787E-01, .247861E-01, .176425E-01,
     +  .124231E-01, .867117E-02, .600257E-02, .412157E-02,
     +  .281000E-02, .190230E-02, .128114E-02, .858302E-03,
     +  .573131E-03, .380360E-03, .253181E-03, .167000E-03,
     +  .109547E-03, .709336E-04, .452153E-04, .280459E-04,
     +  .168404E-04, .964591E-05, .517668E-05, .255269E-05,
     +  .112940E-05, .424173E-06, .130645E-06, .316486E-07,
     +  .482936E-08, .000000E+00, .000000E+00, .184749E+06,
     +  .144123E+06, .111059E+06, .855550E+05, .659017E+05,
     +  .507476E+05, .390744E+05, .300772E+05, .231494E+05,
     +  .178120E+05, .137039E+05, .105402E+05, .810620E+04 /
        DATA (UPDI(I),I=3017,3068) /
     +  .623243E+04, .479152E+04, .368268E+04, .283036E+04,
     +  .217471E+04, .167095E+04, .128359E+04, .986110E+03,
     +  .757447E+03, .581893E+03, .446993E+03, .343454E+03,
     +  .263926E+03, .202931E+03, .155490E+03, .119676E+03,
     +  .921588E+02, .710448E+02, .548189E+02, .423597E+02,
     +  .328038E+02, .254407E+02, .197723E+02, .154102E+02,
     +  .120435E+02, .944460E+01, .743040E+01, .587010E+01,
     +  .465396E+01, .370434E+01, .295913E+01, .237252E+01,
     +  .190768E+01, .153912E+01, .124157E+01, .100323E+01,
     +  .808114E+00, .649171E+00, .518407E+00, .410754E+00,
     +  .322281E+00, .250117E+00, .191856E+00, .145473E+00,
     +  .109085E+00, .809668E-01, .595187E-01, .433695E-01,
     +  .313411E-01, .224650E-01, .160080E-01, .112984E-01 /
        DATA (UPDI(I),I=3069,3120) /
     +  .791534E-02, .550813E-02, .380858E-02, .261974E-02,
     +  .179308E-02, .122357E-02, .832613E-03, .566032E-03,
     +  .383719E-03, .261532E-03, .177459E-03, .120411E-03,
     +  .813347E-04, .547163E-04, .364399E-04, .240622E-04,
     +  .156522E-04, .999397E-05, .623288E-05, .376946E-05,
     +  .216044E-05, .113930E-05, .514556E-06, .162426E-06,
     +  .135266E-07, .000000E+00, .277736E+06, .215244E+06,
     +  .164615E+06, .125851E+06, .961977E+05, .735038E+05,
     +  .561536E+05, .428826E+05, .327422E+05, .249902E+05,
     +  .190702E+05, .145471E+05, .110950E+05, .845900E+04,
     +  .644830E+04, .491376E+04, .374395E+04, .285165E+04,
     +  .217183E+04, .165357E+04, .125897E+04, .958308E+03,
     +  .729489E+03, .555224E+03, .422657E+03, .321751E+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .245064E+03, .185968E+03, .141764E+03, .108120E+03,
     +  .825424E+02, .630723E+02, .482613E+02, .370099E+02,
     +  .284216E+02, .218733E+02, .168813E+02, .130651E+02,
     +  .101468E+02, .790643E+01, .618686E+01, .485898E+01,
     +  .383142E+01, .303229E+01, .240873E+01, .191889E+01,
     +  .153383E+01, .122568E+01, .981043E+00, .782698E+00,
     +  .622770E+00, .492667E+00, .386825E+00, .300915E+00,
     +  .231697E+00, .176471E+00, .132975E+00, .991811E-01,
     +  .732840E-01, .536728E-01, .389965E-01, .281216E-01,
     +  .201302E-01, .143363E-01, .101215E-01, .709965E-02,
     +  .495167E-02, .343538E-02, .237370E-02, .163406E-02,
     +  .112283E-02, .770402E-03, .528728E-03, .362494E-03,
     +  .250107E-03, .172204E-03, .118839E-03, .819318E-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .564692E-04, .387286E-04, .264549E-04, .178807E-04,
     +  .118937E-04, .772504E-05, .483737E-05, .284460E-05,
     +  .151497E-05, .676639E-06, .207272E-06, .184255E-07,
     +  .000000E+00, .405796E+06, .312624E+06, .237453E+06,
     +  .180281E+06, .136839E+06, .103818E+06, .787446E+05,
     +  .596995E+05, .452487E+05, .342800E+05, .259633E+05,
     +  .196553E+05, .148760E+05, .112537E+05, .851136E+04,
     +  .643438E+04, .486315E+04, .367402E+04, .277513E+04,
     +  .209534E+04, .158188E+04, .119386E+04, .900966E+03,
     +  .679770E+03, .512909E+03, .386979E+03, .292098E+03,
     +  .219621E+03, .165884E+03, .125347E+03, .948034E+02,
     +  .717629E+02, .543929E+02, .413185E+02, .314288E+02,
     +  .239581E+02, .183146E+02, .140403E+02, .108014E+02 /
        DATA (UPDI(I),I=3225,3276) /
     +  .833768E+01, .646366E+01, .502958E+01, .392958E+01,
     +  .308168E+01, .242571E+01, .191484E+01, .151664E+01,
     +  .120074E+01, .952173E+00, .752544E+00, .593191E+00,
     +  .464963E+00, .361831E+00, .279106E+00, .213226E+00,
     +  .161250E+00, .120735E+00, .895482E-01, .658435E-01,
     +  .480213E-01, .347665E-01, .249981E-01, .178525E-01,
     +  .126921E-01, .895078E-02, .627594E-02, .437864E-02,
     +  .304127E-02, .210545E-02, .145350E-02, .100242E-02,
     +  .690969E-03, .476849E-03, .329185E-03, .228855E-03,
     +  .159045E-03, .110945E-03, .774765E-04, .541766E-04,
     +  .377777E-04, .262533E-04, .180568E-04, .122004E-04,
     +  .802298E-05, .505530E-05, .296989E-05, .156411E-05,
     +  .681350E-06, .200849E-06, .184087E-07, .000000E+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .577959E+06, .442829E+06, .334217E+06, .252122E+06,
     +  .190128E+06, .143302E+06, .107971E+06, .813077E+05,
     +  .612069E+05, .460505E+05, .346347E+05, .260347E+05,
     +  .195631E+05, .146922E+05, .110303E+05, .827656E+04,
     +  .620827E+04, .465440E+04, .348841E+04, .261324E+04,
     +  .195717E+04, .146519E+04, .109670E+04, .820610E+03,
     +  .613989E+03, .459307E+03, .343715E+03, .256155E+03,
     +  .191779E+03, .143630E+03, .107657E+03, .807573E+02,
     +  .606525E+02, .456531E+02, .344062E+02, .259861E+02,
     +  .196815E+02, .149493E+02, .113949E+02, .871548E+01,
     +  .669513E+01, .516267E+01, .399731E+01, .310678E+01,
     +  .242361E+01, .189606E+01, .148829E+01, .116758E+01,
     +  .917425E+00, .718401E+00, .561088E+00, .435837E+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .336202E+00, .257185E+00, .194955E+00, .146383E+00,
     +  .108896E+00, .802995E-01, .587371E-01, .426417E-01,
     +  .307466E-01, .220296E-01, .156843E-01, .111218E-01,
     +  .782699E-02, .547967E-02, .381957E-02, .265224E-02,
     +  .183685E-02, .126954E-02, .877214E-03, .606340E-03,
     +  .419991E-03, .291358E-03, .203698E-03, .142568E-03,
     +  .100265E-03, .706857E-04, .499323E-04, .351984E-04,
     +  .247071E-04, .171441E-04, .116527E-04, .768010E-05,
     +  .482345E-05, .280747E-05, .145284E-05, .614877E-06,
     +  .174281E-06, .163267E-07, .000000E+00, .804558E+06,
     +  .613306E+06, .460127E+06, .345019E+06, .258599E+06,
     +  .193710E+06, .145040E+06, .108533E+06, .811783E+05,
     +  .606807E+05, .453382E+05, .338537E+05, .252667E+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .188459E+05, .140505E+05, .104686E+05, .779647E+04,
     +  .580280E+04, .431717E+04, .321001E+04, .238595E+04,
     +  .177250E+04, .131640E+04, .977232E+03, .725324E+03,
     +  .538184E+03, .399429E+03, .295162E+03, .219118E+03,
     +  .162707E+03, .120904E+03, .899048E+02, .669287E+02,
     +  .499326E+02, .372961E+02, .279171E+02, .209544E+02,
     +  .157737E+02, .119157E+02, .903261E+01, .687714E+01,
     +  .525620E+01, .403389E+01, .310772E+01, .240306E+01,
     +  .186342E+01, .144975E+01, .112716E+01, .877703E+00,
     +  .681064E+00, .527133E+00, .405833E+00, .310364E+00,
     +  .235472E+00, .177120E+00, .132043E+00, .975854E-01,
     +  .715311E-01, .520398E-01, .375943E-01, .269867E-01,
     +  .192584E-01, .136619E-01, .965677E-02, .677722E-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .473401E-02, .329413E-02, .228481E-02, .158159E-02,
     +  .109340E-02, .756278E-03, .523757E-03, .363846E-03,
     +  .253446E-03, .178058E-03, .125390E-03, .887965E-04,
     +  .630846E-04, .449077E-04, .318947E-04, .225199E-04,
     +  .156885E-04, .106708E-04, .701181E-05, .436858E-05,
     +  .250892E-05, .127178E-05, .522059E-06, .142394E-06,
     +  .135846E-07, .000000E+00, .109710E+07, .832279E+06,
     +  .620882E+06, .462905E+06, .344952E+06, .256885E+06,
     +  .191203E+06, .142219E+06, .105727E+06, .785447E+05,
     +  .583189E+05, .432709E+05, .320879E+05, .237781E+05,
     +  .176105E+05, .130332E+05, .964045E+04, .712579E+04,
     +  .526431E+04, .388644E+04, .286788E+04, .211491E+04,
     +  .155902E+04, .114860E+04, .845983E+03, .622819E+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .458591E+03, .336131E+03, .247508E+03, .182280E+03,
     +  .134321E+03, .990435E+02, .731054E+02, .540755E+02,
     +  .400420E+02, .297130E+02, .221083E+02, .164976E+02,
     +  .123541E+02, .928362E+01, .700702E+01, .530925E+01,
     +  .403949E+01, .308527E+01, .236513E+01, .181811E+01,
     +  .140220E+01, .108057E+01, .833976E+00, .641356E+00,
     +  .491996E+00, .375476E+00, .284713E+00, .214259E+00,
     +  .159929E+00, .118377E+00, .869085E-01, .633180E-01,
     +  .458068E-01, .329214E-01, .235205E-01, .167121E-01,
     +  .118083E-01, .831642E-02, .581782E-02, .405277E-02,
     +  .281389E-02, .194860E-02, .134759E-02, .931502E-03,
     +  .644739E-03, .447261E-03, .311557E-03, .217872E-03,
     +  .153784E-03, .108919E-03, .776121E-04, .554967E-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .397411E-04, .283675E-04, .200880E-04, .140028E-04,
     +  .949795E-05, .620142E-05, .382154E-05, .216014E-05,
     +  .107054E-05, .425876E-06, .111924E-06, .108525E-07,
     +  .000000E+00, .146804E+07, .110857E+07, .822526E+06,
     +  .609897E+06, .451975E+06, .334703E+06, .247712E+06,
     +  .183194E+06, .135397E+06, .999937E+05, .738010E+05,
     +  .544267E+05, .401126E+05, .295395E+05, .217391E+05,
     +  .159857E+05, .117473E+05, .862571E+04, .632962E+04,
     +  .464110E+04, .340104E+04, .249047E+04, .182274E+04,
     +  .133317E+04, .974686E+03, .712190E+03, .520411E+03,
     +  .378463E+03, .276500E+03, .202022E+03, .147674E+03,
     +  .108007E+03, .790671E+02, .580028E+02, .425914E+02,
     +  .313397E+02, .231219E+02, .171082E+02, .127029E+02 /
        DATA (UPDI(I),I=3589,3640) /
     +  .946504E+01, .708361E+01, .532203E+01, .401506E+01,
     +  .304075E+01, .231127E+01, .176156E+01, .134697E+01,
     +  .102898E+01, .787236E+00, .600088E+00, .456318E+00,
     +  .345255E+00, .259607E+00, .193799E+00, .143559E+00,
     +  .105503E+00, .769435E-01, .557129E-01, .400743E-01,
     +  .286484E-01, .203667E-01, .144050E-01, .101350E-01,
     +  .711027E-02, .495675E-02, .344263E-02, .238444E-02,
     +  .164825E-02, .113866E-02, .786925E-03, .545060E-03,
     +  .378789E-03, .264624E-03, .185793E-03, .131760E-03,
     +  .938320E-04, .672365E-04, .483362E-04, .347645E-04,
     +  .248880E-04, .176334E-04, .122674E-04, .827649E-05,
     +  .535651E-05, .325811E-05, .180945E-05, .875597E-06,
     +  .337436E-06, .855697E-07, .842240E-08, .000000E+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .193051E+07, .145138E+07, .107127E+07, .790165E+06,
     +  .582448E+06, .429001E+06, .315768E+06, .232236E+06,
     +  .170682E+06, .125339E+06, .919750E+05, .674347E+05,
     +  .494057E+05, .361652E+05, .264533E+05, .193322E+05,
     +  .141175E+05, .103002E+05, .750956E+04, .547019E+04,
     +  .398189E+04, .289608E+04, .210503E+04, .152889E+04,
     +  .110984E+04, .805087E+03, .583982E+03, .421495E+03,
     +  .305618E+03, .221592E+03, .160725E+03, .116632E+03,
     +  .847038E+02, .616419E+02, .448977E+02, .327682E+02,
     +  .239779E+02, .175962E+02, .129577E+02, .957551E+01,
     +  .710727E+01, .529584E+01, .396234E+01, .297603E+01,
     +  .224327E+01, .169542E+01, .128547E+01, .973593E+00,
     +  .738463E+00, .558035E+00, .420690E+00, .315603E+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .235354E+00, .174303E+00, .128144E+00, .935070E-01,
     +  .677420E-01, .487460E-01, .348594E-01, .247853E-01,
     +  .175309E-01, .123408E-01, .864450E-02, .604023E-02,
     +  .419563E-02, .290504E-02, .200709E-02, .138494E-02,
     +  .955823E-03, .660548E-03, .457969E-03, .318930E-03,
     +  .223516E-03, .157589E-03, .112288E-03, .803797E-04,
     +  .578802E-04, .417861E-04, .301385E-04, .215983E-04,
     +  .152794E-04, .105859E-04, .708962E-05, .453969E-05,
     +  .272128E-05, .148295E-05, .700057E-06, .261330E-06,
     +  .640388E-07, .639289E-08, .000000E+00, .249786E+07,
     +  .186996E+07, .137327E+07, .100777E+07, .739024E+06,
     +  .541493E+06, .396466E+06, .290030E+06, .212005E+06,
     +  .154831E+06, .112986E+06, .823737E+05, .600061E+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .436707E+05, .317556E+05, .230690E+05, .167444E+05,
     +  .121419E+05, .879711E+04, .636754E+04, .460529E+04,
     +  .332763E+04, .240266E+04, .173329E+04, .124960E+04,
     +  .900146E+03, .648317E+03, .464526E+03, .334368E+03,
     +  .240651E+03, .173242E+03, .124765E+03, .899150E+02,
     +  .649291E+02, .469219E+02, .339759E+02, .246645E+02,
     +  .179560E+02, .131170E+02, .961561E+01, .707976E+01,
     +  .523294E+01, .388370E+01, .289334E+01, .216315E+01,
     +  .162139E+01, .121915E+01, .915582E+00, .688586E+00,
     +  .515905E+00, .385635E+00, .286893E+00, .212205E+00,
     +  .155929E+00, .113781E+00, .824416E-01, .593298E-01,
     +  .424272E-01, .301633E-01, .213287E-01, .150085E-01,
     +  .105145E-01, .733230E-02, .510254E-02, .353149E-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .243775E-02, .168022E-02, .115753E-02, .798290E-03,
     +  .551843E-03, .383117E-03, .267464E-03, .188105E-03,
     +  .133197E-03, .953498E-04, .685771E-04, .495830E-04,
     +  .359036E-04, .259294E-04, .185683E-04, .130922E-04,
     +  .901701E-05, .598471E-05, .378600E-05, .223393E-05,
     +  .119336E-05, .549228E-06, .198623E-06, .471030E-07,
     +  .476604E-08, .000000E+00, .204568E+05, .222925E+05,
     +  .177915E+05, .141992E+05, .113320E+05, .904365E+04,
     +  .721728E+04, .575965E+04, .459633E+04, .366791E+04,
     +  .292696E+04, .233565E+04, .186377E+04, .148719E+04,
     +  .118669E+04, .946895E+03, .755551E+03, .602873E+03,
     +  .481051E+03, .383854E+03, .306306E+03, .244439E+03,
     +  .195082E+03, .155709E+03, .124301E+03, .992481E+02 /
        DATA (UPDI(I),I=3849,3900) /
     +  .792644E+02, .631233E+02, .504549E+02, .403486E+02,
     +  .322858E+02, .258525E+02, .207182E+02, .166304E+02,
     +  .133566E+02, .107411E+02, .864947E+01, .697442E+01,
     +  .563055E+01, .454946E+01, .367860E+01, .297368E+01,
     +  .240132E+01, .193493E+01, .155370E+01, .124141E+01,
     +  .986314E+00, .776327E+00, .606533E+00, .468967E+00,
     +  .360330E+00, .275942E+00, .211938E+00, .164501E+00,
     +  .129890E+00, .104648E+00, .858602E-01, .713189E-01,
     +  .595336E-01, .496042E-01, .410425E-01, .336050E-01,
     +  .271699E-01, .216865E-01, .170331E-01, .131740E-01,
     +  .100279E-01, .750729E-02, .552313E-02, .398918E-02,
     +  .282516E-02, .195886E-02, .132696E-02, .875803E-03,
     +  .564050E-03, .351062E-03, .210949E-03, .121759E-03 /
        DATA (UPDI(I),I=3901,3952) /
     +  .670836E-04, .349993E-04, .171138E-04, .774780E-05,
     +  .316991E-05, .115056E-05, .355191E-06, .878443E-07,
     +  .157319E-07, .168526E-08, .699714E-10, .275015E-12,
     +  .000000E+00, .351545E+05, .282139E+05, .224484E+05,
     +  .178581E+05, .142068E+05, .113001E+05, .898823E+04,
     +  .714805E+04, .568469E+04, .452005E+04, .359404E+04,
     +  .285717E+04, .227139E+04, .180534E+04, .143492E+04,
     +  .114027E+04, .906128E+03, .719921E+03, .571989E+03,
     +  .454371E+03, .360957E+03, .286704E+03, .227746E+03,
     +  .180894E+03, .143703E+03, .114159E+03, .907130E+02,
     +  .718587E+02, .571378E+02, .454456E+02, .361691E+02,
     +  .288012E+02, .229543E+02, .183208E+02, .146319E+02,
     +  .116990E+02, .936752E+01, .750965E+01, .602834E+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .484285E+01, .389408E+01, .313036E+01, .251447E+01,
     +  .201568E+01, .161100E+01, .128168E+01, .101482E+01,
     +  .796658E+00, .621679E+00, .480796E+00, .370208E+00,
     +  .284558E+00, .219641E+00, .171304E+00, .135734E+00,
     +  .109429E+00, .895782E-01, .740392E-01, .614134E-01,
     +  .508072E-01, .417517E-01, .339690E-01, .273156E-01,
     +  .217058E-01, .169906E-01, .131081E-01, .996413E-02,
     +  .745681E-02, .549129E-02, .397444E-02, .282504E-02,
     +  .196857E-02, .134287E-02, .893420E-03, .581495E-03,
     +  .366179E-03, .222834E-03, .130049E-03, .720433E-04,
     +  .371760E-04, .172120E-04, .653895E-05, .127748E-05,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .255349E+05, .366543E+05, .290236E+05, .229764E+05,
     +  .181901E+05, .143974E+05, .113960E+05, .901803E+04,
     +  .713653E+04, .564613E+04, .446711E+04, .353334E+04,
     +  .279482E+04, .221005E+04, .174768E+04, .138164E+04,
     +  .109230E+04, .863298E+03, .682332E+03, .539152E+03,
     +  .426047E+03, .336587E+03, .265940E+03, .210079E+03,
     +  .165980E+03, .131128E+03, .103625E+03, .816224E+02,
     +  .645397E+02, .510417E+02, .403939E+02, .319811E+02,
     +  .253434E+02, .201110E+02, .159697E+02, .126945E+02,
     +  .101064E+02, .805501E+01, .642932E+01, .513546E+01,
     +  .410641E+01, .328286E+01, .262305E+01, .209199E+01,
     +  .166414E+01, .131826E+01, .104004E+01, .814112E+00,
     +  .634236E+00, .490275E+00, .377882E+00, .291093E+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .225360E+00, .176249E+00, .139869E+00, .112689E+00,
     +  .919815E-01, .756592E-01, .623903E-01, .512875E-01,
     +  .418886E-01, .338864E-01, .271145E-01, .214569E-01,
     +  .167413E-01, .128845E-01, .978078E-02, .731716E-02,
     +  .539390E-02, .391330E-02, .279357E-02, .195925E-02,
     +  .134921E-02, .909370E-03, .602855E-03, .389417E-03,
     +  .245681E-03, .150920E-03, .902229E-04, .522866E-04,
     +  .293749E-04, .159528E-04, .831236E-05, .414749E-05,
     +  .196644E-05, .862359E-06, .341668E-06, .113044E-06,
     +  .234877E-07, .000000E+00, .000000E+00, .744539E+05,
     +  .589902E+05, .462641E+05, .362754E+05, .284435E+05,
     +  .222973E+05, .174791E+05, .136988E+05, .107359E+05,
     +  .841172E+04, .659060E+04, .516236E+04, .404356E+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .316635E+04, .247939E+04, .194091E+04, .151936E+04,
     +  .118901E+04, .930484E+03, .727959E+03, .569535E+03,
     +  .445473E+03, .348458E+03, .272512E+03, .213144E+03,
     +  .166694E+03, .130408E+03, .101667E+03, .795738E+02,
     +  .622914E+02, .487946E+02, .382376E+02, .299911E+02,
     +  .235559E+02, .185137E+02, .145661E+02, .114782E+02,
     +  .905544E+01, .715501E+01, .565806E+01, .447999E+01,
     +  .354722E+01, .280798E+01, .221964E+01, .175108E+01,
     +  .137666E+01, .107907E+01, .840174E+00, .652176E+00,
     +  .503217E+00, .387885E+00, .299286E+00, .232254E+00,
     +  .181969E+00, .144387E+00, .115975E+00, .940916E-01,
     +  .767460E-01, .626689E-01, .509875E-01, .412242E-01,
     +  .330332E-01, .262022E-01, .205754E-01, .159425E-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .121949E-01, .920754E-02, .685595E-02, .503283E-02,
     +  .363726E-02, .258652E-02, .180618E-02, .123712E-02,
     +  .827164E-03, .541931E-03, .343374E-03, .209872E-03,
     +  .122257E-03, .666639E-04, .327231E-04, .130742E-04,
     +  .262020E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .119052E+06, .935514E+05,
     +  .726890E+05, .564650E+05, .438602E+05, .340601E+05,
     +  .264484E+05, .205321E+05, .159384E+05, .123690E+05,
     +  .959837E+04, .744618E+04, .577623E+04, .447944E+04,
     +  .347359E+04, .269276E+04, .208736E+04, .161754E+04,
     +  .125342E+04, .970972E+03, .752170E+03, .582512E+03,
     +  .451135E+03, .349306E+03, .270484E+03, .209425E+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .162201E+03, .125167E+03, .969822E+02, .751537E+02,
     +  .582752E+02, .452051E+02, .350961E+02, .272868E+02,
     +  .212284E+02, .165329E+02, .128965E+02, .100721E+02,
     +  .787889E+01, .616899E+01, .483712E+01, .379362E+01,
     +  .297529E+01, .233110E+01, .182365E+01, .142268E+01,
     +  .110753E+01, .857311E+00, .662498E+00, .509606E+00,
     +  .392151E+00, .302399E+00, .234619E+00, .183677E+00,
     +  .145397E+00, .116264E+00, .937007E-01, .757973E-01,
     +  .613244E-01, .494193E-01, .395834E-01, .314389E-01,
     +  .247341E-01, .192803E-01, .148409E-01, .112877E-01,
     +  .848224E-02, .629272E-02, .460800E-02, .332682E-02,
     +  .236754E-02, .165836E-02, .114274E-02, .771995E-03,
     +  .513973E-03, .333838E-03, .211997E-03, .131078E-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .787472E-04, .456785E-04, .254823E-04, .135543E-04,
     +  .676406E-05, .312274E-05, .130225E-05, .466094E-06,
     +  .137953E-06, .324177E-07, .486153E-08, .000000E+00,
     +  .000000E+00, .184652E+06, .144037E+06, .110982E+06,
     +  .854872E+05, .658415E+05, .506943E+05, .390271E+05,
     +  .300352E+05, .231123E+05, .177791E+05, .136748E+05,
     +  .105144E+05, .808341E+04, .621228E+04, .477371E+04,
     +  .366695E+04, .281647E+04, .216246E+04, .166015E+04,
     +  .127407E+04, .977723E+03, .750065E+03, .575399E+03,
     +  .441286E+03, .338440E+03, .259522E+03, .199066E+03,
     +  .152107E+03, .116707E+03, .895553E+02, .687605E+02,
     +  .528138E+02, .405976E+02, .312526E+02, .240724E+02,
     +  .185622E+02, .143361E+02, .110861E+02, .858700E+01 /
        DATA (UPDI(I),I=4317,4368) /
     +  .665820E+01, .517079E+01, .401733E+01, .312197E+01,
     +  .242456E+01, .188096E+01, .145601E+01, .112555E+01,
     +  .865934E+00, .665812E+00, .510171E+00, .391491E+00,
     +  .301283E+00, .233321E+00, .182218E+00, .143705E+00,
     +  .114294E+00, .914711E-01, .733904E-01, .588504E-01,
     +  .469960E-01, .373065E-01, .293782E-01, .229273E-01,
     +  .177395E-01, .135614E-01, .102509E-01, .766088E-02,
     +  .565671E-02, .412638E-02, .297078E-02, .211085E-02,
     +  .147862E-02, .102098E-02, .693170E-03, .465419E-03,
     +  .306496E-03, .198782E-03, .126827E-03, .797824E-04,
     +  .494605E-04, .303605E-04, .184619E-04, .111181E-04,
     +  .663020E-05, .388784E-05, .218863E-05, .114412E-05,
     +  .515054E-06, .162447E-06, .135267E-07, .000000E+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .277631E+06, .215151E+06, .164533E+06, .125777E+06,
     +  .961327E+05, .734463E+05, .561026E+05, .428374E+05,
     +  .327022E+05, .249548E+05, .190389E+05, .145195E+05,
     +  .110706E+05, .843739E+04, .642922E+04, .489692E+04,
     +  .372910E+04, .283857E+04, .216031E+04, .164343E+04,
     +  .125005E+04, .950465E+03, .722599E+03, .549176E+03,
     +  .417351E+03, .317098E+03, .240987E+03, .182403E+03,
     +  .138643E+03, .105386E+03, .801480E+02, .609742E+02,
     +  .464208E+02, .353928E+02, .269982E+02, .206174E+02,
     +  .157694E+02, .120770E+02, .926477E+01, .711544E+01,
     +  .547399E+01, .421370E+01, .324509E+01, .249830E+01,
     +  .192212E+01, .147632E+01, .113316E+01, .866264E+00,
     +  .662477E+00, .505358E+00, .386404E+00, .296471E+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .228909E+00, .178144E+00, .139843E+00, .110564E+00,
     +  .878509E-01, .699171E-01, .555821E-01, .439981E-01,
     +  .346251E-01, .270404E-01, .209357E-01, .160780E-01,
     +  .122052E-01, .916611E-02, .680972E-02, .500165E-02,
     +  .363169E-02, .260472E-02, .184551E-02, .129074E-02,
     +  .891267E-03, .606485E-03, .409187E-03, .271813E-03,
     +  .178682E-03, .116281E-03, .751765E-04, .483285E-04,
     +  .310387E-04, .198979E-04, .126888E-04, .800169E-05,
     +  .491838E-05, .286354E-05, .151815E-05, .676962E-06,
     +  .207285E-06, .184255E-07, .000000E+00, .405682E+06,
     +  .312524E+06, .237364E+06, .180202E+06, .136769E+06,
     +  .103756E+06, .786897E+05, .596510E+05, .452057E+05,
     +  .342420E+05, .259297E+05, .196257E+05, .148499E+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .112306E+05, .849097E+04, .641641E+04, .484732E+04,
     +  .366008E+04, .276287E+04, .208456E+04, .157241E+04,
     +  .118554E+04, .893674E+03, .673378E+03, .507310E+03,
     +  .382076E+03, .287808E+03, .215876E+03, .162610E+03,
     +  .122485E+03, .923008E+02, .695740E+02, .524766E+02,
     +  .396382E+02, .299532E+02, .226592E+02, .171679E+02,
     +  .130245E+02, .989799E+01, .753106E+01, .574039E+01,
     +  .437877E+01, .334233E+01, .255111E+01, .194662E+01,
     +  .148355E+01, .113057E+01, .858692E+00, .652966E+00,
     +  .495673E+00, .377413E+00, .288485E+00, .221898E+00,
     +  .171945E+00, .134271E+00, .105491E+00, .832095E-01,
     +  .656943E-01, .517853E-01, .406442E-01, .317167E-01,
     +  .245678E-01, .188724E-01, .143857E-01, .108433E-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .808935E-02, .597276E-02, .436223E-02, .315140E-02,
     +  .225047E-02, .158895E-02, .110867E-02, .764807E-03,
     +  .520953E-03, .352586E-03, .235701E-03, .156500E-03,
     +  .103334E-03, .680963E-04, .448344E-04, .295795E-04,
     +  .195008E-04, .127612E-04, .821507E-05, .511060E-05,
     +  .298259E-05, .156620E-05, .681558E-06, .200857E-06,
     +  .184087E-07, .000000E+00, .577837E+06, .442721E+06,
     +  .334121E+06, .252037E+06, .190053E+06, .143236E+06,
     +  .107912E+06, .812556E+05, .611608E+05, .460098E+05,
     +  .345988E+05, .260030E+05, .195351E+05, .146676E+05,
     +  .110085E+05, .825742E+04, .619143E+04, .463959E+04,
     +  .347539E+04, .260181E+04, .194715E+04, .145640E+04,
     +  .108900E+04, .813870E+03, .608093E+03, .454152E+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .339212E+03, .252231E+03, .188354E+03, .140641E+03,
     +  .105048E+03, .784800E+02, .586628E+02, .439123E+02,
     +  .328812E+02, .246474E+02, .185031E+02, .139090E+02,
     +  .104734E+02, .789642E+01, .596461E+01, .450941E+01,
     +  .341206E+01, .258233E+01, .195441E+01, .147801E+01,
     +  .111828E+01, .843775E+00, .637860E+00, .481690E+00,
     +  .365068E+00, .277848E+00, .212778E+00, .164078E+00,
     +  .127402E+00, .994408E-01, .778609E-01, .609855E-01,
     +  .476767E-01, .371088E-01, .287196E-01, .220687E-01,
     +  .168214E-01, .127275E-01, .952532E-02, .705861E-02,
     +  .517903E-02, .376063E-02, .270251E-02, .192110E-02,
     +  .135130E-02, .940324E-03, .647823E-03, .441502E-03,
     +  .299570E-03, .201336E-03, .134812E-03, .900763E-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .602497E-04, .403655E-04, .271113E-04, .181736E-04,
     +  .120467E-04, .781296E-05, .486105E-05, .281595E-05,
     +  .145421E-05, .615011E-06, .174286E-06, .163267E-07,
     +  .000000E+00, .804426E+06, .613190E+06, .460023E+06,
     +  .344928E+06, .258518E+06, .193638E+06, .144977E+06,
     +  .108477E+06, .811290E+05, .606372E+05, .452998E+05,
     +  .338198E+05, .252369E+05, .188197E+05, .140273E+05,
     +  .104483E+05, .777859E+04, .578709E+04, .430339E+04,
     +  .319792E+04, .237536E+04, .176322E+04, .130829E+04,
     +  .970140E+03, .719130E+03, .532777E+03, .394712E+03,
     +  .291059E+03, .215543E+03, .159593E+03, .118191E+03,
     +  .875415E+02, .648684E+02, .481343E+02, .357246E+02,
     +  .265416E+02, .197475E+02, .147121E+02, .109793E+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .820435E+01, .614254E+01, .460351E+01, .345345E+01,
     +  .259192E+01, .194591E+01, .146032E+01, .109700E+01,
     +  .822232E+00, .617842E+00, .464038E+00, .349946E+00,
     +  .265082E+00, .202020E+00, .154963E+00, .119608E+00,
     +  .927319E-01, .720730E-01, .560102E-01, .434323E-01,
     +  .335302E-01, .257408E-01, .196246E-01, .148442E-01,
     +  .111491E-01, .828515E-02, .609859E-02, .444652E-02,
     +  .320998E-02, .229462E-02, .162367E-02, .113781E-02,
     +  .789658E-03, .543344E-03, .370505E-03, .252028E-03,
     +  .170252E-03, .114883E-03, .775628E-04, .525218E-04,
     +  .356614E-04, .242499E-04, .164192E-04, .109464E-04,
     +  .710327E-05, .439403E-05, .251456E-05, .127267E-05,
     +  .522145E-06, .142398E-06, .135846E-07, .000000E+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .109696E+07, .832154E+06, .620771E+06, .462807E+06,
     +  .344865E+06, .256808E+06, .191135E+06, .142159E+06,
     +  .105675E+06, .784982E+05, .582780E+05, .432348E+05,
     +  .320561E+05, .237501E+05, .175859E+05, .130116E+05,
     +  .962149E+04, .710915E+04, .524973E+04, .387367E+04,
     +  .285670E+04, .210514E+04, .155048E+04, .114116E+04,
     +  .839487E+03, .617157E+03, .453662E+03, .331850E+03,
     +  .243784E+03, .179043E+03, .131507E+03, .965970E+02,
     +  .709775E+02, .522227E+02, .384275E+02, .283041E+02,
     +  .208764E+02, .154182E+02, .114061E+02, .844942E+01,
     +  .627148E+01, .466007E+01, .346654E+01, .258045E+01,
     +  .192196E+01, .143143E+01, .106764E+01, .794907E+00,
     +  .593669E+00, .443385E+00, .332628E+00, .250698E+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .190071E+00, .144987E+00, .111217E+00, .856405E-01,
     +  .660714E-01, .509488E-01, .391928E-01, .300157E-01,
     +  .228606E-01, .172943E-01, .129832E-01, .968079E-02,
     +  .714381E-02, .522373E-02, .378501E-02, .271678E-02,
     +  .193203E-02, .136105E-02, .950387E-03, .658016E-03,
     +  .452349E-03, .308734E-03, .210604E-03, .143013E-03,
     +  .972214E-04, .662575E-04, .453341E-04, .311004E-04,
     +  .213269E-04, .145190E-04, .968973E-05, .626407E-05,
     +  .383868E-05, .216387E-05, .107112E-05, .425931E-06,
     +  .111926E-06, .108525E-07, .000000E+00, .146789E+07,
     +  .110844E+07, .822407E+06, .609792E+06, .451883E+06,
     +  .334621E+06, .247640E+06, .183130E+06, .135340E+06,
     +  .999441E+05, .737573E+05, .543883E+05, .400788E+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .295098E+05, .217131E+05, .159628E+05, .117272E+05,
     +  .860812E+04, .631423E+04, .462764E+04, .338927E+04,
     +  .248020E+04, .181379E+04, .132536E+04, .967887E+03,
     +  .706275E+03, .515269E+03, .374005E+03, .272631E+03,
     +  .198664E+03, .144761E+03, .105481E+03, .768750E+02,
     +  .560991E+02, .409373E+02, .299009E+02, .218684E+02,
     +  .160144E+02, .117468E+02, .862823E+01, .635023E+01,
     +  .467922E+01, .345215E+01, .254909E+01, .188379E+01,
     +  .139251E+01, .103128E+01, .762733E+00, .566140E+00,
     +  .420404E+00, .313688E+00, .235180E+00, .177342E+00,
     +  .134495E+00, .102518E+00, .784003E-01, .600420E-01,
     +  .459453E-01, .350669E-01, .266457E-01, .201365E-01,
     +  .151182E-01, .112656E-01, .834035E-02, .611248E-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .444065E-02, .319810E-02, .228277E-02, .161537E-02,
     +  .113325E-02, .788802E-03, .545082E-03, .374561E-03,
     +  .256003E-03, .175208E-03, .119625E-03, .819090E-04,
     +  .562969E-04, .388535E-04, .268613E-04, .185164E-04,
     +  .126301E-04, .840929E-05, .539921E-05, .326960E-05,
     +  .181190E-05, .875973E-06, .337471E-06, .855711E-07,
     +  .842240E-08, .000000E+00, .193035E+07, .145124E+07,
     +  .107114E+07, .790052E+06, .582349E+06, .428914E+06,
     +  .315691E+06, .232168E+06, .170622E+06, .125286E+06,
     +  .919285E+05, .673939E+05, .493698E+05, .361337E+05,
     +  .264256E+05, .193080E+05, .140963E+05, .102817E+05,
     +  .749334E+04, .545602E+04, .396952E+04, .288530E+04,
     +  .209564E+04, .152071E+04, .110274E+04, .798916E+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .578628E+03, .416862E+03, .301604E+03, .218117E+03,
     +  .157717E+03, .114029E+03, .824510E+02, .596911E+02,
     +  .432079E+02, .313034E+02, .227068E+02, .164918E+02,
     +  .119971E+02, .873937E+01, .637911E+01, .466214E+01,
     +  .341183E+01, .249945E+01, .183295E+01, .134493E+01,
     +  .989081E+00, .726685E+00, .536057E+00, .395757E+00,
     +  .293666E+00, .218973E+00, .164198E+00, .123789E+00,
     +  .937517E-01, .712033E-01, .541327E-01, .411106E-01,
     +  .311354E-01, .234764E-01, .176065E-01, .131206E-01,
     +  .970624E-02, .713589E-02, .519476E-02, .375017E-02,
     +  .268502E-02, .190639E-02, .134279E-02, .938487E-03,
     +  .651462E-03, .449553E-03, .308977E-03, .211599E-03,
     +  .145363E-03, .998035E-04, .688085E-04, .476480E-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .331138E-04, .230164E-04, .159056E-04, .108396E-04,
     +  .718111E-05, .456865E-05, .272894E-05, .148456E-05,
     +  .700298E-06, .261352E-06, .640397E-07, .639289E-08,
     +  .000000E+00, .249769E+07, .186981E+07, .137313E+07,
     +  .100765E+07, .738918E+06, .541400E+06, .396384E+06,
     +  .289958E+06, .211941E+06, .154775E+06, .112937E+06,
     +  .823304E+05, .599681E+05, .436374E+05, .317264E+05,
     +  .230434E+05, .167221E+05, .121224E+05, .878003E+04,
     +  .635265E+04, .459231E+04, .331633E+04, .239283E+04,
     +  .172475E+04, .124220E+04, .893722E+03, .642753E+03,
     +  .459721E+03, .330214E+03, .237061E+03, .170143E+03,
     +  .122089E+03, .876059E+02, .629354E+02, .452007E+02,
     +  .324892E+02, .233795E+02, .168447E+02, .121554E+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .878343E+01, .635977E+01, .461092E+01, .334774E+01,
     +  .243354E+01, .177117E+01, .129016E+01, .942257E+00,
     +  .687736E+00, .504200E+00, .370061E+00, .273058E+00,
     +  .202476E+00, .150959E+00, .113121E+00, .851178E-01,
     +  .642012E-01, .484564E-01, .365256E-01, .274536E-01,
     +  .205443E-01, .152928E-01, .113136E-01, .831019E-02,
     +  .606807E-02, .438873E-02, .314904E-02, .224202E-02,
     +  .158393E-02, .111093E-02, .773885E-03, .536038E-03,
     +  .369616E-03, .254247E-03, .174562E-03, .120416E-03,
     +  .831396E-04, .576858E-04, .402002E-04, .280844E-04,
     +  .195825E-04, .135342E-04, .919357E-05, .604744E-05,
     +  .380554E-05, .223901E-05, .119440E-05, .549383E-06,
     +  .198637E-06, .471036E-07, .476604E-08, .000000E+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .229314E+05, .194042E+05, .163558E+05, .137860E+05,
     +  .116198E+05, .979379E+04, .825460E+04, .695720E+04,
     +  .586363E+04, .494189E+04, .416501E+04, .351022E+04,
     +  .295836E+04, .249325E+04, .210127E+04, .177093E+04,
     +  .149255E+04, .125795E+04, .106027E+04, .893689E+03,
     +  .753327E+03, .635059E+03, .535413E+03, .451460E+03,
     +  .380732E+03, .321148E+03, .270956E+03, .228128E+03,
     +  .192617E+03, .162706E+03, .137514E+03, .116296E+03,
     +  .984272E+02, .834207E+02, .707504E+02, .600847E+02,
     +  .511051E+02, .435427E+02, .371706E+02, .317950E+02,
     +  .272621E+02, .234279E+02, .201806E+02, .174243E+02,
     +  .150791E+02, .130784E+02, .113725E+02, .989910E+01,
     +  .863807E+01, .754212E+01, .659620E+01, .577415E+01 /
        DATA (UPDI(I),I=5149,5200) /
     +  .505778E+01, .443185E+01, .388366E+01, .340253E+01,
     +  .297950E+01, .260700E+01, .227861E+01, .198885E+01,
     +  .173304E+01, .150712E+01, .130761E+01, .113222E+01,
     +  .976503E+00, .839293E+00, .718544E+00, .612464E+00,
     +  .519468E+00, .438152E+00, .367269E+00, .305704E+00,
     +  .252429E+00, .206512E+00, .167525E+00, .134153E+00,
     +  .106023E+00, .825212E-01, .630918E-01, .472292E-01,
     +  .344724E-01, .244147E-01, .166144E-01, .107871E-01,
     +  .657110E-02, .366877E-02, .180509E-02, .727107E-03,
     +  .203248E-03, .232358E-04, .000000E+00, .195392E+06,
     +  .156769E+06, .124709E+06, .992142E+05, .789696E+05,
     +  .628632E+05, .500682E+05, .398834E+05, .317886E+05,
     +  .253415E+05, .202144E+05, .161284E+05, .128770E+05 /
        DATA (UPDI(I),I=5201,5252) /
     +  .102838E+05, .821883E+04, .657062E+04, .525713E+04,
     +  .420779E+04, .337084E+04, .270154E+04, .216716E+04,
     +  .173938E+04, .139749E+04, .112349E+04, .904248E+03,
     +  .728345E+03, .587396E+03, .472765E+03, .382249E+03,
     +  .309406E+03, .250892E+03, .203726E+03, .165783E+03,
     +  .135226E+03, .110533E+03, .905647E+02, .744392E+02,
     +  .613635E+02, .507702E+02, .421442E+02, .351306E+02,
     +  .293886E+02, .246860E+02, .208115E+02, .176133E+02,
     +  .149571E+02, .127532E+02, .108952E+02, .934286E+01,
     +  .802281E+01, .690781E+01, .595748E+01, .514510E+01,
     +  .444765E+01, .384729E+01, .332876E+01, .287997E+01,
     +  .249059E+01, .215223E+01, .185778E+01, .160129E+01,
     +  .137776E+01, .118279E+01, .101352E+01, .865056E+00 /
        DATA (UPDI(I),I=5253,5304) /
     +  .735829E+00, .623442E+00, .525889E+00, .441364E+00,
     +  .368338E+00, .305420E+00, .251440E+00, .205302E+00,
     +  .166023E+00, .133087E+00, .105267E+00, .821246E-01,
     +  .630640E-01, .475305E-01, .350478E-01, .251659E-01,
     +  .175153E-01, .116904E-01, .743046E-02, .441794E-02,
     +  .239905E-02, .114151E-02, .441270E-03, .117768E-03,
     +  .135932E-04, .000000E+00, .462030E+06, .367215E+06,
     +  .289000E+06, .227387E+06, .178954E+06, .140802E+06,
     +  .110814E+06, .871930E+05, .686268E+05, .540024E+05,
     +  .425080E+05, .334537E+05, .263372E+05, .207311E+05,
     +  .163247E+05, .128531E+05, .101242E+05, .797399E+04,
     +  .628362E+04, .495136E+04, .390381E+04, .307797E+04,
     +  .242849E+04, .191633E+04, .151339E+04, .119554E+04 /
        DATA (UPDI(I),I=5305,5356) /
     +  .945326E+03, .745469E+03, .590561E+03, .468198E+03,
     +  .371779E+03, .295551E+03, .235436E+03, .187977E+03,
     +  .150402E+03, .120629E+03, .970801E+02, .783731E+02,
     +  .635305E+02, .516886E+02, .422562E+02, .346869E+02,
     +  .286104E+02, .236994E+02, .197225E+02, .164793E+02,
     +  .138364E+02, .116462E+02, .984692E+01, .834123E+01,
     +  .708919E+01, .603786E+01, .515210E+01, .440215E+01,
     +  .376526E+01, .322233E+01, .275833E+01, .236070E+01,
     +  .201927E+01, .172563E+01, .147275E+01, .125488E+01,
     +  .106688E+01, .905455E+00, .765391E+00, .644797E+00,
     +  .541030E+00, .451932E+00, .375556E+00, .310290E+00,
     +  .254665E+00, .207478E+00, .167606E+00, .134050E+00,
     +  .106243E+00, .830447E-01, .639891E-01, .485037E-01 /
        DATA (UPDI(I),I=5357,5408) /
     +  .360566E-01, .262021E-01, .185195E-01, .126731E-01,
     +  .830105E-02, .516808E-02, .300117E-02, .158610E-02,
     +  .730468E-03, .271393E-03, .693738E-04, .807994E-05,
     +  .000000E+00, .117455E+07, .924176E+06, .719052E+06,
     +  .559183E+06, .434868E+06, .338023E+06, .262751E+06,
     +  .204138E+06, .158603E+06, .123162E+06, .956423E+05,
     +  .742333E+05, .576180E+05, .446983E+05, .346768E+05,
     +  .268882E+05, .208500E+05, .161596E+05, .125254E+05,
     +  .970384E+04, .751876E+04, .582312E+04, .451079E+04,
     +  .349297E+04, .270561E+04, .209520E+04, .162323E+04,
     +  .125317E+04, .971685E+03, .753622E+03, .585126E+03,
     +  .454613E+03, .353774E+03, .275848E+03, .215455E+03,
     +  .168652E+03, .132443E+03, .104329E+03, .825215E+02 /
        DATA (UPDI(I),I=5409,5460) /
     +  .655225E+02, .522889E+02, .419138E+02, .337728E+02,
     +  .273434E+02, .222530E+02, .181939E+02, .149580E+02,
     +  .123339E+02, .102233E+02, .849386E+01, .708462E+01,
     +  .592483E+01, .496646E+01, .417051E+01, .350705E+01,
     +  .295183E+01, .248579E+01, .209347E+01, .176245E+01,
     +  .148266E+01, .124580E+01, .104519E+01, .874929E+00,
     +  .731185E+00, .608527E+00, .504690E+00, .416834E+00,
     +  .342676E+00, .280186E+00, .227709E+00, .183764E+00,
     +  .147157E+00, .116795E+00, .917156E-01, .713336E-01,
     +  .546696E-01, .412651E-01, .306093E-01, .222388E-01,
     +  .157723E-01, .108589E-01, .722410E-02, .458670E-02,
     +  .275920E-02, .154118E-02, .779011E-03, .340298E-03,
     +  .118788E-03, .284950E-04, .336236E-05, .000000E+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .237751E+07, .185515E+07, .142969E+07, .110112E+07,
     +  .847953E+06, .652580E+06, .502146E+06, .386138E+06,
     +  .296881E+06, .228101E+06, .175224E+06, .134510E+06,
     +  .103236E+06, .791756E+05, .607102E+05, .465170E+05,
     +  .356342E+05, .272771E+05, .208756E+05, .159645E+05,
     +  .122063E+05, .932600E+04, .712435E+04, .543881E+04,
     +  .415174E+04, .316728E+04, .241649E+04, .183612E+04,
     +  .140096E+04, .106884E+04, .815987E+03, .623172E+03,
     +  .476475E+03, .364944E+03, .279884E+03, .215069E+03,
     +  .165755E+03, .128126E+03, .994329E+02, .774605E+02,
     +  .606499E+02, .477051E+02, .377236E+02, .299811E+02,
     +  .239570E+02, .192378E+02, .155399E+02, .125926E+02,
     +  .102622E+02, .838483E+01, .688017E+01, .566228E+01 /
        DATA (UPDI(I),I=5513,5564) /
     +  .467204E+01, .386286E+01, .319896E+01, .265215E+01,
     +  .220024E+01, .182572E+01, .151453E+01, .125555E+01,
     +  .103964E+01, .859558E+00, .709025E+00, .583881E+00,
     +  .478731E+00, .391101E+00, .318117E+00, .257493E+00,
     +  .207230E+00, .165715E+00, .131533E+00, .103551E+00,
     +  .807541E-01, .622648E-01, .475216E-01, .357046E-01,
     +  .263939E-01, .191521E-01, .135930E-01, .940219E-02,
     +  .630014E-02, .406996E-02, .250109E-02, .145088E-02,
     +  .777460E-03, .374496E-03, .154418E-03, .503253E-04,
     +  .112532E-04, .134593E-05, .000000E+00, .424378E+07,
     +  .328730E+07, .251222E+07, .191854E+07, .146475E+07,
     +  .111748E+07, .852294E+06, .649541E+06, .494859E+06,
     +  .376714E+06, .286673E+06, .217973E+06, .165672E+06 /
        DATA (UPDI(I),I=5565,5616) /
     +  .125812E+06, .955023E+05, .724297E+05, .549073E+05,
     +  .415856E+05, .314819E+05, .238105E+05, .180003E+05,
     +  .135950E+05, .102635E+05, .774137E+04, .583684E+04,
     +  .439685E+04, .331151E+04, .248271E+04, .186883E+04,
     +  .140623E+04, .105846E+04, .796766E+03, .600258E+03,
     +  .452908E+03, .342051E+03, .258779E+03, .196308E+03,
     +  .149338E+03, .114038E+03, .874096E+02, .673346E+02,
     +  .521099E+02, .405434E+02, .317077E+02, .249348E+02,
     +  .197088E+02, .156741E+02, .125063E+02, .100382E+02,
     +  .807916E+01, .653171E+01, .529743E+01, .430814E+01,
     +  .351136E+01, .286686E+01, .234357E+01, .191717E+01,
     +  .156879E+01, .128338E+01, .104922E+01, .856744E+00,
     +  .698499E+00, .568087E+00, .461233E+00, .372752E+00 /
        DATA (UPDI(I),I=5617,5668) /
     +  .300100E+00, .240497E+00, .191740E+00, .151943E+00,
     +  .119592E+00, .933894E-01, .722980E-01, .554121E-01,
     +  .419591E-01, .314302E-01, .231536E-01, .167645E-01,
     +  .119010E-01, .825173E-02, .556671E-02, .363043E-02,
     +  .227731E-02, .135448E-02, .757671E-03, .389523E-03,
     +  .178852E-03, .696885E-04, .212768E-04, .447160E-05,
     +  .539685E-06, .000000E+00, .697863E+07, .537011E+07,
     +  .407266E+07, .308628E+07, .233787E+07, .176952E+07,
     +  .133875E+07, .101200E+07, .764632E+06, .577218E+06,
     +  .435517E+06, .328296E+06, .247335E+06, .186157E+06,
     +  .140029E+06, .105223E+06, .790185E+05, .592768E+05,
     +  .444381E+05, .332771E+05, .249025E+05, .186146E+05,
     +  .139052E+05, .103757E+05, .773724E+04, .576304E+04 /
        DATA (UPDI(I),I=5669,5720) /
     +  .429077E+04, .317875E+04, .236413E+04, .175724E+04,
     +  .130613E+04, .970696E+03, .721758E+03, .537387E+03,
     +  .400360E+03, .298737E+03, .223457E+03, .167595E+03,
     +  .126151E+03, .953059E+02, .723565E+02, .551869E+02,
     +  .423152E+02, .326162E+02, .252804E+02, .196967E+02,
     +  .154431E+02, .121483E+02, .961534E+01, .763179E+01,
     +  .608559E+01, .486872E+01, .390616E+01, .314117E+01,
     +  .253047E+01, .204118E+01, .164769E+01, .133045E+01,
     +  .107399E+01, .866378E+00, .698006E+00, .561442E+00,
     +  .450417E+00, .360698E+00, .287439E+00, .228139E+00,
     +  .180191E+00, .141545E+00, .110474E+00, .856071E-01,
     +  .657852E-01, .500903E-01, .377375E-01, .280674E-01,
     +  .206370E-01, .149072E-01, .105727E-01, .734293E-02 /
        DATA (UPDI(I),I=5721,5772) /
     +  .497383E-02, .327237E-02, .207697E-02, .126492E-02,
     +  .728068E-03, .392657E-03, .193659E-03, .847696E-04,
     +  .312415E-04, .896095E-05, .178015E-05, .215422E-06,
     +  .000000E+00, .108128E+08, .826976E+07, .622723E+07,
     +  .468523E+07, .352325E+07, .264713E+07, .198777E+07,
     +  .149127E+07, .111811E+07, .837512E+06, .626923E+06,
     +  .468804E+06, .350320E+06, .261497E+06, .195048E+06,
     +  .145319E+06, .108182E+06, .804398E+05, .597612E+05,
     +  .443432E+05, .328742E+05, .243405E+05, .180062E+05,
     +  .133033E+05, .982020E+04, .723910E+04, .533307E+04,
     +  .390793E+04, .287455E+04, .211274E+04, .155239E+04,
     +  .114028E+04, .837732E+03, .616192E+03, .453385E+03,
     +  .334054E+03, .246680E+03, .182621E+03, .135662E+03 /
        DATA (UPDI(I),I=5773,5824) /
     +  .101140E+03, .757652E+02, .570171E+02, .431338E+02,
     +  .328037E+02, .250867E+02, .192862E+02, .149221E+02,
     +  .115837E+02, .904902E+01, .708885E+01, .557970E+01,
     +  .440676E+01, .349037E+01, .277113E+01, .220403E+01,
     +  .175534E+01, .139898E+01, .111528E+01, .888814E+00,
     +  .707816E+00, .562902E+00, .446881E+00, .353783E+00,
     +  .279545E+00, .219742E+00, .171996E+00, .133931E+00,
     +  .103688E+00, .797300E-01, .608430E-01, .460214E-01,
     +  .344730E-01, .255345E-01, .186570E-01, .134673E-01,
     +  .954040E-02, .662868E-02, .450439E-02, .298087E-02,
     +  .191269E-02, .118147E-02, .698569E-03, .389093E-03,
     +  .202305E-03, .957229E-04, .399548E-04, .139419E-04,
     +  .376562E-05, .709310E-06, .852335E-07, .000000E+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .159957E+08, .121636E+08, .909805E+07, .679893E+07,
     +  .507766E+07, .378860E+07, .282489E+07, .210424E+07,
     +  .156629E+07, .116465E+07, .865324E+06, .642214E+06,
     +  .476229E+06, .352729E+06, .261021E+06, .192916E+06,
     +  .142445E+06, .105040E+06, .773790E+05, .569241E+05,
     +  .418321E+05, .306978E+05, .225029E+05, .164720E+05,
     +  .120443E+05, .879299E+04, .641414E+04, .465232E+04,
     +  .338701E+04, .246340E+04, .179071E+04, .130102E+04,
     +  .945188E+03, .687387E+03, .499926E+03, .364028E+03,
     +  .265607E+03, .194261E+03, .142544E+03, .104960E+03,
     +  .776495E+02, .577059E+02, .431073E+02, .323726E+02,
     +  .244465E+02, .185588E+02, .141807E+02, .108708E+02,
     +  .838727E+01, .648924E+01, .504504E+01, .393579E+01 /
        DATA (UPDI(I),I=5877,5928) /
     +  .307931E+01, .241504E+01, .189745E+01, .149278E+01,
     +  .117521E+01, .925434E+00, .728449E+00, .572930E+00,
     +  .449945E+00, .352704E+00, .275654E+00, .214998E+00,
     +  .166771E+00, .128777E+00, .988980E-01, .754876E-01,
     +  .572062E-01, .430049E-01, .320288E-01, .236098E-01,
     +  .171990E-01, .123491E-01, .875379E-02, .608332E-02,
     +  .414182E-02, .275450E-02, .178135E-02, .111504E-02,
     +  .670487E-03, .384981E-03, .207559E-03, .104075E-03,
     +  .472653E-04, .188268E-04, .622908E-05, .158768E-05,
     +  .283758E-06, .333424E-07, .000000E+00, .227855E+08,
     +  .172329E+08, .128077E+08, .950960E+07, .705572E+07,
     +  .522982E+07, .387342E+07, .286577E+07, .211849E+07,
     +  .156431E+07, .115406E+07, .850388E+06, .626016E+06 /
        DATA (UPDI(I),I=5929,5980) /
     +  .460260E+06, .338042E+06, .247945E+06, .181660E+06,
     +  .132907E+06, .971244E+05, .708696E+05, .516487E+05,
     +  .375824E+05, .273128E+05, .198179E+05, .143612E+05,
     +  .103887E+05, .750766E+04, .539310E+04, .388827E+04,
     +  .280007E+04, .201488E+04, .144886E+04, .104152E+04,
     +  .749372E+03, .539061E+03, .388179E+03, .280037E+03,
     +  .202479E+03, .146857E+03, .106875E+03, .781360E+02,
     +  .573812E+02, .423552E+02, .314295E+02, .234517E+02,
     +  .175916E+02, .132826E+02, .100613E+02, .767131E+01,
     +  .586525E+01, .450641E+01, .347446E+01, .268661E+01,
     +  .208247E+01, .161705E+01, .125732E+01, .978232E+00,
     +  .761251E+00, .592118E+00, .460150E+00, .357025E+00,
     +  .276461E+00, .213398E+00, .164364E+00, .125866E+00 /
        DATA (UPDI(I),I=5981,6032) /
     +  .959254E-01, .726879E-01, .547250E-01, .408908E-01,
     +  .302961E-01, .222273E-01, .161314E-01, .115626E-01,
     +  .816247E-02, .568492E-02, .387755E-02, .258843E-02,
     +  .168569E-02, .106598E-02, .651340E-03, .381536E-03,
     +  .212901E-03, .111205E-03, .538311E-04, .234959E-04,
     +  .894672E-05, .281354E-05, .678380E-06, .114841E-06,
     +  .128778E-07, .000000E+00, .314374E+08, .236539E+08,
     +  .174726E+08, .128935E+08, .950667E+07, .700208E+07,
     +  .515282E+07, .378770E+07, .278161E+07, .204032E+07,
     +  .149507E+07, .109414E+07, .799858E+06, .583936E+06,
     +  .425806E+06, .310052E+06, .225485E+06, .163734E+06,
     +  .118737E+06, .859682E+05, .621567E+05, .448651E+05,
     +  .323379E+05, .232681E+05, .167177E+05, .119879E+05 /
        DATA (UPDI(I),I=6033,6084) /
     +  .858659E+04, .611159E+04, .436559E+04, .311424E+04,
     +  .221941E+04, .158031E+04, .112464E+04, .800963E+03,
     +  .570187E+03, .406264E+03, .289939E+03, .207362E+03,
     +  .148742E+03, .107044E+03, .773826E+02, .561875E+02,
     +  .410039E+02, .300815E+02, .221907E+02, .164564E+02,
     +  .122849E+02, .919980E+01, .693547E+01, .524275E+01,
     +  .398286E+01, .303640E+01, .232160E+01, .177941E+01,
     +  .136626E+01, .105041E+01, .808066E+00, .621729E+00,
     +  .478103E+00, .367295E+00, .281689E+00, .215580E+00,
     +  .164434E+00, .125135E+00, .946518E-01, .712356E-01,
     +  .532906E-01, .395969E-01, .291900E-01, .213280E-01,
     +  .154244E-01, .110287E-01, .778367E-02, .540640E-02,
     +  .370249E-02, .248075E-02, .162512E-02, .103739E-02 /
        DATA (UPDI(I),I=6085,6136) /
     +  .642155E-03, .383471E-03, .219112E-03, .119003E-03,
     +  .603279E-04, .282516E-04, .118821E-04, .433918E-05,
     +  .130217E-05, .298021E-06, .476117E-07, .490711E-08,
     +  .000000E+00, .421908E+08, .315883E+08, .231968E+08,
     +  .170162E+08, .124711E+08, .912986E+07, .667731E+07,
     +  .487779E+07, .355953E+07, .259426E+07, .188864E+07,
     +  .137310E+07, .997085E+06, .723003E+06, .523587E+06,
     +  .378595E+06, .273379E+06, .197083E+06, .141874E+06,
     +  .101955E+06, .731560E+05, .523971E+05, .374696E+05,
     +  .267447E+05, .190583E+05, .135522E+05, .962453E+04,
     +  .679015E+04, .480739E+04, .339850E+04, .239969E+04,
     +  .169266E+04, .119305E+04, .841422E+03, .593033E+03,
     +  .418276E+03, .295446E+03, .209104E+03, .148411E+03 /
        DATA (UPDI(I),I=6137,6188) /
     +  .105670E+03, .755696E+02, .542790E+02, .391814E+02,
     +  .284322E+02, .207458E+02, .152174E+02, .112370E+02,
     +  .832346E+01, .620719E+01, .464148E+01, .348819E+01,
     +  .263077E+01, .198993E+01, .150890E+01, .114617E+01,
     +  .871767E+00, .663441E+00, .504957E+00, .384102E+00,
     +  .291864E+00, .221379E+00, .167543E+00, .126356E+00,
     +  .950644E-01, .710714E-01, .528560E-01, .390637E-01,
     +  .286672E-01, .208651E-01, .150466E-01, .107354E-01,
     +  .756921E-02, .526507E-02, .360190E-02, .242817E-02,
     +  .160008E-02, .102999E-02, .645401E-03, .391699E-03,
     +  .229012E-03, .127906E-03, .677729E-04, .334384E-04,
     +  .151997E-04, .618523E-05, .217713E-05, .627131E-06,
     +  .136927E-06, .205598E-07, .184392E-08, .000000E+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .552553E+08, .411739E+08, .300650E+08, .219285E+08,
     +  .159783E+08, .116290E+08, .845460E+07, .613907E+07,
     +  .445266E+07, .322522E+07, .233329E+07, .168563E+07,
     +  .121616E+07, .876111E+06, .630261E+06, .452668E+06,
     +  .324631E+06, .232409E+06, .166122E+06, .118524E+06,
     +  .844234E+05, .600182E+05, .425943E+05, .301681E+05,
     +  .213286E+05, .150446E+05, .105971E+05, .741307E+04,
     +  .520376E+04, .364683E+04, .255223E+04, .178404E+04,
     +  .124588E+04, .870467E+03, .607644E+03, .424426E+03,
     +  .296834E+03, .207989E+03, .146127E+03, .102981E+03,
     +  .728887E+02, .518116E+02, .370113E+02, .265777E+02,
     +  .191904E+02, .139297E+02, .101796E+02, .746174E+01,
     +  .550724E+01, .407555E+01, .303146E+01, .226294E+01 /
        DATA (UPDI(I),I=6241,6292) /
     +  .169425E+01, .127162E+01, .956110E+00, .719816E+00,
     +  .542226E+00, .408487E+00, .307538E+00, .231280E+00,
     +  .173607E+00, .130015E+00, .970153E-01, .722112E-01,
     +  .533985E-01, .392731E-01, .286981E-01, .208179E-01,
     +  .149737E-01, .106676E-01, .751656E-02, .523168E-02,
     +  .359085E-02, .242260E-02, .160986E-02, .104492E-02,
     +  .662048E-03, .407969E-03, .243261E-03, .139575E-03,
     +  .764028E-04, .396178E-04, .190944E-04, .846164E-05,
     +  .334922E-05, .114351E-05, .318496E-06, .667897E-07,
     +  .940884E-08, .682771E-09, .000000E+00, .707986E+08,
     +  .525158E+08, .381371E+08, .276625E+08, .200435E+08,
     +  .145051E+08, .104851E+08, .756930E+07, .545768E+07,
     +  .392965E+07, .282573E+07, .202889E+07, .145471E+07 /
        DATA (UPDI(I),I=6293,6344) /
     +  .104136E+07, .744343E+06, .531134E+06, .378387E+06,
     +  .269079E+06, .191021E+06, .135345E+06, .957242E+05,
     +  .675639E+05, .475987E+05, .334615E+05, .234773E+05,
     +  .164317E+05, .114829E+05, .796721E+04, .554686E+04,
     +  .385481E+04, .267476E+04, .185346E+04, .128286E+04,
     +  .888244E+03, .614352E+03, .425105E+03, .294489E+03,
     +  .204364E+03, .142185E+03, .992195E+02, .695326E+02,
     +  .489350E+02, .346078E+02, .246036E+02, .175878E+02,
     +  .126391E+02, .914497E+01, .663674E+01, .485022E+01,
     +  .355402E+01, .261776E+01, .193514E+01, .143482E+01,
     +  .106653E+01, .794204E+00, .592186E+00, .441808E+00,
     +  .329643E+00, .245794E+00, .183063E+00, .136083E+00,
     +  .100919E+00, .745630E-01, .549498E-01, .402249E-01 /
        DATA (UPDI(I),I=6345,6396) /
     +  .292820E-01, .211754E-01, .151986E-01, .108142E-01,
     +  .761942E-02, .530815E-02, .365168E-02, .247644E-02,
     +  .165005E-02, .108252E-02, .693278E-03, .433160E-03,
     +  .263048E-03, .154460E-03, .872006E-04, .469238E-04,
     +  .238937E-04, .112945E-04, .490252E-05, .189798E-05,
     +  .632673E-06, .171641E-06, .348285E-07, .461738E-08,
     +  .248718E-09, .000000E+00, .204568E+05, .225707E+05,
     +  .180411E+05, .144230E+05, .115327E+05, .922366E+04,
     +  .737875E+04, .590451E+04, .472630E+04, .378453E+04,
     +  .303164E+04, .242962E+04, .194814E+04, .156298E+04,
     +  .125478E+04, .100810E+04, .810589E+03, .652394E+03,
     +  .525637E+03, .424025E+03, .342532E+03, .277139E+03,
     +  .224634E+03, .182451E+03, .148538E+03, .121252E+03 /
        DATA (UPDI(I),I=6397,6448) /
     +  .992816E+02, .813500E+02, .671156E+02, .556202E+02,
     +  .463269E+02, .388048E+02, .327084E+02, .277736E+02,
     +  .237506E+02, .204743E+02, .177989E+02, .156067E+02,
     +  .138028E+02, .123093E+02, .110660E+02, .100205E+02,
     +  .913275E+01, .837035E+01, .770754E+01, .712412E+01,
     +  .660618E+01, .613669E+01, .571228E+01, .532088E+01,
     +  .496120E+01, .462755E+01, .431631E+01, .402413E+01,
     +  .374787E+01, .348480E+01, .323277E+01, .299036E+01,
     +  .275685E+01, .253209E+01, .231626E+01, .210972E+01,
     +  .191286E+01, .172689E+01, .155014E+01, .138400E+01,
     +  .122856E+01, .108387E+01, .949862E+00, .826430E+00,
     +  .713397E+00, .610529E+00, .517490E+00, .433882E+00,
     +  .360049E+00, .294481E+00, .237274E+00, .187924E+00 /
        DATA (UPDI(I),I=6449,6500) /
     +  .145906E+00, .110671E+00, .816498E-01, .582883E-01,
     +  .398531E-01, .258955E-01, .157105E-01, .868002E-02,
     +  .418842E-02, .163191E-02, .430455E-03, .437475E-04,
     +  .000000E+00, .354882E+05, .285135E+05, .227171E+05,
     +  .180991E+05, .144230E+05, .114941E+05, .916228E+04,
     +  .730422E+04, .582485E+04, .464585E+04, .370698E+04,
     +  .295858E+04, .236247E+04, .188717E+04, .150846E+04,
     +  .120639E+04, .965608E+03, .773450E+03, .620197E+03,
     +  .497815E+03, .400143E+03, .322081E+03, .259722E+03,
     +  .209831E+03, .169928E+03, .137966E+03, .112365E+03,
     +  .915647E+02, .751402E+02, .619324E+02, .513113E+02,
     +  .427490E+02, .358445E+02, .302753E+02, .257561E+02,
     +  .220862E+02, .191011E+02, .166603E+02, .146580E+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .130025E+02, .116279E+02, .104731E+02, .949507E+01,
     +  .865632E+01, .792944E+01, .729134E+01, .672725E+01,
     +  .621798E+01, .576002E+01, .533962E+01, .495538E+01,
     +  .460060E+01, .427135E+01, .396371E+01, .367444E+01,
     +  .340055E+01, .313989E+01, .289094E+01, .265290E+01,
     +  .242547E+01, .220868E+01, .200271E+01, .180771E+01,
     +  .162474E+01, .145193E+01, .129051E+01, .114041E+01,
     +  .100152E+01, .873654E+00, .756570E+00, .649971E+00,
     +  .553533E+00, .466840E+00, .389390E+00, .321416E+00,
     +  .261428E+00, .209421E+00, .164860E+00, .127178E+00,
     +  .958129E-01, .701697E-01, .497011E-01, .336876E-01,
     +  .216824E-01, .130138E-01, .710215E-02, .337701E-02,
     +  .129230E-02, .334251E-03, .341758E-04, .000000E+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .255349E+05, .369751E+05, .293115E+05, .232346E+05,
     +  .184217E+05, .146052E+05, .115825E+05, .918541E+04,
     +  .728677E+04, .578100E+04, .458821E+04, .364210E+04,
     +  .289253E+04, .229785E+04, .182660E+04, .145261E+04,
     +  .115615E+04, .920773E+03, .734102E+03, .585811E+03,
     +  .468137E+03, .374588E+03, .300287E+03, .241160E+03,
     +  .194144E+03, .156690E+03, .126864E+03, .102762E+03,
     +  .838390E+02, .687000E+02, .565944E+02, .468827E+02,
     +  .390927E+02, .328370E+02, .277851E+02, .236982E+02,
     +  .203877E+02, .176891E+02, .154828E+02, .136632E+02,
     +  .121566E+02, .108936E+02, .982683E+01, .891408E+01,
     +  .812565E+01, .743568E+01, .682818E+01, .628194E+01,
     +  .579303E+01, .534622E+01, .493979E+01, .456616E+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .422101E+01, .389996E+01, .359958E+01, .331668E+01,
     +  .304906E+01, .279505E+01, .255380E+01, .232481E+01,
     +  .210798E+01, .190330E+01, .171073E+01, .153111E+01,
     +  .136247E+01, .120585E+01, .106102E+01, .927769E+00,
     +  .805759E+00, .694657E+00, .594054E+00, .503549E+00,
     +  .422653E+00, .350782E+00, .288072E+00, .233057E+00,
     +  .185652E+00, .145293E+00, .111388E+00, .833652E-01,
     +  .606187E-01, .426085E-01, .286359E-01, .182584E-01,
     +  .108419E-01, .584431E-02, .273811E-02, .102892E-02,
     +  .260865E-03, .268370E-04, .000000E+00, .748539E+05,
     +  .593495E+05, .465864E+05, .365647E+05, .287031E+05,
     +  .225302E+05, .176882E+05, .138864E+05, .109044E+05,
     +  .856298E+04, .672646E+04, .528439E+04, .415321E+04 /
        DATA (UPDI(I),I=6657,6708) /
     +  .326489E+04, .256799E+04, .202059E+04, .159106E+04,
     +  .125355E+04, .988626E+03, .780360E+03, .616803E+03,
     +  .488141E+03, .387016E+03, .307388E+03, .244733E+03,
     +  .195345E+03, .156433E+03, .125313E+03, .101131E+03,
     +  .819809E+02, .668208E+02, .547767E+02, .452066E+02,
     +  .375911E+02, .314942E+02, .266017E+02, .226690E+02,
     +  .194854E+02, .168997E+02, .147796E+02, .130343E+02,
     +  .115788E+02, .103562E+02, .931571E+01, .842224E+01,
     +  .764524E+01, .696577E+01, .635919E+01, .582041E+01,
     +  .533171E+01, .489058E+01, .448802E+01, .411892E+01,
     +  .377818E+01, .346196E+01, .316675E+01, .289014E+01,
     +  .263026E+01, .238601E+01, .215663E+01, .194167E+01,
     +  .174086E+01, .155377E+01, .138097E+01, .122025E+01 /
        DATA (UPDI(I),I=6709,6760) /
     +  .107237E+01, .936883E+00, .813350E+00, .701257E+00,
     +  .600105E+00, .509329E+00, .428410E+00, .356757E+00,
     +  .293679E+00, .239164E+00, .191803E+00, .151399E+00,
     +  .117359E+00, .890701E-01, .659548E-01, .474118E-01,
     +  .329194E-01, .218302E-01, .137176E-01, .801302E-02,
     +  .423957E-02, .194322E-02, .711550E-03, .175701E-03,
     +  .182326E-04, .000000E+00, .119497E+06, .939513E+05,
     +  .730478E+05, .567870E+05, .441491E+05, .343194E+05,
     +  .266812E+05, .207411E+05, .161261E+05, .125375E+05,
     +  .974970E+04, .758212E+04, .589838E+04, .458922E+04,
     +  .357230E+04, .278154E+04, .216723E+04, .168944E+04,
     +  .131818E+04, .102932E+04, .804793E+03, .629997E+03,
     +  .494025E+03, .388079E+03, .305576E+03, .241227E+03 /
        DATA (UPDI(I),I=6761,6812) /
     +  .191057E+03, .151350E+03, .120814E+03, .968801E+02,
     +  .781226E+02, .633684E+02, .517569E+02, .426037E+02,
     +  .353409E+02, .295630E+02, .249558E+02, .212546E+02,
     +  .182696E+02, .158385E+02, .138497E+02, .122011E+02,
     +  .108242E+02, .965944E+01, .866524E+01, .780615E+01,
     +  .705979E+01, .639807E+01, .581440E+01, .528873E+01,
     +  .481751E+01, .439047E+01, .400161E+01, .364521E+01,
     +  .331693E+01, .301298E+01, .273065E+01, .246785E+01,
     +  .222320E+01, .199564E+01, .178443E+01, .158898E+01,
     +  .140853E+01, .124336E+01, .109110E+01, .952238E+00,
     +  .826107E+00, .712100E+00, .609540E+00, .517790E+00,
     +  .436165E+00, .364046E+00, .300764E+00, .245554E+00,
     +  .198284E+00, .157611E+00, .123257E+00, .946124E-01 /
        DATA (UPDI(I),I=6813,6864) /
     +  .710641E-01, .520426E-01, .369656E-01, .253370E-01,
     +  .165613E-01, .102410E-01, .587392E-02, .304280E-02,
     +  .135975E-02, .482717E-03, .115303E-03, .120964E-04,
     +  .000000E+00, .185145E+06, .144480E+06, .111380E+06,
     +  .858440E+05, .661617E+05, .509816E+05, .392851E+05,
     +  .302668E+05, .233203E+05, .179658E+05, .138425E+05,
     +  .106651E+05, .821877E+04, .633393E+04, .488308E+04,
     +  .376529E+04, .290495E+04, .224208E+04, .173184E+04,
     +  .133865E+04, .103593E+04, .802566E+03, .622790E+03,
     +  .484095E+03, .377151E+03, .294569E+03, .230826E+03,
     +  .180881E+03, .142853E+03, .113344E+03, .904421E+02,
     +  .726037E+02, .586966E+02, .478363E+02, .392952E+02,
     +  .325595E+02, .272321E+02, .229859E+02, .195860E+02 /
        DATA (UPDI(I),I=6865,6916) /
     +  .168365E+02, .146016E+02, .127608E+02, .112325E+02,
     +  .994761E+01, .885740E+01, .792127E+01, .711308E+01,
     +  .640125E+01, .577748E+01, .521943E+01, .472244E+01,
     +  .427502E+01, .387027E+01, .350185E+01, .316496E+01,
     +  .285545E+01, .257033E+01, .230724E+01, .206448E+01,
     +  .184071E+01, .163487E+01, .144607E+01, .127326E+01,
     +  .111645E+01, .973095E+00, .843459E+00, .726688E+00,
     +  .622022E+00, .528649E+00, .445819E+00, .372751E+00,
     +  .308750E+00, .253087E+00, .204949E+00, .164112E+00,
     +  .129304E+00, .100191E+00, .761633E-01, .566206E-01,
     +  .410123E-01, .287870E-01, .194798E-01, .125532E-01,
     +  .764113E-02, .430478E-02, .218411E-02, .952072E-03,
     +  .327992E-03, .759132E-04, .804853E-05, .000000E+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .278176E+06, .215640E+06, .164972E+06, .126171E+06,
     +  .964864E+05, .737636E+05, .563875E+05, .430932E+05,
     +  .329318E+05, .251609E+05, .192241E+05, .146858E+05,
     +  .112200E+05, .857163E+04, .654988E+04, .500540E+04,
     +  .382667E+04, .292633E+04, .223930E+04, .171455E+04,
     +  .131412E+04, .100822E+04, .774689E+03, .596189E+03,
     +  .459820E+03, .355501E+03, .275739E+03, .213839E+03,
     +  .167153E+03, .131272E+03, .103685E+03, .823998E+02,
     +  .659566E+02, .532332E+02, .433136E+02, .355582E+02,
     +  .294734E+02, .246617E+02, .208370E+02, .177657E+02,
     +  .152854E+02, .132557E+02, .115805E+02, .101808E+02,
     +  .900008E+01, .799247E+01, .712781E+01, .637103E+01,
     +  .571196E+01, .512609E+01, .460754E+01, .414369E+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .372671E+01, .334971E+01, .300736E+01, .269522E+01,
     +  .240993E+01, .214885E+01, .190999E+01, .169169E+01,
     +  .149258E+01, .131149E+01, .114711E+01, .999170E+00,
     +  .865032E+00, .744715E+00, .637218E+00, .541647E+00,
     +  .457083E+00, .382682E+00, .317597E+00, .261070E+00,
     +  .212335E+00, .170555E+00, .135432E+00, .105773E+00,
     +  .812057E-01, .611354E-01, .449839E-01, .322279E-01,
     +  .223546E-01, .149346E-01, .948877E-02, .568568E-02,
     +  .314643E-02, .156378E-02, .665134E-03, .222541E-03,
     +  .500035E-04, .535696E-05, .000000E+00, .406282E+06,
     +  .313063E+06, .237847E+06, .180636E+06, .137158E+06,
     +  .104105E+06, .790034E+05, .599326E+05, .454585E+05,
     +  .344690E+05, .261335E+05, .198087E+05, .150142E+05 /
        DATA (UPDI(I),I=7021,7072) /
     +  .113783E+05, .862365E+04, .653565E+04, .495452E+04,
     +  .375647E+04, .284958E+04, .216258E+04, .164266E+04,
     +  .124881E+04, .950684E+03, .724779E+03, .553688E+03,
     +  .423959E+03, .325652E+03, .250048E+03, .193542E+03,
     +  .150508E+03, .117717E+03, .926470E+02, .734496E+02,
     +  .587264E+02, .473444E+02, .385204E+02, .316516E+02,
     +  .262622E+02, .220087E+02, .186171E+02, .158956E+02,
     +  .136826E+02, .118670E+02, .103589E+02, .909414E+01,
     +  .802116E+01, .710577E+01, .630939E+01, .561994E+01,
     +  .501079E+01, .447485E+01, .399839E+01, .357273E+01,
     +  .319039E+01, .284556E+01, .253345E+01, .225036E+01,
     +  .199337E+01, .176013E+01, .154872E+01, .135748E+01,
     +  .118496E+01, .102960E+01, .890899E+00, .766137E+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .655119E+00, .556720E+00, .469935E+00, .393762E+00,
     +  .327287E+00, .269614E+00, .219944E+00, .177489E+00,
     +  .141408E+00, .111348E+00, .861993E-01, .655699E-01,
     +  .488859E-01, .356015E-01, .252267E-01, .172915E-01,
     +  .114045E-01, .714365E-02, .421350E-02, .229041E-02,
     +  .111508E-02, .462869E-03, .150501E-03, .328841E-04,
     +  .355889E-05, .000000E+00, .578497E+06, .443314E+06,
     +  .334653E+06, .252515E+06, .190481E+06, .143620E+06,
     +  .108257E+06, .815650E+05, .614385E+05, .462590E+05,
     +  .348225E+05, .262039E+05, .197155E+05, .148295E+05,
     +  .111540E+05, .838811E+04, .630886E+04, .474513E+04,
     +  .357027E+04, .268712E+04, .202389E+04, .152546E+04,
     +  .115117E+04, .869856E+03, .658544E+03, .499647E+03 /
        DATA (UPDI(I),I=7125,7176) /
     +  .380252E+03, .289219E+03, .221766E+03, .170841E+03,
     +  .132369E+03, .103211E+03, .810722E+02, .642377E+02,
     +  .513297E+02, .414041E+02, .337368E+02, .277662E+02,
     +  .230869E+02, .193813E+02, .164263E+02, .140384E+02,
     +  .120905E+02, .104819E+02, .914040E+01, .800877E+01,
     +  .704874E+01, .621832E+01, .550349E+01, .487564E+01,
     +  .432644E+01, .384112E+01, .341017E+01, .302557E+01,
     +  .268103E+01, .237140E+01, .209265E+01, .184155E+01,
     +  .161545E+01, .141214E+01, .122967E+01, .106638E+01,
     +  .920468E+00, .791212E+00, .675859E+00, .574014E+00,
     +  .484455E+00, .406087E+00, .337850E+00, .278780E+00,
     +  .227949E+00, .184537E+00, .147748E+00, .116752E+00,
     +  .911599E-01, .699478E-01, .527155E-01, .389192E-01 /
        DATA (UPDI(I),I=7177,7228) /
     +  .280505E-01, .196570E-01, .133136E-01, .866797E-02,
     +  .535240E-02, .310728E-02, .165901E-02, .791152E-03,
     +  .320530E-03, .101333E-03, .215607E-04, .235676E-05,
     +  .000000E+00, .805151E+06, .613840E+06, .460607E+06,
     +  .345452E+06, .258988E+06, .194060E+06, .145355E+06,
     +  .108816E+06, .814335E+05, .609104E+05, .455450E+05,
     +  .340398E+05, .254344E+05, .189969E+05, .141865E+05,
     +  .105912E+05, .790691E+04, .590234E+04, .440692E+04,
     +  .329094E+04, .245895E+04, .183837E+04, .137586E+04,
     +  .103092E+04, .773819E+03, .582018E+03, .439052E+03,
     +  .330943E+03, .251492E+03, .192008E+03, .147437E+03,
     +  .113938E+03, .887099E+02, .696831E+02, .552087E+02,
     +  .441660E+02, .356988E+02, .291534E+02, .240581E+02 /
        DATA (UPDI(I),I=7229,7280) /
     +  .200497E+02, .168727E+02, .143206E+02, .122503E+02,
     +  .105503E+02, .914004E+01, .795695E+01, .695868E+01,
     +  .609996E+01, .536484E+01, .472284E+01, .416444E+01,
     +  .367390E+01, .324093E+01, .285697E+01, .251528E+01,
     +  .221037E+01, .193787E+01, .169424E+01, .147655E+01,
     +  .128230E+01, .110933E+01, .955723E+00, .819522E+00,
     +  .699790E+00, .593758E+00, .500865E+00, .419811E+00,
     +  .349441E+00, .288651E+00, .236447E+00, .191892E+00,
     +  .154156E+00, .122449E+00, .959652E-01, .742948E-01,
     +  .564999E-01, .421837E-01, .308378E-01, .219945E-01,
     +  .152417E-01, .101994E-01, .655431E-02, .398930E-02,
     +  .227921E-02, .119510E-02, .558203E-03, .220742E-03,
     +  .678831E-04, .140823E-04, .155445E-05, .000000E+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .109775E+07, .832867E+06, .621411E+06, .463381E+06,
     +  .345380E+06, .257270E+06, .191549E+06, .142530E+06,
     +  .106008E+06, .787971E+05, .585461E+05, .434753E+05,
     +  .322719E+05, .239437E+05, .177596E+05, .131675E+05,
     +  .976138E+04, .723469E+04, .536241E+04, .397482E+04,
     +  .294751E+04, .218668E+04, .162371E+04, .120693E+04,
     +  .898583E+03, .670276E+03, .501404E+03, .374704E+03,
     +  .282322E+03, .213705E+03, .162694E+03, .124661E+03,
     +  .962417E+02, .749763E+02, .589211E+02, .467644E+02,
     +  .375095E+02, .304050E+02, .249105E+02, .206154E+02,
     +  .172309E+02, .145276E+02, .123464E+02, .105649E+02,
     +  .909471E+01, .786776E+01, .683788E+01, .595669E+01,
     +  .520637E+01, .455472E+01, .399109E+01, .349882E+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .306691E+01, .268630E+01, .234980E+01, .205161E+01,
     +  .178702E+01, .155222E+01, .134398E+01, .115958E+01,
     +  .996611E+00, .852992E+00, .726604E+00, .616339E+00,
     +  .519433E+00, .435185E+00, .362240E+00, .299402E+00,
     +  .245544E+00, .199663E+00, .160822E+00, .128198E+00,
     +  .101020E+00, .785155E-01, .602665E-01, .454205E-01,
     +  .335929E-01, .243143E-01, .171595E-01, .117577E-01,
     +  .777281E-02, .492957E-02, .295708E-02, .166244E-02,
     +  .855972E-03, .391547E-03, .151142E-03, .452310E-04,
     +  .915868E-05, .102075E-05, .000000E+00, .146876E+07,
     +  .110922E+07, .823108E+06, .610420E+06, .452446E+06,
     +  .335126E+06, .248092E+06, .183536E+06, .135704E+06,
     +  .100271E+06, .740501E+05, .546508E+05, .403142E+05 /
        DATA (UPDI(I),I=7385,7436) /
     +  .297209E+05, .219023E+05, .161325E+05, .118794E+05,
     +  .874456E+04, .643658E+04, .473735E+04, .348767E+04,
     +  .256844E+04, .189292E+04, .139634E+04, .103155E+04,
     +  .763400E+03, .566510E+03, .419899E+03, .313804E+03,
     +  .235600E+03, .177900E+03, .135208E+03, .103546E+03,
     +  .800329E+02, .624091E+02, .491609E+02, .391436E+02,
     +  .315054E+02, .256347E+02, .210731E+02, .174986E+02,
     +  .146592E+02, .123797E+02, .105276E+02, .900660E+01,
     +  .774366E+01, .668890E+01, .579107E+01, .503058E+01,
     +  .437369E+01, .380863E+01, .331797E+01, .288999E+01,
     +  .251522E+01, .218604E+01, .189632E+01, .164107E+01,
     +  .141620E+01, .121824E+01, .104425E+01, .891627E+00,
     +  .758131E+00, .641526E+00, .540556E+00, .452489E+00 /
        DATA (UPDI(I),I=7437,7488) /
     +  .376505E+00, .311220E+00, .255414E+00, .207960E+00,
     +  .167854E+00, .134178E+00, .106127E+00, .829579E-01,
     +  .639392E-01, .486556E-01, .363382E-01, .266208E-01,
     +  .190753E-01, .133195E-01, .902312E-02, .589218E-02,
     +  .368749E-02, .217976E-02, .120567E-02, .609507E-03,
     +  .273022E-03, .102880E-03, .299733E-04, .593026E-05,
     +  .667237E-06, .000000E+00, .193130E+07, .145209E+07,
     +  .107191E+07, .790739E+06, .582964E+06, .429465E+06,
     +  .316186E+06, .232611E+06, .171019E+06, .125642E+06,
     +  .922477E+05, .676799E+05, .496261E+05, .363633E+05,
     +  .266314E+05, .194924E+05, .142615E+05, .104296E+05,
     +  .762590E+04, .557475E+04, .407587E+04, .298055E+04,
     +  .218094E+04, .159710E+04, .117114E+04, .860170E+03 /
        DATA (UPDI(I),I=7489,7540) /
     +  .633458E+03, .465857E+03, .345450E+03, .257344E+03,
     +  .192807E+03, .145408E+03, .110507E+03, .847743E+02,
     +  .656209E+02, .513219E+02, .405805E+02, .324421E+02,
     +  .262240E+02, .214200E+02, .176754E+02, .147162E+02,
     +  .123522E+02, .104407E+02, .887844E+01, .758746E+01,
     +  .651457E+01, .560586E+01, .484011E+01, .418220E+01,
     +  .361935E+01, .313338E+01, .271201E+01, .234530E+01,
     +  .202530E+01, .174558E+01, .150085E+01, .128680E+01,
     +  .109973E+01, .936518E+00, .794412E+00, .671030E+00,
     +  .564053E+00, .472107E+00, .392511E+00, .324354E+00,
     +  .266241E+00, .216948E+00, .175359E+00, .140490E+00,
     +  .111449E+00, .874590E-01, .678131E-01, .518269E-01,
     +  .390963E-01, .289326E-01, .209928E-01, .148908E-01 /
        DATA (UPDI(I),I=7541,7592) /
     +  .102864E-01, .688874E-02, .444298E-02, .274346E-02,
     +  .159788E-02, .869443E-03, .431494E-03, .189257E-03,
     +  .696229E-04, .197556E-04, .382302E-05, .434174E-06,
     +  .000000E+00, .249873E+07, .187074E+07, .137397E+07,
     +  .100840E+07, .739590E+06, .542002E+06, .396923E+06,
     +  .290441E+06, .212374E+06, .155163E+06, .113284E+06,
     +  .826414E+05, .602467E+05, .438868E+05, .319497E+05,
     +  .232434E+05, .169010E+05, .122825E+05, .892334E+04,
     +  .648086E+04, .470700E+04, .341890E+04, .248454E+04,
     +  .180674E+04, .131547E+04, .959214E+03, .701250E+03,
     +  .511866E+03, .376758E+03, .278588E+03, .207178E+03,
     +  .155099E+03, .117016E+03, .891302E+02, .685119E+02,
     +  .532201E+02, .418041E+02, .332066E+02, .266746E+02 /
        DATA (UPDI(I),I=7593,7644) /
     +  .216552E+02, .177624E+02, .147009E+02, .122666E+02,
     +  .103074E+02, .871338E+01, .740232E+01, .631790E+01,
     +  .540393E+01, .463762E+01, .398269E+01, .342544E+01,
     +  .294703E+01, .253465E+01, .217801E+01, .186880E+01,
     +  .160032E+01, .136707E+01, .116450E+01, .988733E+00,
     +  .836497E+00, .704917E+00, .591509E+00, .493898E+00,
     +  .410620E+00, .339065E+00, .278254E+00, .226798E+00,
     +  .183487E+00, .147231E+00, .117074E+00, .921613E-01,
     +  .717527E-01, .551823E-01, .418163E-01, .312689E-01,
     +  .229272E-01, .164750E-01, .115673E-01, .790436E-02,
     +  .523246E-02, .333279E-02, .203025E-02, .116496E-02,
     +  .623488E-03, .303736E-03, .130438E-03, .468505E-04,
     +  .129531E-04, .245410E-05, .281274E-06, .000000E+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .204869E+05, .224252E+05, .179109E+05, .143065E+05,
     +  .114286E+05, .913058E+04, .729561E+04, .583028E+04,
     +  .466007E+04, .372547E+04, .297901E+04, .238276E+04,
     +  .190644E+04, .152591E+04, .122185E+04, .978876E+03,
     +  .784680E+03, .629445E+03, .505330E+03, .406075E+03,
     +  .326680E+03, .263154E+03, .212307E+03, .171594E+03,
     +  .138981E+03, .112843E+03, .918810E+02, .748457E+02,
     +  .613815E+02, .505552E+02, .418395E+02, .348127E+02,
     +  .291375E+02, .245563E+02, .208285E+02, .177945E+02,
     +  .153151E+02, .132788E+02, .115965E+02, .101962E+02,
     +  .902305E+01, .802976E+01, .718102E+01, .644846E+01,
     +  .580971E+01, .524718E+01, .474871E+01, .429848E+01,
     +  .389322E+01, .352099E+01, .318011E+01, .286512E+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .257328E+01, .230296E+01, .205338E+01, .182418E+01,
     +  .161505E+01, .142541E+01, .125434E+01, .110061E+01,
     +  .962840E+00, .839594E+00, .729499E+00, .631717E+00,
     +  .544098E+00, .466256E+00, .397281E+00, .336363E+00,
     +  .282773E+00, .235851E+00, .194993E+00, .159640E+00,
     +  .129255E+00, .103334E+00, .816355E-01, .634087E-01,
     +  .483765E-01, .361562E-01, .263857E-01, .187239E-01,
     +  .128516E-01, .847900E-02, .531078E-02, .312867E-02,
     +  .169694E-02, .822241E-03, .338399E-03, .107603E-03,
     +  .213705E-04, .134263E-05, .000000E+00, .353155E+05,
     +  .283587E+05, .225787E+05, .179754E+05, .143124E+05,
     +  .113952E+05, .907404E+04, .722549E+04, .575463E+04,
     +  .458326E+04, .365123E+04, .290896E+04, .231834E+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .184795E+04, .147363E+04, .117549E+04, .938213E+03,
     +  .749189E+03, .598728E+03, .478835E+03, .383376E+03,
     +  .307283E+03, .246670E+03, .198325E+03, .159789E+03,
     +  .129032E+03, .104489E+03, .846297E+02, .690126E+02,
     +  .565063E+02, .464908E+02, .384485E+02, .319866E+02,
     +  .267904E+02, .225836E+02, .191721E+02, .163978E+02,
     +  .141272E+02, .122602E+02, .107116E+02, .942054E+01,
     +  .833149E+01, .740578E+01, .661019E+01, .592042E+01,
     +  .531599E+01, .478367E+01, .430560E+01, .387820E+01,
     +  .348817E+01, .313367E+01, .280854E+01, .250977E+01,
     +  .223522E+01, .198375E+01, .175450E+01, .154672E+01,
     +  .135944E+01, .119141E+01, .104118E+01, .907175E+00,
     +  .787866E+00, .681752E+00, .587947E+00, .504270E+00 /
        DATA (UPDI(I),I=7801,7852) /
     +  .430285E+00, .365038E+00, .307699E+00, .257508E+00,
     +  .213788E+00, .175914E+00, .143320E+00, .115464E+00,
     +  .918296E-01, .721548E-01, .557137E-01, .422497E-01,
     +  .313820E-01, .227532E-01, .160379E-01, .109284E-01,
     +  .715468E-02, .444301E-02, .259308E-02, .139158E-02,
     +  .666231E-03, .270302E-03, .845243E-04, .165182E-04,
     +  .104944E-05, .000000E+00, .255687E+05, .368113E+05,
     +  .291649E+05, .231037E+05, .183047E+05, .145008E+05,
     +  .114892E+05, .910225E+04, .721264E+04, .571495E+04,
     +  .452941E+04, .358978E+04, .284601E+04, .225652E+04,
     +  .178991E+04, .142006E+04, .112730E+04, .895221E+03,
     +  .711489E+03, .565818E+03, .450471E+03, .358989E+03,
     +  .286521E+03, .229016E+03, .183432E+03, .147239E+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .118521E+03, .954032E+02, .773246E+02, .629196E+02,
     +  .514477E+02, .422809E+02, .349554E+02, .290923E+02,
     +  .243706E+02, .205586E+02, .174742E+02, .149605E+02,
     +  .129038E+02, .112049E+02, .979547E+01, .861172E+01,
     +  .761060E+01, .675418E+01, .601567E+01, .537183E+01,
     +  .480803E+01, .430448E+01, .385710E+01, .345135E+01,
     +  .308508E+01, .275147E+01, .244715E+01, .216953E+01,
     +  .191706E+01, .168841E+01, .148245E+01, .129782E+01,
     +  .113302E+01, .986354E+00, .856110E+00, .740662E+00,
     +  .638409E+00, .548414E+00, .468480E+00, .398122E+00,
     +  .336354E+00, .282326E+00, .235257E+00, .194457E+00,
     +  .159285E+00, .129171E+00, .103571E+00, .819640E-01,
     +  .640766E-01, .492138E-01, .371133E-01, .274067E-01 /
        DATA (UPDI(I),I=7905,7956) /
     +  .197488E-01, .138289E-01, .935583E-02, .607861E-02,
     +  .374291E-02, .216427E-02, .114924E-02, .543631E-03,
     +  .217422E-03, .668536E-04, .128519E-04, .824570E-06,
     +  .000000E+00, .746526E+05, .591693E+05, .464254E+05,
     +  .364209E+05, .285747E+05, .224157E+05, .175860E+05,
     +  .137953E+05, .108233E+05, .849076E+04, .666219E+04,
     +  .522724E+04, .410243E+04, .321979E+04, .252797E+04,
     +  .198510E+04, .155960E+04, .122570E+04, .963969E+03,
     +  .758553E+03, .597525E+03, .471108E+03, .371969E+03,
     +  .294099E+03, .232993E+03, .184969E+03, .147254E+03,
     +  .117196E+03, .939268E+02, .755703E+02, .610961E+02,
     +  .496432E+02, .405786E+02, .333927E+02, .276596E+02,
     +  .230733E+02, .193959E+02, .164250E+02, .140154E+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .120420E+02, .104190E+02, .906758E+01, .793462E+01,
     +  .697394E+01, .615305E+01, .544393E+01, .482886E+01,
     +  .428479E+01, .380633E+01, .337689E+01, .299347E+01,
     +  .264821E+01, .233692E+01, .205624E+01, .180384E+01,
     +  .157769E+01, .137593E+01, .119669E+01, .103799E+01,
     +  .897844E+00, .774300E+00, .665590E+00, .569974E+00,
     +  .486430E+00, .412760E+00, .348398E+00, .292319E+00,
     +  .243647E+00, .201575E+00, .165401E+00, .134469E+00,
     +  .108210E+00, .860818E-01, .675654E-01, .523761E-01,
     +  .398730E-01, .297919E-01, .217874E-01, .155387E-01,
     +  .107625E-01, .719552E-02, .461872E-02, .280679E-02,
     +  .159987E-02, .835979E-03, .388357E-03, .152083E-03,
     +  .456551E-04, .858381E-05, .560664E-06, .000000E+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .119277E+06, .937542E+05, .728718E+05, .566299E+05,
     +  .440089E+05, .341944E+05, .265698E+05, .206419E+05,
     +  .160377E+05, .124588E+05, .967976E+04, .751996E+04,
     +  .584316E+04, .454021E+04, .352881E+04, .274298E+04,
     +  .213307E+04, .165918E+04, .129140E+04, .100563E+04,
     +  .783837E+03, .611470E+03, .477646E+03, .373597E+03,
     +  .292767E+03, .229888E+03, .181010E+03, .142449E+03,
     +  .112897E+03, .898202E+02, .718046E+02, .576916E+02,
     +  .466302E+02, .379471E+02, .310851E+02, .256476E+02,
     +  .213277E+02, .178695E+02, .150895E+02, .128330E+02,
     +  .109934E+02, .947482E+01, .821272E+01, .715193E+01,
     +  .625340E+01, .548412E+01, .482282E+01, .424324E+01,
     +  .373835E+01, .328960E+01, .289298E+01, .253955E+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .222427E+01, .194301E+01, .169266E+01, .147051E+01,
     +  .127409E+01, .110104E+01, .949002E+00, .815718E+00,
     +  .699052E+00, .597114E+00, .508062E+00, .430800E+00,
     +  .363148E+00, .304474E+00, .253725E+00, .210013E+00,
     +  .172518E+00, .140533E+00, .113402E+00, .905593E-01,
     +  .714762E-01, .556438E-01, .427728E-01, .322762E-01,
     +  .238942E-01, .173060E-01, .122170E-01, .837066E-02,
     +  .553150E-02, .350458E-02, .209875E-02, .117709E-02,
     +  .603861E-03, .274675E-03, .104909E-03, .305838E-04,
     +  .558897E-05, .372374E-06, .000000E+00, .184905E+06,
     +  .144265E+06, .111188E+06, .856729E+05, .660092E+05,
     +  .508457E+05, .391640E+05, .301590E+05, .232243E+05,
     +  .178805E+05, .137667E+05, .105976E+05, .815891E+04 /
        DATA (UPDI(I),I=8113,8164) /
     +  .628081E+04, .483595E+04, .372352E+04, .286793E+04,
     +  .220930E+04, .170282E+04, .131297E+04, .101321E+04,
     +  .782469E+03, .605010E+03, .468362E+03, .363219E+03,
     +  .282221E+03, .219869E+03, .171160E+03, .134194E+03,
     +  .105610E+03, .835102E+02, .663674E+02, .530591E+02,
     +  .427130E+02, .346132E+02, .282556E+02, .232504E+02,
     +  .192803E+02, .161169E+02, .135720E+02, .115150E+02,
     +  .983172E+01, .844447E+01, .728851E+01, .631760E+01,
     +  .549350E+01, .479113E+01, .418095E+01, .365415E+01,
     +  .319026E+01, .278413E+01, .242578E+01, .210926E+01,
     +  .182966E+01, .158314E+01, .136636E+01, .117630E+01,
     +  .101016E+01, .865268E+00, .739143E+00, .629500E+00,
     +  .534352E+00, .451786E+00, .380642E+00, .318779E+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .265507E+00, .219765E+00, .180656E+00, .147364E+00,
     +  .119182E+00, .954649E-01, .756597E-01, .592530E-01,
     +  .457558E-01, .348799E-01, .260913E-01, .191398E-01,
     +  .137302E-01, .959500E-02, .650394E-02, .424861E-02,
     +  .265879E-02, .157090E-02, .868215E-03, .438239E-03,
     +  .195811E-03, .733356E-04, .209701E-04, .379885E-05,
     +  .261144E-06, .000000E+00, .277914E+06, .215406E+06,
     +  .164763E+06, .125986E+06, .963207E+05, .736161E+05,
     +  .562561E+05, .429763E+05, .328278E+05, .250685E+05,
     +  .191419E+05, .146128E+05, .111552E+05, .851417E+04,
     +  .649892E+04, .496023E+04, .378665E+04, .289089E+04,
     +  .220792E+04, .168678E+04, .128954E+04, .986460E+03,
     +  .755429E+03, .579133E+03, .444704E+03, .342090E+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .263827E+03, .203257E+03, .157717E+03, .122835E+03,
     +  .961157E+02, .755853E+02, .597942E+02, .476334E+02,
     +  .381995E+02, .308631E+02, .251389E+02, .206393E+02,
     +  .170849E+02, .142505E+02, .119786E+02, .101354E+02,
     +  .862863E+01, .738358E+01, .634632E+01, .547319E+01,
     +  .473513E+01, .409935E+01, .355511E+01, .308011E+01,
     +  .266799E+01, .230773E+01, .199246E+01, .171654E+01,
     +  .147543E+01, .126521E+01, .108236E+01, .923732E+00,
     +  .786369E+00, .667620E+00, .565083E+00, .476697E+00,
     +  .400505E+00, .335298E+00, .278986E+00, .230836E+00,
     +  .189787E+00, .154949E+00, .125512E+00, .100784E+00,
     +  .801373E-01, .630342E-01, .489837E-01, .375214E-01,
     +  .283660E-01, .210346E-01, .152904E-01, .108644E-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .751608E-02, .504047E-02, .325499E-02, .201211E-02,
     +  .117297E-02, .638897E-03, .317346E-03, .139312E-03,
     +  .511814E-04, .143614E-04, .257683E-05, .183121E-06,
     +  .000000E+00, .405998E+06, .312809E+06, .237621E+06,
     +  .180434E+06, .136979E+06, .103946E+06, .788612E+05,
     +  .598060E+05, .453460E+05, .343690E+05, .260447E+05,
     +  .197298E+05, .149443E+05, .113162E+05, .856862E+04,
     +  .648688E+04, .491131E+04, .371821E+04, .281569E+04,
     +  .213259E+04, .161610E+04, .122529E+04, .929857E+03,
     +  .706324E+03, .537321E+03, .409427E+03, .312733E+03,
     +  .238563E+03, .183292E+03, .141337E+03, .109486E+03,
     +  .852346E+02, .667475E+02, .526396E+02, .417918E+02,
     +  .334317E+02, .269652E+02, .219267E+02, .179801E+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .148597E+02, .123789E+02, .103827E+02, .876389E+01,
     +  .743699E+01, .634020E+01, .542429E+01, .465620E+01,
     +  .399990E+01, .344269E+01, .296049E+01, .254572E+01,
     +  .218634E+01, .187461E+01, .160419E+01, .136987E+01,
     +  .116722E+01, .992309E+00, .841666E+00, .712119E+00,
     +  .600881E+00, .505467E+00, .423765E+00, .353796E+00,
     +  .294316E+00, .243303E+00, .199987E+00, .163323E+00,
     +  .132432E+00, .106525E+00, .849274E-01, .670340E-01,
     +  .523304E-01, .403511E-01, .306599E-01, .229866E-01,
     +  .168975E-01, .121715E-01, .856593E-02, .586638E-02,
     +  .389217E-02, .248473E-02, .151719E-02, .872685E-03,
     +  .468471E-03, .229006E-03, .987874E-04, .356148E-04,
     +  .981107E-05, .174254E-05, .127748E-06, .000000E+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .578189E+06, .443038E+06, .334408E+06, .252296E+06,
     +  .190287E+06, .143447E+06, .108103E+06, .814282E+05,
     +  .613169E+05, .461510E+05, .347266E+05, .261187E+05,
     +  .196400E+05, .147626E+05, .110946E+05, .833551E+04,
     +  .626226E+04, .470385E+04, .353372E+04, .265476E+04,
     +  .199524E+04, .150008E+04, .112868E+04, .849919E+03,
     +  .640853E+03, .483930E+03, .366272E+03, .276785E+03,
     +  .210664E+03, .160905E+03, .123450E+03, .951812E+02,
     +  .738159E+02, .576542E+02, .453332E+02, .359201E+02,
     +  .287001E+02, .231223E+02, .187890E+02, .153910E+02,
     +  .127107E+02, .105712E+02, .884934E+01, .744898E+01,
     +  .630018E+01, .534819E+01, .455592E+01, .388424E+01,
     +  .331846E+01, .283285E+01, .241859E+01, .206269E+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .175658E+01, .149325E+01, .126692E+01, .107270E+01,
     +  .906299E+00, .763997E+00, .642453E+00, .538779E+00,
     +  .450437E+00, .375287E+00, .311351E+00, .257361E+00,
     +  .211373E+00, .172596E+00, .140008E+00, .112750E+00,
     +  .900586E-01, .712849E-01, .558522E-01, .432719E-01,
     +  .331069E-01, .249522E-01, .185517E-01, .135184E-01,
     +  .964879E-02, .672552E-02, .455949E-02, .299269E-02,
     +  .188862E-02, .113908E-02, .646473E-03, .342030E-03,
     +  .164560E-03, .697667E-04, .246910E-04, .668082E-05,
     +  .117430E-05, .886804E-07, .000000E+00, .804817E+06,
     +  .613542E+06, .460342E+06, .345215E+06, .258778E+06,
     +  .193873E+06, .145189E+06, .108668E+06, .813022E+05,
     +  .607938E+05, .454415E+05, .339480E+05, .253529E+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .189247E+05, .141225E+05, .105345E+05, .785669E+04,
     +  .585787E+04, .436753E+04, .325606E+04, .242806E+04,
     +  .181100E+04, .135160E+04, .100941E+04, .754727E+03,
     +  .565050E+03, .423956E+03, .317512E+03, .239499E+03,
     +  .181275E+03, .137806E+03, .105272E+03, .808859E+02,
     +  .625944E+02, .487642E+02, .382865E+02, .303150E+02,
     +  .242071E+02, .194993E+02, .158369E+02, .129700E+02,
     +  .106990E+02, .888479E+01, .742032E+01, .622765E+01,
     +  .524659E+01, .443613E+01, .375421E+01, .318417E+01,
     +  .269875E+01, .228796E+01, .193791E+01, .163927E+01,
     +  .138442E+01, .116709E+01, .981987E+00, .824534E+00,
     +  .690811E+00, .577358E+00, .481220E+00, .399834E+00,
     +  .331052E+00, .272918E+00, .224154E+00, .182901E+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .148359E+00, .119536E+00, .956009E-01, .758244E-01,
     +  .595859E-01, .463411E-01, .356306E-01, .270476E-01,
     +  .202197E-01, .149073E-01, .107675E-01, .761488E-02,
     +  .525675E-02, .352762E-02, .229049E-02, .142885E-02,
     +  .851193E-03, .476646E-03, .248544E-03, .117704E-03,
     +  .490521E-04, .170478E-04, .453285E-05, .788524E-06,
     +  .612686E-07, .000000E+00, .109739E+07, .832545E+06,
     +  .621124E+06, .463125E+06, .345153E+06, .257068E+06,
     +  .191370E+06, .142371E+06, .105866E+06, .786714E+05,
     +  .584345E+05, .433764E+05, .321842E+05, .238660E+05,
     +  .176907E+05, .131065E+05, .970730E+04, .718680E+04,
     +  .532000E+04, .393726E+04, .291425E+04, .215721E+04,
     +  .159758E+04, .118376E+04, .878012E+03, .651991E+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .485135E+03, .360230E+03, .269400E+03, .202145E+03,
     +  .152327E+03, .115341E+03, .878385E+02, .673756E+02,
     +  .520262E+02, .404909E+02, .317834E+02, .251641E+02,
     +  .201008E+02, .161918E+02, .131542E+02, .107656E+02,
     +  .887093E+01, .735248E+01, .612450E+01, .512157E+01,
     +  .429894E+01, .361179E+01, .304163E+01, .255981E+01,
     +  .215520E+01, .181313E+01, .152358E+01, .127840E+01,
     +  .107088E+01, .895423E+00, .747217E+00, .622199E+00,
     +  .516829E+00, .428122E+00, .353514E+00, .290871E+00,
     +  .238271E+00, .194444E+00, .157621E+00, .127002E+00,
     +  .101635E+00, .807223E-01, .635712E-01, .495952E-01,
     +  .382847E-01, .292113E-01, .220004E-01, .163121E-01,
     +  .119251E-01, .853740E-02, .598208E-02, .408963E-02 /
        DATA (UPDI(I),I=8633,8684) /
     +  .271641E-02, .174469E-02, .107580E-02, .632977E-03,
     +  .349720E-03, .179732E-03, .837873E-04, .343296E-04,
     +  .117210E-04, .306392E-05, .527571E-06, .421365E-07,
     +  .000000E+00, .146837E+07, .110887E+07, .822798E+06,
     +  .610144E+06, .452201E+06, .334908E+06, .247899E+06,
     +  .183364E+06, .135552E+06, .100135E+06, .739299E+05,
     +  .545442E+05, .402197E+05, .296372E+05, .218281E+05,
     +  .160668E+05, .118212E+05, .869304E+04, .639096E+04,
     +  .469695E+04, .345188E+04, .253673E+04, .186482E+04,
     +  .137141E+04, .100942E+04, .743729E+03, .549011E+03,
     +  .404335E+03, .299915E+03, .223183E+03, .166775E+03,
     +  .125219E+03, .945544E+02, .719159E+02, .550640E+02,
     +  .424973E+02, .330824E+02, .259794E+02, .205857E+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .164519E+02, .132621E+02, .107715E+02, .880934E+01,
     +  .724759E+01, .599311E+01, .497553E+01, .414663E+01,
     +  .345912E+01, .289274E+01, .241765E+01, .202169E+01,
     +  .168947E+01, .141038E+01, .117583E+01, .978757E+00,
     +  .813312E+00, .674519E+00, .558220E+00, .460839E+00,
     +  .379388E+00, .311326E+00, .254550E+00, .207188E+00,
     +  .167990E+00, .135281E+00, .108272E+00, .860559E-01,
     +  .678737E-01, .530727E-01, .411033E-01, .314923E-01,
     +  .238441E-01, .178160E-01, .131008E-01, .949631E-02,
     +  .673822E-02, .467761E-02, .316671E-02, .208182E-02,
     +  .132257E-02, .806066E-03, .468406E-03, .255338E-03,
     +  .129339E-03, .593594E-04, .239161E-04, .802475E-05,
     +  .206325E-05, .351731E-06, .288510E-07, .000000E+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .193087E+07, .145172E+07, .107157E+07, .790441E+06,
     +  .582700E+06, .429230E+06, .315977E+06, .232426E+06,
     +  .170855E+06, .125496E+06, .921182E+05, .675651E+05,
     +  .495244E+05, .362733E+05, .265516E+05, .194217E+05,
     +  .141989E+05, .103742E+05, .757685E+04, .553132E+04,
     +  .403741E+04, .294648E+04, .215074E+04, .157031E+04,
     +  .114736E+04, .839046E+03, .614673E+03, .449159E+03,
     +  .330559E+03, .244044E+03, .180906E+03, .134738E+03,
     +  .100920E+03, .761392E+02, .578281E+02, .442744E+02,
     +  .341932E+02, .266426E+02, .209490E+02, .166158E+02,
     +  .132945E+02, .107186E+02, .870251E+01, .710840E+01,
     +  .583625E+01, .481113E+01, .398166E+01, .329837E+01,
     +  .273939E+01, .227388E+01, .188872E+01, .156795E+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .130046E+01, .107729E+01, .891112E+00, .735895E+00,
     +  .606558E+00, .498896E+00, .409329E+00, .334896E+00,
     +  .273100E+00, .221886E+00, .179445E+00, .144554E+00,
     +  .115638E+00, .919287E-01, .725653E-01, .568332E-01,
     +  .441221E-01, .339210E-01, .257941E-01, .193788E-01,
     +  .143643E-01, .104752E-01, .752832E-02, .529408E-02,
     +  .364082E-02, .244068E-02, .158799E-02, .997825E-03,
     +  .601069E-03, .344955E-03, .185531E-03, .926314E-04,
     +  .418576E-04, .165874E-04, .547177E-05, .138432E-05,
     +  .233702E-06, .196706E-07, .000000E+00, .249827E+07,
     +  .187034E+07, .137361E+07, .100808E+07, .739304E+06,
     +  .541748E+06, .396698E+06, .290241E+06, .212197E+06,
     +  .155006E+06, .113145E+06, .825180E+05, .601373E+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .437899E+05, .318639E+05, .231674E+05, .168338E+05,
     +  .122230E+05, .887066E+04, .643422E+04, .466570E+04,
     +  .338232E+04, .245213E+04, .177800E+04, .128998E+04,
     +  .936572E+03, .681127E+03, .493992E+03, .360834E+03,
     +  .264381E+03, .194483E+03, .143738E+03, .106829E+03,
     +  .799785E+02, .602770E+02, .457976E+02, .351025E+02,
     +  .271472E+02, .211887E+02, .166840E+02, .132535E+02,
     +  .106098E+02, .855367E+01, .693815E+01, .565700E+01,
     +  .463120E+01, .380655E+01, .313172E+01, .258342E+01,
     +  .213000E+01, .175750E+01, .144950E+01, .119450E+01,
     +  .983257E+00, .808252E+00, .663340E+00, .543392E+00,
     +  .444192E+00, .362197E+00, .294493E+00, .238648E+00,
     +  .192665E+00, .154810E+00, .123897E+00, .984551E-01 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
