/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#include <mcloud/api/downloadtask.h>

#include "downloadtask_priv.h"
#include "taskhandler.h"

using namespace mcloud::api;
using namespace std;

DownloadTask::DownloadTask(std::shared_ptr<DownloadTaskPriv> p)
    :p_(p){
}

const string & DownloadTask::task_url() const {
    return p_->task_url();
}

Task::Status DownloadTask::status() const {
    return p_->task_handler()->status();
}

const string & DownloadTask::task_id() const {
    return p_->content_id();  //for content download, task id is the content's id.
}

const string & DownloadTask::content_id() const {
    return p_->content_id();
}

const string & DownloadTask::content_name() const {
    return p_->content_name();
}

const string & DownloadTask::file_path() const {
    return p_->file_path();
}

Task::ProgressHandler & DownloadTask::progress_changed() {
    return p_->progress_changed();
}

Task::StatusHandler & DownloadTask::status_changed() {
    return p_->status_changed();
}

const string & DownloadTask::error_string() const {
    return p_->error_string();
}

void DownloadTask::cancel() {
    p_->task_handler()->cancel();
}

