/*
 * Copyright (C) 2016 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of version 3 of the GNU Lesser General Public License as published
 * by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Gary Wang  <gary.wang@canonical.com>
 */

#ifndef MCLOUD_API_SYNCTHREAD_H_
#define MCLOUD_API_SYNCTHREAD_H_

#include <mcloud/api/taskqueue.h>
#include <mcloud/api/visibility.h>

#include <memory>
#include <thread>
#include <condition_variable>

namespace mcloud {
namespace api {

template<typename T>
class MCLOUD_API_DLL_LOCAL SyncThread {
public:
    typedef std::shared_ptr<SyncThread> Ptr;

    SyncThread();

    virtual ~SyncThread();

    void add_task(std::shared_ptr<T> task_ptr);

    void start();

    void cancel();

    void pause();

    void stop();

private:
    void run();

private:
    class HttpStreamClient;

    std::shared_ptr<HttpStreamClient> client_;

    TaskQueue<std::shared_ptr<T>>    task_queue_;

    std::thread thread_;

    std::condition_variable con_;

    std::mutex  mutex_;

    bool        stop_;

    bool        pause_;

    const int   sync_timeout_ = 1;
};

}
}

#endif // MCLOUD_API_SYNCTHREAD_H_
