Version 0.9.4
=============

libmdb:
* Write encrypted pages #305
* Improved support for big-endian platforms
* Remove obsolete `AC_HEADER_STDC` macro from configure.ac

SQL:
* Fix compilation on RHEL 7.9 #301
* Add brackets around table names in `mdb-query` output #307
* Support for brackets around table names in SQL parser
* Fix regression in 0.9.3 where `COUNT(*)` resulted in a parse error #318 #319

ODBC:
* Fix `-Werror=array-bounds` compile error #313

Version 0.9.3
=============

libmdb:
* Support files created with Access 2019 #260 #277
* Fix a warning when reading in binary property values #262
* Fix signed-unsigned comparison warning #269
* Migrate to `g_memdup2` #287 #288
* Fix build when `_XOPEN_SOURCE` was already defined on the platform #298
* Fix build failure with emscripten #299

libmdbsql:
* Support negative floating point literals #274 #279
* Improved support for file paths in `CONNECT TO` statements #275 #280 #282
* Comparison operators behaved incorrectly when the constant was on the left #283 #285
* Allow double quoted (") database names #291
* Allow spaces in database names #292 #293

ODBC:
* unixODBC now uses the `--libdir` passed at configure-time #261
* Fix a segfault in PyODBC when `SQLGetTypeInfo` is called on an unsupported data type #278

Docs:
* Add JET version for access 2013/2016/2019 to docs #286

Version 0.9.2
=============

MDB Tools 0.9.2 is a security and bug-fix release. Due to a number of memory
errors uncovered by OSS-Fuzz, all users who use MDB Tools to read data from
untrusted sources are encouraged to upgrade to 0.9.2 as soon as possible.

The release also includes some minor improvements and behavior changes,
described below.

libmdb:
* Fix infinite loop with malformed input (oss-fuzz/28789)
* Fix buffer overrun and some out of bounds memory accesses (oss-fuzz/28832 + oss-fuzz/28807)
* Fix potential memory leak (oss-fuzz/28791)
* Improved bounds and return value checking (oss-fuzz/29328 + oss-fuzz/29329)
* Add support for numeric scale/precision on JET3 databases and floating-point column types
* `mdb_col_to_string` now prints a warning and returns `""` for any unsupported data type
* Improved warning with invalid row data #253

Command-line tools:
* All CLI tools which accept string arguments are now locale-aware (#237)
* All CLI tools now accept a `--version` argument (#232)
* `mdb-export`: Fix issue where exported SQL field sizes were sometimes twice the necessary size (#112)
* `mdb-export`: Improved handling of BLOBs (#250)
* `mdb-export`: Implement a serial type and relations for MySQL (#257)
* `mdb-queries` now has long option names `--list`, `--newline`, and `--delimiter`
* `mdb-schema`: Exit with an error code if the requested table is not found

ODBC:
* `SQLBindCol` now respects its TargetType (fCType) argument and converts bound data to the requested type (#23 #242)
* `SQLFetchCol` now returns `SQL_SUCCESS_WITH_INFO` if a bound column was truncated, and `SQL_ERROR` if a bound value is out of range of the target type.
* Fix handling of numeric types in ODBC driver (#255)

Build and documentation:
* Updated man pages with new SQL features and correct `MDBOPTS` information (#203)
* Add generated API documentation (#239)
* Move `HACKING` to `HACKING.md` (with a relocation notice) and `TODO` to `TODO.md`
* Fuzz-test all pull requests (#230)
* Add `-DHAVE_GLIB` to library's `pkg-config --cflags` if needed (#254)


Version 0.9.1
=============

* MDB Tools has migrated from Travis CI to GitHub Actions for automated builds
* Fix a build error with msys2 (Windows) when GLib was disabled
* Remove dependency on math.h #228
* mdb-export now uses scientific notation only for very small numbers #84
* mdb-schema no longer emits illegal ALTER TABLE statements for SQLite relationships #82
* mdb-schema now omits the namespace for PostgreSQL indexes and constraints #93
* Automatically detect character encoding of JET3 databases #224
* JET3: Transcode Latin-1 text to UTF-8 when iconv is not present
* JET4: Transcode Unicode text to UTF-8 when iconv is not present (using `wcstombs`) #223
* Fix a buffer overrun with binary string fields OSS-Fuzz/28779 #216
* Fix a stack overflow with malformed input OSS-Fuzz/28780 #217
* Improved validation of date input OSS-Fuzz/28790 #219
* Fix a potential buffer overrun when compiled without iconv OSS-Fuzz/28773 #220
* Fix an extra newline that appeared at the `mdb-sql` prompt when Readline was not present
* Fix potential stack corruption with malformed input
* mdb-export has a new --escape-invisible flag for C-style escaping of tabs and newlines #222
* Print a warning if MDBOPTS=use_index is set at run-time but libmswstr was absent at compile-time #215 #226
* Improved support for databases that were improperly closed #120
* Remove warnings about mdb_find_row and row_size that did not necessarily indicate a problem


Version 0.9.0
=============

MDB Tools is under new management! Update your bookmarks and tell your favorite
search engine that this is our new home on the WWW:

    https://github.com/mdbtools/mdbtools

MDB Tools 0.9.0 builds off the fork of cyberemissary on GitHub, collects many
years of unapplied patches, and includes a number of internal improvements.
Besides a host of security fixes, GLib is now completely optional, files can
be opened completely in-memory, and many global variables have been eliminated
to facilitate thread safety.

The core library, libmdb, is believed to be thread-safe in the sense that
several handles can be opened simultaneously and passed between threads.
However, individual handles are NOT thread-safe, so don't try to do work
on a single handle from multiple threads without implementing your own
locking mechanism.

The auxiliary libraries, libmdbsql and ODBC, still have some non-reentrant
function calls. Thread safety is not promised, though the situation is
significantly improved from the 0.7 days.

The ABI has some slight changes (mostly having to do with struct layouts) so
you'll need to bump your SO numbers and such. The main changes to the API are
the introduction of a new function for in-memory parsing:

  MdbHandle *mdb_open_buffer(void *buffer, size_t len, MdbFileFlags flags);

And the modification of the "mdb_set_date_fmt" function to include a handle
parameter, so that date formats can be set in a non-global fashion:

  void mdb_set_date_fmt(MdbHandle *mdb, const char *);

The above function is the most common reason that old projects will fail to
compile on 0.9, and the fix is straightforward.

The previously-deprecated functions mdb_init() and mdb_exit() have been
removed. These functions did nothing; any calls to them should be excised with
prejudice.

This release introduces two new CLI tools (mdb-count and mdb-queries) and
deprecates mdb-array, mdb-header, and mdb-parsecsv. Several man pages have been
added or otherwise brought up to date.

The GNOME-based GUI tool that formerly shipped with MDB Tools has been moved to
a separate project, here:

    https://github.com/mdbtools/gmdb2

It seems to compile but should probably be classified as abandonware. The
project uses a deprecated GUI toolkit, and as such gmdb2 is no longer included
in Linux distros that used to carry it.

Version 0.7.1
=============
autogen.sh is no more. Use "autoreconf -if" to bootstrap the configuration.

autoconf/automake has been updated to more recent standards.
- config.guess  config.sub  depcomp  install-sh  ltmain.sh  missing  ylwrap
  files are now in build-aux/ directory
You'll now need autoconf >= 2.58

An experimental (buggy) version of ODBC driver that supports UCS-2 interface
is now available: libmdbodbcW.so
Note that libmdbodbc supports UTF-8 really well, so that this is usually not
needed.

Version 0.3
===========
The organization of the project files has changed a bit from that last release.
The autoconf stuff has been moved to the root directory.  The include directory
has also been moved from src/include to include

