/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __CHANNNEL_MANAGER_H__
#define __CHANNNEL_MANAGER_H__

#include <libgnome/libgnome.h>
#include <linux/dvb/frontend.h>
#include <list>
#include <glib.h>
#include "exception.h"
#include "string_utility.h"
#include "transponder.h"
#include "channel.h"

typedef struct
{
	const char*	field;
	int			value;
} DvbParameter;

class ChannelManager
{
private:
	int get_parameter_value ( const String& field, const DvbParameter* list );

	GSList*		channels_by_order;
	GHashTable*	transponders;
	GHashTable*	channels;

public:
	ChannelManager();
	~ChannelManager();

	void load(int frontend_type, const String& path);

	Transponder* get_transponder (int frequency) const;
	guint get_channel_count() const { return g_hash_table_size(channels); }
	GSList* get_channels() const;
	Channel* get_channel (int frequency, int service_id) const;
	Channel* get_channel (const String& channel_name) const;
};

#endif
