/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __DVB_TUNER_H__
#define __DVB_TUNER_H__

#include <linux/dvb/frontend.h>
#include <sys/ioctl.h>
#include <sys/poll.h>
#include <fcntl.h>
#include "channel.h"
#include "dvb_demuxer.h"

struct diseqc_cmd {
      struct dvb_diseqc_master_cmd cmd;
     uint32_t wait;
};

class DvbTuner
{
private:
	int fd;
	struct dvb_frontend_info frontend_info;
	void wait_lock();
	void diseqc(const Transponder& transponder);
	
public:
	DvbTuner(const String& tuner_device_path);
	~DvbTuner();

	int get_frontend_type() const { return frontend_info.type; }
	void get_frontend_info(struct dvb_frontend_info* fe_info) const;
	int get_fd() const { return fd; }
	void tune_to (Transponder& transponder);
};

#endif
