/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __EXCEPTION_HANDLER_H__
#define __EXCEPTION_HANDLER_H__

#include <libgnome/libgnome.h>
#include <gtk/gtk.h>
#include <iostream>
#include "log.h"

#define TRY		try {
#define CATCH	} \
				catch(const Exception& ex) { \
					Log::write(G_LOG_LEVEL_MESSAGE, _("Exception in %s: %s"), __PRETTY_FUNCTION__, ex.get_message().c_str()); \
					Application::show_error_message_dialog(ex.get_message()); \
				} \
				catch (...) { \
					Log::write(G_LOG_LEVEL_MESSAGE, _("Exception in %s"), __PRETTY_FUNCTION__); \
					Application::show_error_message_dialog(_("Me TV has encountered an error but does not know how to handle it.  Please check the log file for more information.")); \
				}
#define THREAD_CATCH	} \
				catch(const Exception& ex) { \
					Log::write(G_LOG_LEVEL_MESSAGE, _("Exception in %s: %s"), __PRETTY_FUNCTION__, ex.get_message().c_str()); \
					Application::get_current().push_error_message(ex.get_message()); \
				} \
				catch (...) { \
					Log::write(G_LOG_LEVEL_MESSAGE, _("Exception in %s"), __PRETTY_FUNCTION__); \
					Application::get_current().push_error_message(_("Me TV has encountered an error but does not know how to handle it.  Please check the log file for more information.")); \
				}

#endif
