/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#include "log.h"
#include "application.h"
#include "string_utility.h"
#include "date_time.h"
#include "configuration.h"
#include "exception.h"
#include "mutex_lock.h"

String Log::get_time()
{
	DateTime now = DateTime::now();
	return now.to_short_string();
}

void Log::write(GLogLevelFlags level, const String& message)
{
	static GStaticRecMutex mutex = G_STATIC_REC_MUTEX_INIT;
		
	MutexLock lock(&mutex);

	String t = get_time();
	String line = t;
	line += " - ";
	line += message;
	
	g_log("Me TV", level, line.c_str());
	try
	{
		IO::Channel& channel = Application::get_current().get_log_file();
		channel.write_line(line);
		channel.flush();
	}
	catch (const Exception& ex)
	{
		g_log("Me TV", G_LOG_LEVEL_CRITICAL, _("Failed to write entry to log file: %s"), ex.get_message().c_str());
	}
	catch (...)
	{
		g_log("Me TV", G_LOG_LEVEL_CRITICAL, _("Failed to write entry to log file"));
	}
}

void Log::write(const String& message)
{
	write(G_LOG_LEVEL_MESSAGE, message);
}

void Log::write(GLogLevelFlags level, const char* fmt, ...)
{
	va_list ap;
	
	va_start(ap, fmt);
	gchar* text = g_strdup_vprintf(fmt, ap);
	String message = text;
	write(level, message);
	g_free(text);
	va_end(ap);
}

void Log::write(const char* fmt, ...)
{
	va_list ap;
	
	va_start(ap, fmt);
	gchar* text = g_strdup_vprintf(fmt, ap);
	String message = text;
	write(message);
	g_free(text);
	va_end(ap);
}

