/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __MAIN_WINDOW__
#define __MAIN_WINDOW__

#include "gtk_epg_widget.h"
#include "engine.h"
#include "epg.h"
#include "glade.h"
#include "recording_manager.h"
#include "preferences_dialog.h"
#include "scheduled_recording_dialog.h"
#include "scheduled_recordings_dialog.h"
#include "search_bar.h"
#include "string.hh"

#define MAX_AUDIO_PIDS		16
#define MAX_SUBTITLE_PIDS	16

class MainWindow
{
private:
	GtkWidget*					window_main;
	GtkWidget*					vpaned_main;
	GtkWidget*					statusbar;
	GtkWidget*					toolbar;
	GtkWidget*					menubar;
	GtkWidget*					dialog_program_details;
	GtkWidget*					event_box_video;
	PreferencesDialog*			preferences_dialog;
	ScheduledRecordingDialog*	scheduled_recording_dialog;
	ScheduledRecordingsDialog*	scheduled_recordings_dialog;
	GtkEpgWidget*				epg_widget;
	Engine*						engine;
	gboolean					is_fullscreen;
	time_t						last_motion_time;
	gboolean					is_cursor_visible;
	GdkCursor*					hidden_cursor;
	SearchBar*					search_bar;
	GSList*						audio_stream_group;
	gint						audio_pids[MAX_AUDIO_PIDS];
	GSList*						subtitle_stream_group;
	gint						subtitle_pids[MAX_SUBTITLE_PIDS];
	gboolean					was_maximised;
	
	static void on_tool_button_mute_toggled (GtkToggleToolButton* widget, MainWindow* main_window);
	static void on_tool_button_record_toggled (GtkToggleToolButton* widget, MainWindow* main_window);
	static void on_tool_button_auto_surf_toggled (GtkToggleToolButton* widget, MainWindow* main_window);
	static void on_tool_button_broadcast_toggled (GtkToggleToolButton* widget, MainWindow* main_window);
	static void on_tool_button_scheduled_recordings_clicked(GtkToolButton *widget, MainWindow* main_window);
	static void on_tool_button_hide_controls_clicked(GtkToolButton *widget, MainWindow* main_window);
	static void on_menu_item_file_quit_activate (GtkMenuItem* widget, MainWindow* main_window);
	static void on_menu_item_view_fullscreen_activate (GtkMenuItem* widget, MainWindow* main_window);
	static void on_menu_item_view_preferences_activate (GtkMenuItem* widget, MainWindow* main_window);
	static void on_menu_item_view_epg_activate (GtkCheckMenuItem* widget, MainWindow* main_window);
	static void on_menu_item_view_program_search_activate (GtkMenuItem* widget, MainWindow* main_window);
	static void on_menu_item_subtitle_stream_toggled(GtkCheckMenuItem *checkmenuitem, gpointer data);
	static void on_menu_item_audio_stream_toggled(GtkCheckMenuItem *checkmenuitem, gpointer data);
	static void on_menu_item_audio_mute_toggled(GtkCheckMenuItem *checkmenuitem, MainWindow* main_window);
	static void on_menu_item_help_about_activate (GtkMenuItem* widget, MainWindow* main_window);
	static void on_menu_item_help_contents_activate (GtkMenuItem* widget, MainWindow* main_window);
	static void on_combo_box_record_type_changed (GtkComboBox* widget, MainWindow* main_window);
	static void on_spinbutton_duration_value_changed (GtkSpinButton* widget, MainWindow* main_window);
	static void on_menu_item_audio_dual_language_changed(GtkCheckMenuItem* widget, MainWindow* main_window);
	
	static gboolean on_window_main_button_press(GtkWindow* widget, GdkEventButton* event, MainWindow* main_window);
	static gboolean on_window_main_delete (GtkWindow* window_main, GdkEvent* event, MainWindow* main_window);
	static gboolean on_window_main_motion_notify(GtkWidget* window_main, GdkEventMotion* event, MainWindow* main_window);
	static gboolean on_window_main_key_press_event(GtkWidget* window_main, GdkEventKey* event, MainWindow* main_window);

	void show_search();
	void show_cursor();
	void hide_cursor();
	void show_controls(gboolean show);
	void show_epg(gboolean show);
	void push_recording_status(const String& message);
	void pop_status();
	void update_audio_stream_menu();
	void update_view_subtitle_menu();

	gboolean get_controls_visible();
	gboolean get_epg_visible();

public:
	MainWindow();
	~MainWindow();
	
	void auto_surf(gboolean state);
	void mute(gboolean state);
	void broadcast(gboolean state);
	void audio_channel(int channel);
	void subtitle_channel(int channel);
	void toggle_controls();
	void toggle_fullscreen();
	gboolean get_is_fullscreen() const { return is_fullscreen; }
	void show_fullscreen(gboolean show);
	void maximise();
	void hide_controls();
	void add_channel (int index, Channel& channel);
	void record(gboolean state);
	void update_epg();
	void change_channel_start();
	void channel_change_complete();
	void write(void* buffer, unsigned int length);
	void on_timer();
	void hide();
	void show();
	gboolean is_visible();
	gboolean is_minimised();
	void send_fake_key();
	Engine* get_engine() { return engine; }
	void show_program_details_dialog (const EpgEvent& event);
	void show_scheduled_recordings_dialog();
	void show_scheduled_recording_dialog();
	void show_scheduled_recording_dialog(ScheduledRecording& scheduled_recording);
	void show_preferences_dialog ();
	void set_selected_event(xmlNodePtr event);
	GtkWidget* get_widget() { return window_main; }
};

#endif
