/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include "scheduled_recording_dialog.h"
#include "application.h"
#include "glade.h"

ScheduledRecordingDialog::ScheduledRecordingDialog()
{
	Application& application = Application::get_current();
	Glade& glade = application.get_glade();
	
	dialog_scheduled_recording		= glade.get_widget("dialog_scheduled_recording");	
	entry_description				= GTK_ENTRY(glade.get_widget("entry_description"));	
	combo_box_channel				= GTK_COMBO_BOX(glade.get_widget("combo_box_channel"));
	combo_box_record_type			= GTK_COMBO_BOX(glade.get_widget("combo_box_record_type"));
	combo_box_start_day				= GTK_COMBO_BOX(glade.get_widget("combo_box_start_day"));
	date_edit_start_date			= (GnomeDateEdit*)glade.get_widget("date_edit_start_date");
	spinbutton_start_time_hour 		= GTK_SPIN_BUTTON(glade.get_widget("spinbutton_start_time_hour"));
	spinbutton_start_time_minute	= GTK_SPIN_BUTTON(glade.get_widget("spinbutton_start_time_minute"));
	spinbutton_duration				= GTK_SPIN_BUTTON(glade.get_widget("spinbutton_duration"));
}

void ScheduledRecordingDialog::show()
{
	ScheduledRecording scheduled_recording;

	scheduled_recording.channel_name = Application::get_current().get_video_channel_name();
	scheduled_recording.description = "Unknown";
	scheduled_recording.start_time = DateTime::now_utc();
	scheduled_recording.duration = 30 * 60;
	scheduled_recording.type = RECORDING_TYPE_ONCE_OFF;

	show(scheduled_recording);
}

void ScheduledRecordingDialog::show(ScheduledRecording& scheduled_recording)
{
	int response = 0;
	Application& application = Application::get_current();

	int index = 0;
	GSList* iterator = application.get_channel_manager().get_channels();
	while (iterator != NULL)
	{
		Channel& channel = *(Channel*)iterator->data;
		if (scheduled_recording.channel_name == channel.name)
		{
			gtk_combo_box_set_active(combo_box_channel, index);
		}
		index++;
		iterator = g_slist_next(iterator);
	}

	gtk_entry_set_text(entry_description, scheduled_recording.description.c_str());
	gtk_combo_box_set_active(combo_box_record_type, scheduled_recording.type);
	DateTime local_start_time(scheduled_recording.get_local_start_time());

	gnome_date_edit_set_time(
		date_edit_start_date,
		scheduled_recording.type == RECORDING_TYPE_ONCE_OFF ? scheduled_recording.get_local_start_time() : 0);

	gtk_combo_box_set_active(combo_box_start_day, local_start_time.get_day_of_week());

	gtk_spin_button_set_value(spinbutton_start_time_hour,	local_start_time.get_hour());
	gtk_spin_button_set_value(spinbutton_start_time_minute,	local_start_time.get_minute());
	gtk_spin_button_set_value(spinbutton_duration,			scheduled_recording.duration / 60);
	
	response = gtk_dialog_run(GTK_DIALOG(dialog_scheduled_recording));
	gtk_widget_hide(GTK_WIDGET(dialog_scheduled_recording));

	if (response == 1)
	{
		scheduled_recording.type = gtk_combo_box_get_active(combo_box_record_type);
		int start_time_date = gnome_date_edit_get_time(date_edit_start_date) + timezone;
	
		guint start_time = (guint)(gtk_spin_button_get_value(spinbutton_start_time_hour) * 60 * 60 +
				gtk_spin_button_get_value(spinbutton_start_time_minute) * 60);

		guint day_of_week = gtk_combo_box_get_active(combo_box_start_day);
		
		switch (scheduled_recording.type)
		{
		case RECORDING_TYPE_NONE:
			application.get_recording_manager().remove_scheduled_recording(scheduled_recording.description);
			break;
			
		case RECORDING_TYPE_ONCE_OFF:
			scheduled_recording.description		= gtk_entry_get_text(entry_description);
			scheduled_recording.channel_name	= gtk_combo_box_get_active_text(combo_box_channel);
			scheduled_recording.start_time		= start_time + start_time_date;
			scheduled_recording.duration		= (guint)gtk_spin_button_get_value(spinbutton_duration) * 60;
			application.get_recording_manager().add_scheduled_recording(scheduled_recording);
			break;
			
		case RECORDING_TYPE_EVERY_DAY_NOT_WE:
		case RECORDING_TYPE_EVERY_DAY_WE:
			scheduled_recording.description		= gtk_entry_get_text(entry_description);
			scheduled_recording.channel_name	= gtk_combo_box_get_active_text(combo_box_channel);
			scheduled_recording.start_time		= start_time;
			scheduled_recording.duration		= (guint)gtk_spin_button_get_value(spinbutton_duration) * 60;
			application.get_recording_manager().add_scheduled_recording(scheduled_recording);
			break;

		case RECORDING_TYPE_EVERY_WEEK:
			scheduled_recording.description		= gtk_entry_get_text(entry_description);
			scheduled_recording.channel_name	= gtk_combo_box_get_active_text(combo_box_channel);
			scheduled_recording.start_time		= start_time + (day_of_week * SECONDS_IN_DAY);
			scheduled_recording.duration		= (guint)gtk_spin_button_get_value(spinbutton_duration) * 60;
			application.get_recording_manager().add_scheduled_recording(scheduled_recording);
			break;
		}
		
		application.check_scheduled_recordings();

		Application::get_current().show_scheduled_recordings_dialog();
	}
}
