/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#ifndef __STRING_H__
#define __STRING_H__

#include <glib.h>

class String
{
private:
	gchar* buffer;
public:
	String(const String& s);
	String(const gchar* text = "");
	~String();
	
	static String format(const char* fmt, ...);

	gsize get_buffer_length() const;
	gsize get_character_length() const;
	const gchar* c_str() const;

	void canon(const gchar *valid_chars, gchar substitutor);
	gboolean is_empty() const;
	
	String trim() const;
	String lowercase() const;
	String escape() const;
	String replace(gchar ch1, gchar ch2) const;
	String replace(const String& s1, const String& s2) const;

	const gchar* find(const gchar* needle) const;
	void append(const gchar* s);
	void assign(const gchar* s);
	void assign(const String& s);
	gint compare(const gchar* s) const;
	gboolean equals(const gchar* s) const;
	gboolean equals(const String& s) const;

	String& operator+=(const gchar* s);
	String& operator+=(const String& s);
	String& operator+=(gunichar ch);
	String& operator=(const String& s);
	String& operator=(const gchar* s);

	gboolean operator==(const String& s) const;
	gboolean operator!=(const String& s) const;
};

inline String operator+(const gchar* s1, const String& s2)
{
	String result(s1);
	result += s2;
	return result;
}

inline String operator+(const String& s1, const gchar* s2)
{
	String result(s1);
	result += s2;
	return result;
}

#endif
