/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include "io.hh"
#include "application.hh"

#include <linux/dvb/ca.h>

#include <libdvbapi/dvbca.h>
#include <libdvbapi/dvbdemux.h>
#include <libdvben50221/en50221_app_ai.h>
#include <libdvben50221/en50221_app_ca.h>
#include <libdvben50221/en50221_app_rm.h>
#include <libdvben50221/en50221_app_tags.h>
#include <libdvben50221/en50221_session.h>
#include <libucsi/mpeg/section.h>

class DvbCamHandler
{
public:
	virtual ~DvbCamHandler();

	bool init();

	virtual void poll() = 0;
	virtual bool registerCam(int ca_fd, uint8_t slot) = 0;

	bool sendPmt(char *pmt_buffer, int size);

protected:
	DvbCamHandler();

	static int infoCallback(void *arg, uint8_t slot_id, uint16_t session_number, uint32_t ca_id_count, uint16_t *ca_ids);

	virtual bool sub_init() = 0;

	void *AiResource;
	void *CaResource;
	en50221_app_send_functions send_functions;

	volatile int SessionNumber;
};

class DvbCam
{
private:
	guint fd;
	ca_caps_t cap;
	ca_slot_info_t info;
	guint service_id;
	GThread* cam_thread;
	GThread* pmt_thread;
	DvbCamHandler* cam_handler;
			
	char pmt_buffer[4096];
	volatile gboolean stopped;
	volatile int pmt_size;

	static gpointer cam_thread_function(gpointer data);
	static gpointer pmt_thread_function(gpointer data);
	void cam_thread_handler();
	void pmt_thread_handler();
			
	bool processPmt(int demux_fd);
	int processPat(int demux_fd);
	int createSectionFilter(uint16_t pid, uint8_t table_id);

	
public:
	DvbCam(const String& path);
	~DvbCam();
			
	void start(guint service_id);
	void stop();
};
