/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#ifndef __STATUS_ICON_H__
#define __STATUS_ICON_H__

#include <gtk/gtk.h>
#include "string.hh"

class StatusIcon
{
private:
	GtkWidget* menu_application_popup;
	GtkStatusIcon* status_icon;

	static void on_status_icon_popup_menu(GtkStatusIcon* widget, guint button, guint activate_time,  StatusIcon* status_icon);
	static void on_status_icon_activate(GtkStatusIcon* widget, StatusIcon* status_icon);

	static void on_menu_item_me_tv_activate (GtkMenuItem* widget, StatusIcon* status_icon);
	static void on_menu_item_help_activate (GtkMenuItem* widget, StatusIcon* status_icon);
	static void on_menu_item_about_activate (GtkMenuItem* widget, StatusIcon* status_icon);
	static void on_menu_item_quit_activate (GtkMenuItem* widget, StatusIcon* status_icon);

public:
	StatusIcon();

	void set_title(const String& title);
};

#endif
