/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 
  $Id: nbest_generator.cpp,v 1.2 2004/03/08 07:40:53 taku-ku Exp $;

  Copyright (C) 2001-2004 Taku Kudo <taku-ku@is.aist-nara.ac.jp>
  This is free software with ABSOLUTELY NO WARRANTY.
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/  

#include "mecab.h"
#include "nbest_generator.h"
#include <queue>

namespace MeCab {
  
  bool NBestGenerator::set (Node *node)
  {
    freelist.free();
    for (; node->next; node = node->next) {}; // seek to EOS;
    while (! agenda.empty()) agenda.pop (); // make empty
    QueueElement *eos = freelist.alloc ();
    eos->node = node;
    eos->next = 0;
    eos->fx = eos->gx = 0;
    agenda.push (eos);
    return true;
  }

  Node* NBestGenerator::next () 
  {
    while (! agenda.empty()) {
      QueueElement *top = agenda.top ();
      agenda.pop ();
      Node *rnode = top->node;

      if (rnode->id == 0) { // BOS
	for (QueueElement *n = top; n->next; n = n->next) {
	  n->node->next = n->next->node; // change next & prev
	  n->next->node->prev = n->node;
	  // TODO: rewrite costs;
	}
	return rnode;
      }
      
      for (Path *path = rnode->path; path; path = path->next) {
	QueueElement *n = freelist.alloc (); 
	n->node = path->node;
	n->gx = path->cost - path->node->cost + top->gx;
	n->fx = path->cost + top->gx;
	n->next = top;
	agenda.push (n);
      }
    }
    return 0;
  }
}

