/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

  $Id: feature_index.h,v 1.10 2006/07/30 11:43:14 taku-ku Exp $;

  Copyright (C) 2001-2006 Taku Kudo <taku@chasen.org>
  Copyright (C) 2004-2006 Nippon Telegraph and Telephone Corporation

*/

#ifndef MECAB_FEATUREINDEX_H
#define MECAB_FEATUREINDEX_H

#include <map>
#include <vector>
#include "mecab.h"
#include "mmap.h"
#include "darts.h"
#include "freelist.h"
#include "common.h"
#include "dictionary_rewriter.h"

namespace MeCab {

  class Param;

  class FeatureIndex {
  protected:
    std::vector <int>   feature_;
    ChunkFreeList<int>  feature_freelist_;
    ChunkFreeList<char> char_freelist_;
    std::vector<char*>  unigram_templs_;
    std::vector<char*>  bigram_templs_;
    DictionaryRewriter  rewrite_;
    StringBuffer os_;
    size_t  maxid_;
    double  *alpha_;
    whatlog what_;
    virtual int id (const char *) = 0;

    char* getIndex (char* &, char **, size_t);
    bool openTemplate (Param &);

  public:
    virtual bool open(Param &) = 0;
    virtual void clear() = 0;
    virtual void close() = 0;
    virtual bool buildFeature(LearnerPath *) = 0;

    void set_alpha(double *);

    size_t size() { return maxid_; }

    bool buildUnigramFeature(LearnerPath *, const char*);
    bool buildBigramFeature(LearnerPath *, const char *, const char*);

    void calcCost(LearnerPath *);
    void calcCost(LearnerNode *);

    const char *what() { return what_.str(); }

    char *strdup(const char *);

    explicit FeatureIndex(): feature_freelist_(8192 * 32),
                             char_freelist_(8192 * 32),
                             maxid_(0), alpha_(0) {};
    virtual ~FeatureIndex() {}
  };

  class EncoderFeatureIndex: public FeatureIndex {
  private:
    std::map <std::string, int> dic_;
    std::map <std::string, std::pair<int*, size_t> > feature_cache_;
    int id(const char *);

  public:
    bool save(const char*);
    void shrink(size_t, std::vector<double>&) ;
    bool open(Param &);
    void clear();
    bool buildFeature(LearnerPath *);
    void clearcache();
    void close();
    bool convert(const char*, const char*);
  };

  class DecoderFeatureIndex: public FeatureIndex {
  private:
    Mmap<char>  mmap_;
    Darts::DoubleArray da_;
    int id(const char *);
  public:
    bool open(Param &);
    bool buildFeature(LearnerPath *);
    void clear();
    void close();
  };
}

#endif
