// MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
//
//  $Id: dictionary_rewriter.h 92 2007-02-24 14:03:08Z taku-ku $;
//
//  Copyright(C) 2001-2006 Taku Kudo <taku@chasen.org>
//  Copyright(C) 2004-2006 Nippon Telegraph and Telephone Corporation
#ifndef MECAB_DICTIONARY_REWRITER_H
#define MECAB_DICTIONARY_REWRITER_H

#include <vector>
#include <string>
#include <map>
#include "common.h"
#include "mecab.h"
#include "freelist.h"

namespace MeCab {

  class RewritePattern {
  private:
    std::vector<std::string> spat_;
    //    std::vector<std::string> spat2_; // binomial pattern
    std::vector<std::string> dpat_;
  public:
    bool set_pattern(const char *src, const char *dst);
    bool rewrite(size_t size,
                 const char **input,
                 std::string *output) const;
    //    bool set_pattern(const char *, const char *, const char*);
    //    bool rewrite(size_t, const char **,
    //           size_t, const char **,
    //           std::string *output) const;
  };

  class RewriteRules: public std::vector<RewritePattern> {
  public:
    bool rewrite(size_t size, const char **input,
                 std::string *output) const;
    //    bool rewrite(size_t, const char **, size_t, const char **,
    //                 std::string *output) const;
  };

  struct FeatureSet {
    std::string ufeature;
    std::string lfeature;
    std::string rfeature;
  };

  class DictionaryRewriter {
  private:
    RewriteRules unigram_rewrite_;
    RewriteRules left_rewrite_;
    RewriteRules right_rewrite_;
    std::map<std::string, FeatureSet> cache_;

  public:
    bool open(const char *filename);
    void clear();
    bool rewrite(const std::string &feature,
                 std::string *ufeature,
                 std::string *lfeature,
                 std::string *rfeature) const;

    bool rewrite2(const std::string &feature,
                  std::string *ufeature,
                  std::string *lfeature,
                  std::string *rfeature);
  };

  class POSIDGenerator {
  private:
    RewriteRules rewrite_;
  public:
    bool open(const char *filename);
    void clear() { rewrite_.clear(); }
    int id(const char *key) const;
  };

#if 0
  class BinomialNodeRewriter {
  private:
    RewriteRules        rewrite_;
    ChunkFreeList<char> char_freelist_;
  public:
    BinomialNodeRewriter(): char_freelist_(512) {}
    void free() { char_freelist_.free(); }
    bool open(const char *filename);
    void clear() { rewrite_.clear(); }
    bool rewrite(Node *bos);
  };
#endif
}
#endif
