/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med_outils.h>
#include <med.h>
#include <med_config.h>
#include <string.h>
#include <stdlib.h>

extern void *MedVersionedApiF;
extern void f77ApiIsSet(void * obj);

#define nedfouvr F77_FUNC(edfouvr,EDFOUVR)
#define nedfferm F77_FUNC(edfferm,EDFFERM)
#define nedflfde F77_FUNC(edflfde,EDFLFDE)
#define nedffien F77_FUNC(edffien,EDFFIEN)
#define nedffide F77_FUNC(edffide,EDFFIDE)
#define nedffoco F77_FUNC(edffoco,EDFFOCO)
#define nedfveco F77_FUNC(edfveco,EDFVECO)
#define nedfveli F77_FUNC(edfveli,EDFVELI)
#define nedfvedo F77_FUNC(edfvedo,EDFVEDO)
#define nedfmont F77_FUNC(edfmont,EDFMONT)
#define nedfdemo F77_FUNC(edfdemo,EDFDEMO)

#ifdef PPRO_NT
med_int
__stdcall EDFOUVR (char *nom, unsigned int bidon, med_int * acces, 
                   med_int *lon)
#else
med_int
nedfouvr (char *nom,med_int * acces,med_int *lon)
#endif
{
  char *fn;
  int ret;

  /* Cette mthode a pour unique but de forcer la construction
   de l'objet MedVersionedApiF et donc la mise  jour de MedVersionedApi
  avec les APis fortran. Certain compilateur supprime le symbole MedVersionedApiF
  croyant qu'il nest pas utilis et la mise  jour de MedVersionedApi n'est
  alors pas effectue.*/
  f77ApiIsSet(MedVersionedApiF);

  fn = _MED2cstring(nom, (int) * lon);
  if (!fn)
	return(-1);

  ret = (med_int) MEDouvrir(fn,(med_mode_acces) *acces); 

  _MEDcstringFree(fn);

  return(ret); 
}

#ifdef PPRO_NT
med_int
__stdcall EDFFERM(med_int * fid)
#else
med_int
nedfferm(med_int * fid)
#endif
{
  med_int ret;
  ret = (med_int) MEDfermer((med_idt) * fid);

  return(ret);
}

#ifdef PPRO_NT
med_int
__stdcall EDFLFDE(med_int *fid)
#else
med_int
nedflfde (med_int *fid)
#endif
{
  med_int longueur;

  longueur = MEDlFichDes((med_idt) *fid);

  return longueur;
}

#ifdef PPRO_NT
med_int
__stdcall EDFFIEN(med_int *fid,med_int *quoi,char *str, unsigned int bidon1)
#else
med_int
nedffien (med_int *fid,med_int *quoi,char *str)
#endif
{
  med_int ret;
  med_int longueur;
  char * fs1;

  /* Solution temporaire */
  longueur = MEDlFichDes((med_idt) *fid);
  ISCRUTE(longueur);
  fs1 = (char *) malloc(sizeof(char)*longueur+1);
  
  ret = (med_int) MEDfichEntete((med_idt) *fid,(med_fich_info) *quoi,(char *) fs1);

  strncpy(str,fs1,longueur);
  _MEDfstring(str,longueur);
  free(fs1);
  
  return ret;
}

#ifdef PPRO_NT
int
__stdcall EDFFIDE(med_int *fid,char *des, unsigned int bidon1,med_int *lon1)
#else
med_int
nedffide(med_int *fid,char *des,med_int *lon1)
#endif
{
  med_int ret;
  char *fn1;

  fn1 = _MED1cstring((char *)des,(int )*lon1,MED_TAILLE_DESC);

  ret = MEDfichDesEcr((med_idt) *fid,(char*)fn1);

  _MEDcstringFree(fn1);

  return ret;
}
  

#ifdef PPRO_NT
med_int
__stdcall EDFFOCO (char *nom, unsigned int bidon, med_int *lon)
#else
med_int
nedffoco (char *nom,med_int *lon)
#endif
{
  char *fn;
  int ret;

  fn = _MED2cstring(nom, (int) * lon);
  if (!fn)
	return(-1);

  ret = (med_int) MEDformatConforme(fn); 

  _MEDcstringFree(fn);

  return(ret); 
}

#ifdef PPRO_NT
med_int
__stdcall EDFVECO (char *nom, unsigned int bidon, med_int *lon)
#else
med_int
nedfveco (char *nom,med_int *lon)
#endif
{
  char *fn;
  med_int ret;

  fn = _MED2cstring(nom, (int) * lon);
  if (!fn)
	return(-1);

  ret = (med_int) MEDversionConforme(fn); 

  _MEDcstringFree(fn);

  return(ret); 
}

#ifdef PPRO_NT
med_int
__stdcall EDFVELI (med_int *fid, med_int *maj, med_int *min, med_int *rel)
#else
med_int
nedfveli (med_int *fid, med_int *maj, med_int *min, med_int *rel)
#endif
{
  med_int ret;

  ret = (med_int) MEDversionLire((med_idt) *fid, (med_int *) maj, (med_int *) min, (med_int *) rel); 

  return(ret); 
}

#ifdef PPRO_NT
med_int
__stdcall EDFVEDO (med_int *maj, med_int *min, med_int *rel)
#else
med_int
nedfvedo (med_int *maj, med_int *min, med_int *rel)
#endif
{
  med_int ret;

  ret = 0;

  MEDversionDonner((med_int *) maj, (med_int *) min, (med_int *) rel); 

  return(ret); 
}

#ifdef PPRO_NT
med_int
__stdcall EDFMONT (med_int *fid, char *acces, unsigned int bidon, med_int *lon, med_int *type)
#else
med_int
nedfmont (med_int *fid, char *acces, med_int *lon, med_int *type)
#endif
{
  char *fn;
  int ret;

  fn = _MED2cstring(acces, (int) * lon);
  if (!fn)
    return(-1);

  ret = (med_int) MEDmonter((med_idt) *fid,(const char *) fn, (med_type_donnee) *type); 

  _MEDcstringFree(fn);

  return(ret); 
}


#ifdef PPRO_NT
med_int
__stdcall EDFDEMO (med_int *fid, med_int *mid, med_int *type)
#else
med_int
nedfdemo (med_int *fid, med_int *mid, med_int *type)
#endif
{
  int ret;

  ret = (med_int) MEDdemonter((med_idt) *fid,(med_idt) * mid, (med_type_donnee) *type); 

  return (ret); 
}
