/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>
#include <hdf5.h>

/*
 * - Nom de la fonction : _MEDnObjets
 * - Description : indique le nombre d'objets HDF contenu dans le
 *                 datagroup passe en argument
 * - Parametres :
 *     - fid     (IN)     : l'ID du fichier HDF
 *     - chemin  (IN)     : chemin d'acces au datagroup
 *     - n       (OUT)    : le nombre recherche
 * - Resultat : 0 en cas de succes, -1 sinon
 */ 
med_err 
_MEDnObjets(med_idt fid,char *chemin,int *n)
{
  /*int idx;*/
  /*   if ((idx  = H5Giterate(fid,chemin,NULL,_MEDindiceNum,(void *)n)) < 0) */
  /*     return -1; */

  /* EF */
  med_err ret=-1;
  med_idt id=0;
  herr_t  err;
  hsize_t num_obj=0;

  if ( (id = H5Gopen(fid,chemin)) < 0   ) goto ERROR;

  if ( (err =H5Gget_num_objs(id,&num_obj) ) < 0 ) goto ERROR; 

  ret = 0;
  *n = (med_err) num_obj;

 ERROR:
  if (id) H5Gclose(id);

  return ret;
}
