#include "MEDversionedApi.hxx"

extern "C" {
#include "med_versioned.h"
#include <med_utils.h>
}

using namespace std;

static MED_VERSIONED_API & MedVersionedApi=MED_VERSIONED_API::Instance();

MED_VERSIONED_API& MED_VERSIONED_API::Instance() {
  static MED_VERSIONED_API obj;
  return obj;
}

void MED_VERSIONED_API::f77ApiIsSet() {
  //SSCRUTE ("initMedVersionedApiF thing");
  _f77ApiIsSet=true;
};

// Le mcanisme de driver permet de faire voluer la reprsentation des informations 
// dans les fichiers MED nouvellement cres en restant
// capable de lire des fichiers MED avec des reprsentations antrieures.
// Cela permet donc une compatibilit ascendante. 
//
// 1) Les modifications d'implmentations d'une routine qui rendent impossible/incohrent 
// la lecture d'anciens fichiers avec les nouvelles modifications necessitent
// le versionement de la routine dans cette table.   
// 
// 2) Les modifications d'implmentations d'une routine qui rendent impossible/incohrent 
// la lecture de nouveaux fichiers avec les anciennes bibliothques doivent galement faire 
// l'objet d'un  versionement dans cette table et non juste une modification dans les versions existantes. 
// Ex : L'implmentation de MEDchampEcr entre 232 et 233 pour la lecture des champs aux noeuds par maille.
//    La nouvelle bibliothque est capable de lire les anciens fichiers qui ne contiennent pas cette fonctionnalit.
//    Cependant les anciennes bibliothques ne sont pas capable de relire un fichier produit en 233 mme
//    si l'utilisateur veut ignorer la lecture de tels champs. En effet, MEDnChamp et MEDchampInfo nous indiqueront 
//    la prsence de champs qui seront illisible pour l'ancienne implmentation de l'API !
// Ceci permet  la nouvelle bibliothque qui lit un fichier 232 de se comporter comme la bibliothque 232 au cas
// ou le fichier aurait t corrompu dans son modle. 
// Dans l'exemple prcedent, si cette fonctionnalit n'avait pas eu d'impact sur le comportement 
// de MEDnChamp et MEDchampInfo en 232, il n'aurait pas t necessaire de marquer l'incompatibilit
// et donc de versionner cette routine. 
// La seule protection possible pour les bibliothques antrieures est de refuser la lecture de fichier MED dont le mineur
// est infrieur  celui de la bibliothque courante. (l'exemple prcdent est versionn sur le release au lieu du mineur, 
// la rgle de versionement MED n'a pas t respecte).
//
// Les routines versionnes dont les numros n'existent pas dans la version courante de la bibliothque 
// n'ont pas ts modifies depuis la version de la bibliothque qui correspond  leur numro de versionement.
// Lorsque les routines wrappers (MEDchampEcr pour MEDchampEcr231,MEDchampEcr232,MEDchampEcr233) demandent leur implmentation
//  getVersionedApi en fonction de la version avec laquelle le fichier trait  t cre, la premire implmentation 
// dont le numro de versionement est infrieur ou gal  celui du fichier est renvoye.
// getVersionedApi gre les ruptures de compatibilit globale de bibliothques (ex : on ne relit
// pas de fichiers < 220 avec les bibliothques 2.3.x.
// Dans ce mcanisme, il est galement necessaire de se protger d'une lecture de fichier dont le mineur du numro
// de version serait suprieur  celui de la bibliothque.
//
// Le versionement de la bibliothque MED dans le fichier Makefile.am n'indique rien 
// sur la compatibilit/incompatibilit descendante. 
// Seule la capacit des anciens programmes  utiliser cette nouvelle bibliothque dynamique est indique (ce qui
// sera toujours le cas avec le systme de driver si l'API utilisateur ne change pas (sauf ajout)).
// Si l'API utilisateur change le versionement libtool indique l'incompatibilit des anciens programmes  utiliser
// la nouvelle bibliothque. Le numro de version majeur de la bibliothque devrait galement tre incrmente.
// Si une nouvelle version majeure d'hdf est utilise et qu'elle est incompatible avec l'ancienne le numro majeur devrait
// tre galement augment.
//
// Si le numro de version mineur de la bibliothque avec laquelle le fichier  t cre est suprieur  celui de la
// version de bibliothque utilise la bibliothque doit renvoyer une erreur.
//
// Ceci implique qu'un ajout dans la table de versionement suppose l'incrment du numro mineur de
// la bibliothque pour plus de lisiblit par les utilisateurs quand  l'incompatibilit descendante :
// Une version de numro mineur antrieur  celui de la bibliotque MED courante ne pourra relire un fichier nouvellement
// cre par cette nouvelle version. Cel suppose galement que les numros de versions dont seuls la partie
// release change ne devrait pas apparaitre dans cette table. Ils correspondent  des corrections de BUG
// qui n'entrainent pas une incompatibilit descendante.     
//
// Ceci n'a pas toujours t respect, ex1: 231, 232, 233
// Par contre, ex2: 233 peut relire du 234
//
//
// En rsum le versionement dans MED doit fonctionner de la manire suivante  partir de la 2.3.4 :
//
// -  x.y.z+1 indique qu'il s'agit d'une correction de BUG qui n'engendre pas d'volution du modle
// ni d'incompatibilit de lecture de fichier avec x.y.z. Aucune nouvelle routine ne doit apparatre
// dans la table de versionement. Les programmes compils avec medx.y.z peuvent utiliser medx.y.z+1 sans 
// recompilation. Il y a donc compatibilit ascendante et descendante entre x.y.z z et x.y.z+1
//
// - x.y+1.z indique qu'il s'agit d'une correction de BUG et/ou volution qui engendre soit une volution
// du modle ou une incohrence avec l'utilisation de l'implmentation medx.y.z pour un fichier x.y+1.z.
//  L'API de la bibliothque ne change pas. Le systme de driver permet la compatibilit ascendante.
//  Il n'est pas necessaire de recompiler les programmes pour bnficier de cette nouvelle version
//  de la bibliothque. Il n'y a pas de compatibilit descendante entre x.y+1.z x.y.z
//
// - x+1.y.z indique que l'API MED a chang ou que la version d'HDF utilise n'est pas compatible
//   avec celle de x.y.z. La documentation indique si les drivers permettent d'assurer la compatibilit
//   ascendante. Il n'y a pas de compatibilit descendante avec x.y.z. Les programmes doivent tre recompils
//   et certainement modifis pour fonctionns avec x+1.Y.z
//
// REM : Ce container singleton est complt par les symboles fortran
//        l'appel de edfouv(...) dans la partie fortran de la bibliothque.
//       La mthode  f77ApiIsSet est alors appele.
//
MED_VERSIONED_API::MED_VERSIONED_API() : map<keyType,
					     MedFuncType>(),
					 _f77ApiIsSet(false)
{
  map<keyType,MedFuncType > &
    table  = ( map<keyType, 
	       MedFuncType > & ) *this ;
   table[ "MEDchampEcr231" ]           = MEDchampEcr231 ;
   table[ "MEDchampEcr232" ]           = MEDchampEcr232 ;
   table[ "MEDchampEcr233" ]           = MEDchampEcr233 ;
   table[ "MEDjointCr231" ]            = MEDjointCr231 ;
   table[ "MEDjointCr232" ]            = MEDjointCr232 ;
   table[ "MEDfamCr231" ]              = MEDfamCr231 ;
   table[ "MEDfamCr232" ]              = MEDfamCr232 ;
   table[ "_MEDdatasetNumEcrire231" ]  = _MEDdatasetNumEcrire231 ;
   table[ "_MEDdatasetNumEcrire232" ]  = _MEDdatasetNumEcrire232 ;
   table[ "_MEDdatasetNumLire231" ]    = _MEDdatasetNumLire231 ;
   table[ "_MEDdatasetNumLire232" ]    = _MEDdatasetNumLire232 ;
}


MedFuncType MED_VERSIONED_API::operator[]( const keyType & c ) const
{
  map<keyType,MedFuncType > &table = (map<keyType,
				   MedFuncType >&)*this ;

  map<keyType,MedFuncType >::iterator it = table.find( c );
  if ( it == table.end() ) return (MedFuncType) NULL;
  return (*it).second;
}


extern "C" MedFuncType 
getVersionedApi(const char * const keycharpart,
		const char * const keynumpart) {
  return MedVersionedApi[std::string(keycharpart)+std::string(keynumpart)];
}

extern "C" void f77ApiIsSet(void * obj) {
  static_cast<MED_VERSIONED_API*>(obj)->f77ApiIsSet();
}
