/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ObjectTransferable implements Transferable {

    public static final DataFlavor FLAVOR = new DataFlavor(Object.class, "Object");
    Object myValue;

    public ObjectTransferable(Object value) {
        myValue = value;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{FLAVOR};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == FLAVOR;
    }

    public Object getTransferData(DataFlavor flavor) throws
        UnsupportedFlavorException, IOException {
        if (flavor == FLAVOR) {
            return myValue;
        } else {
            throw new UnsupportedFlavorException(flavor);
        }
    }

}

