/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.daten;

import mediathek.Konstanten;

public class DatenBlacklist {

    public String[] arr;

    public DatenBlacklist() {
        makeArr();
    }

    public DatenBlacklist(String sender, String thema) {
        makeArr();
        arr[Konstanten.BLACKLIST_SENDER_NR] = sender;
        arr[Konstanten.BLACKLIST_THEMA_NR] = thema;
    }

    private void makeArr() {
        arr = new String[Konstanten.BLACKLIST_MAX_ELEM];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = "";
        }
    }
}
