/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.daten;

import mediathek.Konstanten;

public class DatenPod implements Comparable<DatenPod> {

    public String[] arr;

    public DatenPod() {
        makeArr();
    }

    public DatenPod(String name, String pfad, String ziel) {
        makeArr();
        arr[Konstanten.POD_NAME_NR] = name;
        arr[Konstanten.POD_URL_NR] = pfad;
        arr[Konstanten.POD_ZIELPFAD_NR] = ziel;
    }

    public DatenPod copy() {
        DatenPod ret = new DatenPod();
        for (int i = 0; i < Konstanten.POD_MAX_ELEM; ++i) {
            ret.arr[i] = this.arr[i];
        }
        return ret;
    }

    public void get(DatenPod pod) {
        for (int i = 0; i < Konstanten.POD_MAX_ELEM; ++i) {
            arr[i] = pod.arr[i];
        }
    }

    private void makeArr() {
        arr = new String[Konstanten.POD_MAX_ELEM];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new String("");
        }
    }

    @Override
    public int compareTo(DatenPod arg0) {
        return (arr[Konstanten.POD_NAME_NR].compareToIgnoreCase(((DatenPod) arg0).arr[Konstanten.POD_NAME_NR]));
    }

}
