/*
 *    Copyright (C) 2010
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme;

import javax.swing.event.EventListenerList;

/**
 *
 * @author emil
 */
public class MediathekTimer implements Runnable {

    private final int WARTEZEIT =  1000; // 1 Minuten
    private EventListenerList listeners = new EventListenerList();

    public void addAdListener(TimerListener listener) {
        listeners.add(TimerListener.class, listener);
    }

    public void reset() {
        notifyReset();
    }

    @Override
    public synchronized void run() {
        while (true) {
            try {
                Thread.sleep(WARTEZEIT);
            } catch (InterruptedException e) {
            }
            notifyTakt();
        }
    }

    private void notifyTakt() {
        for (TimerListener l : listeners.getListeners(TimerListener.class)) {
            l.ping();
        }
    }

    private void notifyReset() {
        for (TimerListener l : listeners.getListeners(TimerListener.class)) {
            l.reset();
        }
    }
}
