/*
 *    Copyright (C) 2010
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.wiz.panel;

import mediathek.wiz.wizard.WizPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 *
 * @author emil
 */
public class WizPanelButtonStart extends WizPanel {

    private WizDataButton wizData;

    /**
     *
     * @param wwizData
     */
    public WizPanelButtonStart(WizDataButton wwizData) {
        super("Erstellen oder Löschen", "Button anlegen oder löschen");
        initComponents();
        wizData = wwizData;
        jRadioButtonNeu.setSelected(wizData.neu);
        jRadioButtonAendern.addActionListener(new BeobRadio());
        jRadioButtonNeu.addActionListener(new BeobRadio());
        jRadioButtonLoeschen.addActionListener(new BeobRadio());
        radio();
    }

    private void radio() {
        wizData.neu = jRadioButtonNeu.isSelected();
        if (jRadioButtonNeu.isSelected()) {
            this.panelVor = "WizPanelButtonNeu";
        } else if (jRadioButtonLoeschen.isSelected()) {
            this.panelVor = "WizPanelButtonLoeschen";
        } else {
            this.panelVor = "WizPanelButtonAendern";
        }
    }
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jRadioButtonNeu = new javax.swing.JRadioButton();
        jRadioButtonAendern = new javax.swing.JRadioButton();
        jRadioButtonLoeschen = new javax.swing.JRadioButton();

        buttonGroup1.add(jRadioButtonNeu);
        jRadioButtonNeu.setSelected(true);
        jRadioButtonNeu.setText("einen neuen Button anlegen");
        jRadioButtonNeu.setName("jRadioButtonNeu"); // NOI18N

        buttonGroup1.add(jRadioButtonAendern);
        jRadioButtonAendern.setText("einen Button ändern");
        jRadioButtonAendern.setName("jRadioButtonAendern"); // NOI18N

        buttonGroup1.add(jRadioButtonLoeschen);
        jRadioButtonLoeschen.setText("einen Button löschen");
        jRadioButtonLoeschen.setName("jRadioButtonLoeschen"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jRadioButtonNeu)
                    .addComponent(jRadioButtonAendern)
                    .addComponent(jRadioButtonLoeschen))
                .addContainerGap(180, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jRadioButtonNeu)
                .addGap(18, 18, 18)
                .addComponent(jRadioButtonAendern)
                .addGap(18, 18, 18)
                .addComponent(jRadioButtonLoeschen)
                .addContainerGap(117, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JRadioButton jRadioButtonAendern;
    private javax.swing.JRadioButton jRadioButtonLoeschen;
    private javax.swing.JRadioButton jRadioButtonNeu;
    // End of variables declaration//GEN-END:variables

    private class BeobRadio implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            radio();
        }

    }

}
