/*
 * MediathekView
 * Copyright (C) 2008 W. Xaver
 * W.Xaver[at]googlemail.com
 * http://zdfmediathk.sourceforge.net/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import mediathek.daten.Daten;
import mediathek.res.GetIcon;
import mediathek.tool.GuiFunktionen;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;

public class PanelSenderLaden extends JPanel {

    private JButton[] buttonSender;
    private String[] senderArray;

    public PanelSenderLaden() {
        super();
        initComponents();
        jButtonStop.setIcon(GetIcon.getIcon("stop_16.png"));
        init();
    }

    private void init() {
        senderArray = Daten.filmeLaden.getSenderNamen();
        buttonSender = new JButton[senderArray.length];
        for (int i = 0; i < Daten.filmeLaden.getSenderNamen().length; ++i) {
            buttonSender[i] = new JButton(senderArray[i]);
            buttonSender[i].addActionListener(new BeobSenderLaden(senderArray[i]));
        }
        addSender();

        jButtonStop.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.filmeLaden.setStop(true);
            }
        });

        Daten.filmeLaden.addAdListener(new MSListenerFilmeLaden() {
            @Override
            public void progress(MSListenerFilmeLadenEvent event) {
                if (event.max == 0) {
                    jProgressBar1.setIndeterminate(true);
                    jProgressBar1.setMaximum(0);
                    jProgressBar1.setMinimum(0);
                    jProgressBar1.setValue(0);
                    jProgressBar1.setStringPainted(false);
                } else {
                    jProgressBar1.setIndeterminate(false);
                    jProgressBar1.setMaximum(event.max);
                    jProgressBar1.setMinimum(0);
                    jProgressBar1.setValue(event.progress);
                    jProgressBar1.setStringPainted(true);
                }
                jLabelProgress.setText(GuiFunktionen.textLaenge(80, event.text, true /* mitte */, false /*addVorne*/));
            }

            @Override
            public void fertig(MSListenerFilmeLadenEvent event) {
                jProgressBar1.setIndeterminate(false);
                jProgressBar1.setMaximum(0);
                jProgressBar1.setMinimum(0);
                jProgressBar1.setValue(0);
                jProgressBar1.setStringPainted(false);
                jLabelProgress.setText("");

                for (JButton button : buttonSender)
                    button.setEnabled(true);
            }
        });
    }

    private void addSender() {
        panelSender.removeAll();
        panelSender.setLayout(new GridLayout(0,5));
        int nr = 0;
        for (String sender : senderArray) {
            JButton btn = buttonSender[nr];
            btn.setText(sender);
            panelSender.add(btn);
            ++nr;
        }
        panelSender.repaint();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        panelSender = new javax.swing.JPanel();
        javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
        jProgressBar1 = new javax.swing.JProgressBar();
        jLabelProgress = new javax.swing.JLabel();
        jButtonStop = new javax.swing.JButton();

        panelSender.setBorder(javax.swing.BorderFactory.createTitledBorder("Sender"));

        javax.swing.GroupLayout panelSenderLayout = new javax.swing.GroupLayout(panelSender);
        panelSender.setLayout(panelSenderLayout);
        panelSenderLayout.setHorizontalGroup(
            panelSenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 78, Short.MAX_VALUE)
        );
        panelSenderLayout.setVerticalGroup(
            panelSenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 34, Short.MAX_VALUE)
        );

        jLabel1.setText("Filme von den Websiten der Sender laden, kann etwas dauern!");

        jLabelProgress.setText(" ");

        jButtonStop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/stop_16.png"))); // NOI18N
        jButtonStop.setToolTipText("Abbrechen");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabelProgress, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jProgressBar1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonStop))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(panelSender, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel1))
                        .addGap(0, 30, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(panelSender, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(72, 72, 72)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jProgressBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonStop))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelProgress)
                .addContainerGap(14, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonStop, jProgressBar1});

    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonStop;
    private javax.swing.JLabel jLabelProgress;
    private javax.swing.JProgressBar jProgressBar1;
    private javax.swing.JPanel panelSender;
    // End of variables declaration//GEN-END:variables

    private class BeobSenderLaden implements ActionListener {

        private final String sender;

        public BeobSenderLaden(String ssender) {
            sender = ssender;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            jLabelProgress.setText("");
            for (JButton aButtonSender : buttonSender) {
                aButtonSender.setEnabled(false);
            }
            Daten.filmeLaden.updateSender(new String[]{sender}  /* senderAllesLaden */);
        }
    }

}
